/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.ide.MacOSApplicationProvider;
import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.AbstractSyntaxAwareInputStreamTransferableData;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;

public class RtfTransferableData
extends AbstractSyntaxAwareInputStreamTransferableData {
    @NotNull
    public static final DataFlavor FLAVOR = new DataFlavor("text/rtf;class=java.io.InputStream", "RTF text");
    @NotNull
    private static final String HEADER_PREFIX = "{\\rtf1\\ansi\\deff0";
    @NotNull
    private static final String HEADER_SUFFIX = "}";
    @NotNull
    private static final String TAB = "\\tab\n";
    @NotNull
    private static final String NEW_LINE = "\\line\n";
    @NotNull
    private static final String BOLD = "\\b";
    @NotNull
    private static final String ITALIC = "\\i";

    public RtfTransferableData(@NotNull SyntaxInfo syntaxInfo) {
        if (syntaxInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxInfo", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData", "<init>"));
        }
        super(syntaxInfo, FLAVOR);
    }

    @Override
    protected void build(@NotNull StringBuilder holder, int maxLength) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData", "build"));
        }
        holder.append(HEADER_PREFIX);
        holder.append("{\\colortbl;");
        ColorRegistry colorRegistry = this.mySyntaxInfo.getColorRegistry();
        for (int id : colorRegistry.getAllIds()) {
            Color color = (Color)colorRegistry.dataById(id);
            int[] components = RtfTransferableData.getAdjustedColorComponents(color);
            holder.append(String.format("\\red%d\\green%d\\blue%d;", components[0], components[1], components[2]));
        }
        holder.append("}\n");
        holder.append("{\\fonttbl");
        FontNameRegistry fontNameRegistry = this.mySyntaxInfo.getFontNameRegistry();
        for (int id : fontNameRegistry.getAllIds()) {
            String fontName = (String)fontNameRegistry.dataById(id);
            holder.append(String.format("{\\f%d %s;}", id, fontName));
        }
        holder.append("}\n");
        holder.append("\n\\s0\\box").append("\\cbpat").append(this.mySyntaxInfo.getDefaultBackground()).append("\\cb").append(this.mySyntaxInfo.getDefaultBackground()).append("\\cf").append(this.mySyntaxInfo.getDefaultForeground());
        RtfTransferableData.addFontSize(holder, this.mySyntaxInfo.getFontSize());
        holder.append('\n');
        this.mySyntaxInfo.processOutputInfo(new MyVisitor(holder, this.myRawText, this.mySyntaxInfo, maxLength));
        holder.append("\\par");
        holder.append(HEADER_SUFFIX);
    }

    private static int[] getAdjustedColorComponents(Color color) {
        ColorSpace genericRgbSpace;
        if (SystemInfo.isMac && (genericRgbSpace = MacOSApplicationProvider.getInstance().getGenericRgbColorSpace()) != null) {
            float[] components = genericRgbSpace.fromRGB(color.getRGBColorComponents(null));
            return new int[]{RtfTransferableData.colorComponentFloatToInt(components[0]), RtfTransferableData.colorComponentFloatToInt(components[1]), RtfTransferableData.colorComponentFloatToInt(components[2])};
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    private static int colorComponentFloatToInt(float component) {
        return (int)(component * 255.0f + 0.5f);
    }

    @Override
    @NotNull
    protected String getCharset() {
        if ("US-ASCII" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData", "getCharset"));
        }
        return "US-ASCII";
    }

    private static void addFontSize(StringBuilder buffer, float fontSize) {
        buffer.append("\\fs").append(Math.round(fontSize * 2.0f));
    }

    private static class MyVisitor
    implements MarkupHandler {
        @NotNull
        private final StringBuilder myBuffer;
        @NotNull
        private final String myRawText;
        private final int myMaxLength;
        private final int myDefaultBackgroundId;
        private final float myFontSize;
        private int myForegroundId;
        private int myFontNameId;
        private int myFontStyle;

        MyVisitor(@NotNull StringBuilder buffer, @NotNull String rawText, @NotNull SyntaxInfo syntaxInfo, int maxLength) {
            if (buffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData$MyVisitor", "<init>"));
            }
            if (rawText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawText", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData$MyVisitor", "<init>"));
            }
            if (syntaxInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntaxInfo", "com/intellij/openapi/editor/richcopy/view/RtfTransferableData$MyVisitor", "<init>"));
            }
            this.myForegroundId = -1;
            this.myFontNameId = -1;
            this.myFontStyle = -1;
            this.myBuffer = buffer;
            this.myRawText = rawText;
            this.myMaxLength = maxLength;
            this.myDefaultBackgroundId = syntaxInfo.getDefaultBackground();
            this.myFontSize = syntaxInfo.getFontSize();
        }

        @Override
        public void handleText(int startOffset, int endOffset) throws Exception {
            this.myBuffer.append("\n");
            block5: for (int i2 = startOffset; i2 < endOffset; ++i2) {
                char c = this.myRawText.charAt(i2);
                if (c > '\u007f') {
                    this.myBuffer.append(String.format("\\u%04d?", c));
                    continue;
                }
                switch (c) {
                    case '\t': {
                        this.myBuffer.append(RtfTransferableData.TAB);
                        continue block5;
                    }
                    case '\n': {
                        this.myBuffer.append(RtfTransferableData.NEW_LINE);
                        continue block5;
                    }
                    case '\\': 
                    case '{': 
                    case '}': {
                        this.myBuffer.append('\\');
                    }
                    default: {
                        this.myBuffer.append(c);
                    }
                }
            }
        }

        @Override
        public void handleBackground(int backgroundId) throws Exception {
            if (backgroundId == this.myDefaultBackgroundId) {
                this.myBuffer.append("\\plain");
                RtfTransferableData.addFontSize(this.myBuffer, this.myFontSize);
                if (this.myFontNameId >= 0) {
                    this.handleFont(this.myFontNameId);
                }
                if (this.myForegroundId >= 0) {
                    this.handleForeground(this.myForegroundId);
                }
                if (this.myFontStyle >= 0) {
                    this.handleStyle(this.myFontStyle);
                }
            } else {
                this.myBuffer.append("\\chcbpat").append(backgroundId);
            }
            this.myBuffer.append("\\cb").append(backgroundId);
            this.myBuffer.append('\n');
        }

        @Override
        public void handleForeground(int foregroundId) throws Exception {
            this.myBuffer.append("\\cf").append(foregroundId).append('\n');
            this.myForegroundId = foregroundId;
        }

        @Override
        public void handleFont(int fontNameId) throws Exception {
            this.myBuffer.append("\\f").append(fontNameId).append('\n');
            this.myFontNameId = fontNameId;
        }

        @Override
        public void handleStyle(int style) throws Exception {
            this.myBuffer.append(RtfTransferableData.ITALIC);
            if ((style & 2) == 0) {
                this.myBuffer.append('0');
            }
            this.myBuffer.append(RtfTransferableData.BOLD);
            if ((style & 1) == 0) {
                this.myBuffer.append('0');
            }
            this.myBuffer.append('\n');
            this.myFontStyle = style;
        }

        @Override
        public boolean canHandleMore() {
            if (this.myBuffer.length() > this.myMaxLength) {
                this.myBuffer.append("... truncated ...");
                return false;
            }
            return true;
        }
    }
}

