/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.SelectionModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import java.awt.Component;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentSelectionModel
implements SelectionModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;

    public TextComponentSelectionModel(@NotNull JTextComponent textComponent, @NotNull TextComponentEditor textComponentEditor) {
        if (textComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponent", "com/intellij/openapi/editor/textarea/TextComponentSelectionModel", "<init>"));
        }
        if (textComponentEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textComponentEditor", "com/intellij/openapi/editor/textarea/TextComponentSelectionModel", "<init>"));
        }
        this.myTextComponent = textComponent;
        this.myEditor = textComponentEditor;
    }

    public int getSelectionStart() {
        return this.myTextComponent.getSelectionStart();
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return null;
    }

    public int getSelectionEnd() {
        return this.myTextComponent.getSelectionEnd();
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return null;
    }

    @Nullable
    public String getSelectedText() {
        return this.myTextComponent.getSelectedText();
    }

    @Nullable
    public String getSelectedText(boolean allCarets) {
        return this.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        int caretPosition = this.myTextComponent.getCaretPosition();
        int start = this.myTextComponent.getSelectionStart();
        int end = this.myTextComponent.getSelectionEnd();
        return caretPosition == start ? end : start;
    }

    @Nullable
    public VisualPosition getLeadSelectionPosition() {
        return null;
    }

    public boolean hasSelection() {
        return this.myTextComponent.getSelectionStart() != this.myTextComponent.getSelectionEnd();
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (this.myTextComponent.getCaretPosition() == startOffset) {
            this.myTextComponent.setCaretPosition(endOffset);
            this.myTextComponent.moveCaretPosition(startOffset);
        } else {
            this.myTextComponent.setCaretPosition(startOffset);
            this.myTextComponent.moveCaretPosition(endOffset);
        }
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        this.setSelection(startOffset, endOffset);
    }

    public void removeSelection() {
        int position = this.myTextComponent.getCaretPosition();
        this.myTextComponent.select(position, position);
    }

    public void removeSelection(boolean allCarets) {
        this.removeSelection();
    }

    public void addSelectionListener(SelectionListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeSelectionListener(SelectionListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void selectLineAtCaret() {
        SelectionModelImpl.doSelectLineAtCaret(this.myEditor.getCaretModel().getPrimaryCaret());
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler2.execute((Editor)this.myEditor, null, DataManager.getInstance().getDataContext((Component)this.myEditor.getComponent()));
    }

    public void copySelectionToClipboard() {
        EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStart", "com/intellij/openapi/editor/textarea/TextComponentSelectionModel", "setBlockSelection"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "com/intellij/openapi/editor/textarea/TextComponentSelectionModel", "setBlockSelection"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public TextAttributes getTextAttributes() {
        return null;
    }
}

