/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.TextEditorProvider");
    private static final Key<TextEditor> TEXT_EDITOR_KEY = Key.create((String)"textEditor");
    @NonNls
    private static final String TYPE_ID = "text-editor";
    @NonNls
    private static final String LINE_ATTR = "line";
    @NonNls
    private static final String COLUMN_ATTR = "column";
    @NonNls
    private static final String LEAN_FORWARD_ATTR = "lean-forward";
    @NonNls
    private static final String SELECTION_START_LINE_ATTR = "selection-start-line";
    @NonNls
    private static final String SELECTION_START_COLUMN_ATTR = "selection-start-column";
    @NonNls
    private static final String SELECTION_END_LINE_ATTR = "selection-end-line";
    @NonNls
    private static final String SELECTION_END_COLUMN_ATTR = "selection-end-column";
    @NonNls
    private static final String RELATIVE_CARET_POSITION_ATTR = "relative-caret-position";
    @NonNls
    private static final String CARET_ELEMENT = "caret";

    public static TextEditorProvider getInstance() {
        return (TextEditorProvider)ApplicationManager.getApplication().getComponent(TextEditorProvider.class);
    }

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "accept"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "accept"));
        }
        return TextEditorProvider.isTextFile(file2) && !SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "createEditor"));
        }
        LOG.assertTrue(this.accept(project2, file2));
        TextEditorImpl textEditorImpl = new TextEditorImpl(project2, file2, this);
        if (textEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "createEditor"));
        }
        return textEditorImpl;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "readState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "readState"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "readState"));
        }
        TextEditorState state = new TextEditorState();
        try {
            List caretElements = element.getChildren(CARET_ELEMENT);
            if (caretElements.isEmpty()) {
                state.CARETS = new TextEditorState.CaretState[]{TextEditorProvider.readCaretInfo(element)};
            } else {
                state.CARETS = new TextEditorState.CaretState[caretElements.size()];
                for (int i2 = 0; i2 < caretElements.size(); ++i2) {
                    state.CARETS[i2] = TextEditorProvider.readCaretInfo((Element)caretElements.get(i2));
                }
            }
            String verticalScrollProportion = element.getAttributeValue(RELATIVE_CARET_POSITION_ATTR);
            state.RELATIVE_CARET_POSITION = verticalScrollProportion == null ? 0 : Integer.parseInt(verticalScrollProportion);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "readState"));
        }
        return textEditorState;
    }

    private static TextEditorState.CaretState readCaretInfo(Element element) {
        TextEditorState.CaretState caretState = new TextEditorState.CaretState();
        caretState.LINE = TextEditorProvider.parseWithDefault(element, LINE_ATTR);
        caretState.COLUMN = TextEditorProvider.parseWithDefault(element, COLUMN_ATTR);
        caretState.LEAN_FORWARD = TextEditorProvider.parseBooleanWithDefault(element, LEAN_FORWARD_ATTR);
        caretState.SELECTION_START_LINE = TextEditorProvider.parseWithDefault(element, SELECTION_START_LINE_ATTR);
        caretState.SELECTION_START_COLUMN = TextEditorProvider.parseWithDefault(element, SELECTION_START_COLUMN_ATTR);
        caretState.SELECTION_END_LINE = TextEditorProvider.parseWithDefault(element, SELECTION_END_LINE_ATTR);
        caretState.SELECTION_END_COLUMN = TextEditorProvider.parseWithDefault(element, SELECTION_END_COLUMN_ATTR);
        return caretState;
    }

    private static int parseWithDefault(Element element, String attributeName) {
        String value = element.getAttributeValue(attributeName);
        return value == null ? 0 : Integer.parseInt(value);
    }

    private static boolean parseBooleanWithDefault(Element element, String attributeName) {
        String value = element.getAttributeValue(attributeName);
        return value != null && Boolean.parseBoolean(value);
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project2, @NotNull Element element) {
        if (_state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_state", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "writeState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "writeState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "writeState"));
        }
        TextEditorState state = (TextEditorState)_state;
        element.setAttribute(RELATIVE_CARET_POSITION_ATTR, Integer.toString(state.RELATIVE_CARET_POSITION));
        if (state.CARETS != null) {
            for (TextEditorState.CaretState caretState : state.CARETS) {
                Element e = new Element(CARET_ELEMENT);
                e.setAttribute(LINE_ATTR, Integer.toString(caretState.LINE));
                e.setAttribute(COLUMN_ATTR, Integer.toString(caretState.COLUMN));
                e.setAttribute(LEAN_FORWARD_ATTR, Boolean.toString(caretState.LEAN_FORWARD));
                e.setAttribute(SELECTION_START_LINE_ATTR, Integer.toString(caretState.SELECTION_START_LINE));
                e.setAttribute(SELECTION_START_COLUMN_ATTR, Integer.toString(caretState.SELECTION_START_COLUMN));
                e.setAttribute(SELECTION_END_LINE_ATTR, Integer.toString(caretState.SELECTION_END_LINE));
                e.setAttribute(SELECTION_END_COLUMN_ATTR, Integer.toString(caretState.SELECTION_END_COLUMN));
                element.addContent(e);
            }
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getEditorTypeId"));
        }
        return TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.NONE;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    @NotNull
    public TextEditor getTextEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getTextEditor"));
        }
        TextEditor textEditor = (TextEditor)editor.getUserData(TEXT_EDITOR_KEY);
        if (textEditor == null) {
            textEditor = this.createWrapperForEditor(editor);
            TextEditorProvider.putTextEditor(editor, textEditor);
        }
        TextEditor textEditor2 = textEditor;
        if (textEditor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getTextEditor"));
        }
        return textEditor2;
    }

    @NotNull
    protected EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "createWrapperForEditor"));
        }
        EditorWrapper editorWrapper = new EditorWrapper(editor);
        if (editorWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "createWrapperForEditor"));
        }
        return editorWrapper;
    }

    @Nullable
    public static Document[] getDocuments(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getDocuments"));
        }
        if (editor instanceof DocumentsEditor) {
            DocumentsEditor documentsEditor = (DocumentsEditor)editor;
            Document[] documents = documentsEditor.getDocuments();
            return documents.length > 0 ? documents : null;
        }
        if (editor instanceof TextEditor) {
            Document document = ((TextEditor)editor).getEditor().getDocument();
            return new Document[]{document};
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        for (int i2 = projects.length - 1; i2 >= 0; --i2) {
            Document document;
            VirtualFile file2 = FileEditorManagerEx.getInstanceEx(projects[i2]).getFile(editor);
            if (file2 == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            return new Document[]{document};
        }
        return null;
    }

    static void putTextEditor(Editor editor, TextEditor textEditor) {
        editor.putUserData(TEXT_EDITOR_KEY, (Object)textEditor);
    }

    protected TextEditorState getStateImpl(Project project2, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getStateImpl"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "getStateImpl"));
        }
        TextEditorState state = new TextEditorState();
        if (!Registry.is((String)"editor.new.rendering") && editor instanceof EditorImpl && ((EditorImpl)editor).myUseNewRendering) {
            return state;
        }
        CaretModel caretModel = editor.getCaretModel();
        if (caretModel.supportsMultipleCarets()) {
            List caretsAndSelections = caretModel.getCaretsAndSelections();
            state.CARETS = new TextEditorState.CaretState[caretsAndSelections.size()];
            for (int i2 = 0; i2 < caretsAndSelections.size(); ++i2) {
                CaretState caretState = (CaretState)caretsAndSelections.get(i2);
                LogicalPosition caretPosition = caretState.getCaretPosition();
                LogicalPosition selectionStartPosition = caretState.getSelectionStart();
                LogicalPosition selectionEndPosition = caretState.getSelectionEnd();
                state.CARETS[i2] = TextEditorProvider.createCaretState(caretPosition, selectionStartPosition, selectionEndPosition);
            }
        } else {
            LogicalPosition caretPosition = caretModel.getLogicalPosition();
            LogicalPosition selectionStartPosition = editor.offsetToLogicalPosition(editor.getSelectionModel().getSelectionStart());
            LogicalPosition selectionEndPosition = editor.offsetToLogicalPosition(editor.getSelectionModel().getSelectionEnd());
            state.CARETS = new TextEditorState.CaretState[1];
            state.CARETS[0] = TextEditorProvider.createCaretState(caretPosition, selectionStartPosition, selectionEndPosition);
        }
        state.RELATIVE_CARET_POSITION = level == FileEditorStateLevel.UNDO ? Integer.MAX_VALUE : EditorUtil.calcRelativeCaretPosition(editor);
        return state;
    }

    public static boolean isTextFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider", "isTextFile"));
        }
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        FileType ft = file2.getFileType();
        return !ft.isBinary() || BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static TextEditorState.CaretState createCaretState(LogicalPosition caretPosition, LogicalPosition selectionStartPosition, LogicalPosition selectionEndPosition) {
        TextEditorState.CaretState caretState = new TextEditorState.CaretState();
        caretState.LINE = TextEditorProvider.getLine(caretPosition);
        caretState.COLUMN = TextEditorProvider.getColumn(caretPosition);
        caretState.LEAN_FORWARD = caretPosition != null && caretPosition.leansForward;
        caretState.SELECTION_START_LINE = TextEditorProvider.getLine(selectionStartPosition);
        caretState.SELECTION_START_COLUMN = TextEditorProvider.getColumn(selectionStartPosition);
        caretState.SELECTION_END_LINE = TextEditorProvider.getLine(selectionEndPosition);
        caretState.SELECTION_END_COLUMN = TextEditorProvider.getColumn(selectionEndPosition);
        return caretState;
    }

    private static int getLine(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.line;
    }

    private static int getColumn(@Nullable LogicalPosition pos) {
        return pos == null ? 0 : pos.column;
    }

    protected void setStateImpl(Project project2, Editor editor, TextEditorState state) {
        if (state.CARETS != null && state.CARETS.length > 0) {
            if (editor.getCaretModel().supportsMultipleCarets()) {
                CaretModel caretModel = editor.getCaretModel();
                ArrayList<CaretState> states = new ArrayList<CaretState>(state.CARETS.length);
                for (TextEditorState.CaretState caretState : state.CARETS) {
                    states.add(new CaretState(new LogicalPosition(caretState.LINE, caretState.COLUMN, caretState.LEAN_FORWARD), new LogicalPosition(caretState.SELECTION_START_LINE, caretState.SELECTION_START_COLUMN), new LogicalPosition(caretState.SELECTION_END_LINE, caretState.SELECTION_END_COLUMN)));
                }
                caretModel.setCaretsAndSelections(states, false);
            } else {
                TextEditorState.CaretState caretState = state.CARETS[0];
                LogicalPosition pos = new LogicalPosition(caretState.LINE, caretState.COLUMN);
                editor.getCaretModel().moveToLogicalPosition(pos);
                int startOffset = editor.logicalPositionToOffset(new LogicalPosition(caretState.SELECTION_START_LINE, caretState.SELECTION_START_COLUMN));
                int endOffset = editor.logicalPositionToOffset(new LogicalPosition(caretState.SELECTION_END_LINE, caretState.SELECTION_END_COLUMN));
                if (startOffset == endOffset) {
                    editor.getSelectionModel().removeSelection();
                } else {
                    editor.getSelectionModel().setSelection(startOffset, endOffset);
                }
            }
        }
        int relativeCaretPosition = state.RELATIVE_CARET_POSITION;
        UiNotifyConnector.doWhenFirstShown((JComponent)editor.getContentComponent(), () -> {
            if (!editor.isDisposed()) {
                editor.getScrollingModel().disableAnimation();
                if (relativeCaretPosition != Integer.MAX_VALUE) {
                    EditorUtil.setRelativeCaretPosition(editor, relativeCaretPosition);
                }
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getScrollingModel().enableAnimation();
            }
        });
    }

    protected class EditorWrapper
    extends UserDataHolderBase
    implements TextEditor {
        private final Editor myEditor;

        public EditorWrapper(Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "<init>"));
            }
            this.myEditor = editor;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "getEditor"));
            }
            return editor;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myEditor.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "getComponent"));
            }
            return jComponent;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getContentComponent();
        }

        @NotNull
        public String getName() {
            if ("Text" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "getName"));
            }
            return "Text";
        }

        public StructureViewBuilder getStructureViewBuilder() {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
            if (file2 == null) {
                return null;
            }
            Project project2 = this.myEditor.getProject();
            LOG.assertTrue(project2 != null);
            return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, project2);
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "getState"));
            }
            TextEditorState textEditorState = TextEditorProvider.this.getStateImpl(null, this.myEditor, level);
            if (textEditorState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "getState"));
            }
            return textEditorState;
        }

        public void setState(@NotNull FileEditorState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "setState"));
            }
            TextEditorProvider.this.setStateImpl(null, this.myEditor, (TextEditorState)state);
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void dispose() {
        }

        public void selectNotify() {
        }

        public void deselectNotify() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "addPropertyChangeListener"));
            }
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "removePropertyChangeListener"));
            }
        }

        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return null;
        }

        public FileEditorLocation getCurrentLocation() {
            return null;
        }

        public boolean canNavigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "canNavigateTo"));
            }
            return false;
        }

        public void navigateTo(@NotNull Navigatable navigatable) {
            if (navigatable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper", "navigateTo"));
            }
        }
    }
}

