/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.FilteredQuery;
import org.jetbrains.annotations.Nullable;

public class ResourceFileUtil {
    private ResourceFileUtil() {
    }

    @Nullable
    public static VirtualFile findResourceFileInDependents(Module searchFromModule, String fileName) {
        return ResourceFileUtil.findResourceFileInScope(fileName, searchFromModule.getProject(), searchFromModule.getModuleWithDependenciesScope());
    }

    @Nullable
    public static VirtualFile findResourceFileInProject(Project project2, String resourceName) {
        return ResourceFileUtil.findResourceFileInScope(resourceName, project2, GlobalSearchScope.projectScope((Project)project2));
    }

    @Nullable
    public static VirtualFile findResourceFileInScope(String resourceName, Project project2, GlobalSearchScope scope) {
        int index = resourceName.lastIndexOf(47);
        String packageName = index >= 0 ? resourceName.substring(0, index).replace('/', '.') : "";
        String fileName = index >= 0 ? resourceName.substring(index + 1) : resourceName;
        VirtualFile dir = (VirtualFile)new FilteredQuery(DirectoryIndex.getInstance(project2).getDirectoriesByPackageName(packageName, false), file2 -> {
            VirtualFile child = file2.findChild(fileName);
            return child != null && scope.contains(child);
        }).findFirst();
        return dir != null ? dir.findChild(fileName) : null;
    }
}

