/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements ProjectComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerImpl");
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    public static final String IML_EXTENSION = ".iml";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel = new ModuleModelImpl();
    @NonNls
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    private static final String MODULE_GROUP_SEPARATOR = "/";
    private List<ModulePath> myModulePaths;
    private final List<ModulePath> myFailedModulePaths = new ArrayList<ModulePath>();
    @NonNls
    public static final String ELEMENT_MODULES = "modules";
    @NonNls
    public static final String ELEMENT_MODULE = "module";
    @NonNls
    private static final String ATTRIBUTE_FILEURL = "fileurl";
    @NonNls
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    @NonNls
    private static final String ATTRIBUTE_GROUP = "group";
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project2) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project2);
    }

    public ModuleManagerImpl(Project project2, MessageBus messageBus) {
        this.myProject = project2;
        this.myMessageBus = messageBus;
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myModuleModel.disposeModel();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(Element state) {
        List<ModulePath> prevPaths = this.myModulePaths;
        this.readExternal(state);
        if (prevPaths != null) {
            ModifiableModuleModel model = this.getModifiableModel();
            Module[] existingModules = model.getModules();
            ModuleGroupInterner groupInterner = new ModuleGroupInterner();
            for (Module existingModule : existingModules) {
                Object[] group;
                ModulePath correspondingPath = this.findCorrespondingPath(existingModule);
                if (correspondingPath == null) {
                    model.disposeModule(existingModule);
                    continue;
                }
                this.myModulePaths.remove(correspondingPath);
                String groupStr = correspondingPath.getModuleGroup();
                Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
                if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
                groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
            }
            this.loadModules((ModuleModelImpl)model);
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        }
    }

    private ModulePath findCorrespondingPath(@NotNull Module existingModule) {
        if (existingModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findCorrespondingPath"));
        }
        for (ModulePath modulePath : this.myModulePaths) {
            if (!modulePath.getPath().equals(existingModule.getModuleFilePath())) continue;
            return modulePath;
        }
        return null;
    }

    @NotNull
    public static ModulePath[] getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        ArrayList<ModulePath> paths = new ArrayList<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue != null ? VirtualFileManager.extractPath((String)fileUrlValue).replace('/', File.separatorChar) : moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH).replace('/', File.separatorChar);
                String group = moduleElement.getAttributeValue(ATTRIBUTE_GROUP);
                paths.add(new ModulePath(filepath, group));
            }
        }
        ModulePath[] modulePathArray = paths.toArray(new ModulePath[paths.size()]);
        if (modulePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        return modulePathArray;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "readExternal"));
        }
        this.myModulePaths = new ArrayList<ModulePath>(Arrays.asList(ModuleManagerImpl.getPathsToModuleFiles(element)));
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        ProgressIndicator progressIndicator;
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModules"));
        }
        if (this.myModulePaths == null || this.myModulePaths.isEmpty()) {
            return;
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ProgressIndicator progressIndicator2 = progressIndicator = this.myProject.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText("Loading modules...");
            progressIndicator.setText2("");
        }
        this.myFailedModulePaths.clear();
        this.myFailedModulePaths.addAll(this.myModulePaths);
        ArrayList<Module> modulesWithUnknownTypes = new ArrayList<Module>();
        ArrayList<ModuleLoadingErrorDescription> errors = new ArrayList<ModuleLoadingErrorDescription>();
        for (ModulePath modulePath : this.myModulePaths) {
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
                progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
            }
            try {
                String groupPathString;
                Module module2 = moduleModel.loadModuleInternal(modulePath.getPath());
                if (this.isUnknownModuleType(module2)) {
                    modulesWithUnknownTypes.add(module2);
                }
                if ((groupPathString = modulePath.getModuleGroup()) != null) {
                    String[] groupPath = groupPathString.split(MODULE_GROUP_SEPARATOR);
                    groupInterner.setModuleGroupPath(moduleModel, module2, groupPath);
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (IOException e) {
                errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                errors.add(ModuleLoadingErrorDescription.create(moduleWithNameAlreadyExists.getMessage(), modulePath, this));
            }
        }
        this.onModuleLoadErrors(errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
    }

    public int getModulePathsCount() {
        return this.myModulePaths == null ? 0 : this.myModulePaths.size();
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isUnknownModuleType"));
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/module/impl/ModuleManagerImpl", "showUnknownModuleTypeNotification"));
        }
    }

    protected void fireModuleAdded(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAdded"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module2);
    }

    protected void fireModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRemoved"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module2);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireBeforeModuleRemoved"));
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module2);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULES, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (oldNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (!modules.isEmpty()) {
            ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules, module2 -> {
                if (oldNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModulesRenamed$1"));
                }
                return (String)oldNames.get(module2);
            });
        }
    }

    protected void onModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(this.myModuleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module2 = this.myModuleModel.getModuleByFilePath(FileUtil.toSystemIndependentName((String)error.getModulePath().getPath()));
            if (module2 == null) continue;
            this.myModuleModel.myModules.remove(module2.getName());
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module2), module2.getDisposed());
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleLoadErrors"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "removeFailedModulePath"));
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModifiableModel"));
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "writeExternal"));
        }
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size());
        for (Module module2 : collection) {
            sorted.add(new ModuleSaveItem(module2));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, (item1, item2) -> item1.getModuleName().compareTo(item2.getModuleName()));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        return module3;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module2 = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module3 = module2;
        if (module3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        return module3;
    }

    public void disposeModule(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "disposeModule"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$disposeModule$4"));
            }
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module2);
            modifiableModel.commit();
        });
    }

    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getSortedModules"));
        }
        return this.myCachedSortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findModuleByName"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator2 = this.myCachedModuleComparator;
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleDependencyComparator"));
        }
        return comparator2;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List list = this.myModuleModel.getModuleDependentModules(module2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        return list;
    }

    public boolean isModuleDependent(@NotNull Module module2, @NotNull Module onModule) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.isModuleDependent(module2, onModule);
    }

    public void projectOpened() {
        this.fireModulesAdded();
        this.myModuleModel.projectOpened();
    }

    protected void fireModulesAdded() {
        for (Module module2 : this.myModuleModel.myModules.values()) {
            this.fireModuleAddedInWriteAction(module2);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAddedInWriteAction"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleAddedInWriteAction$5"));
            }
            ((ModuleEx)module2).moduleAdded();
            this.fireModuleAdded(module2);
        });
    }

    public void projectClosed() {
        this.myModuleModel.projectClosed();
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable2) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl", "commitModelWithRunnable"));
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(ModuleModelImpl moduleModel, Runnable runnable2) {
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection<Module> oldModules = this.myModuleModel.myModules.values();
        Collection<Module> newModules = moduleModel.myModules.values();
        ArrayList<Module> removedModules = new ArrayList<Module>(oldModules);
        removedModules.removeAll(newModules);
        ArrayList<Module> addedModules = new ArrayList<Module>(newModules);
        addedModules.removeAll(oldModules);
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {
            for (Object removedModule : removedModules) {
                this.fireBeforeModuleRemoved((Module)removedModule);
                this.cleanCachedStuff();
            }
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(this.myModuleModel.myModules.values());
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                Disposer.dispose((Disposable)neverAddedModule);
            }
            if (runnable2 != null) {
                runnable2.run();
            }
            Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
            Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
            modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
            ArrayList<Module> modules = new ArrayList<Module>();
            HashMap oldNames = ContainerUtil.newHashMap();
            for (Module module2 : modulesToBeRenamed) {
                oldNames.put(module2, module2.getName());
                moduleModel.myModules.remove(module2.getName());
                modules.add(module2);
                ((ModuleEx)module2).rename((String)modulesToNewNamesMap.get(module2));
                moduleModel.myModules.put(module2.getName(), module2);
            }
            moduleModel.myIsWritable = false;
            this.myModuleModel = moduleModel;
            for (Module module2 : removedModules) {
                this.fireModuleRemoved(module2);
                this.cleanCachedStuff();
                Disposer.dispose((Disposable)module2);
                this.cleanCachedStuff();
            }
            for (Module addedModule : addedModules) {
                ((ModuleEx)addedModule).moduleAdded();
                this.cleanCachedStuff();
                this.fireModuleAdded(addedModule);
                this.cleanCachedStuff();
            }
            this.cleanCachedStuff();
            this.fireModulesRenamed(modules, oldNames);
            this.cleanCachedStuff();
        }, false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module2, @NotNull String oldName) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        Module moduleInMap = this.myModuleModel.myModules.remove(oldName);
        LOG.assertTrue(moduleInMap == null || moduleInMap == module2);
        this.myModuleModel.myModules.put(module2.getName(), module2);
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(() -> {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$7"));
            }
            if (oldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$7"));
            }
            this.fireModulesRenamed(Collections.singletonList(module2), Collections.singletonMap(module2, oldName));
        }, false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleGroupPath"));
        }
        return this.myModuleModel.getModuleGroupPath(module2);
    }

    public void setModuleGroupPath(Module module2, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module2, groupPath);
    }

    class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;

        private ModuleModelImpl() {
            this.myModules = new LinkedHashMap();
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myIsWritable = false;
        }

        private ModuleModelImpl(ModuleModelImpl that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = new LinkedHashMap();
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap();
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        @NotNull
        public Module[] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                this.myModulesCache = cache = modules.toArray(new Module[modules.size()]);
            }
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModules"));
            }
            return cache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getSortedModules"));
            }
            return allModules;
        }

        public void renameModule(@NotNull Module module2, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module2));
            if (module2.getName().equals(newName)) {
                this.myModuleToNewName.remove(module2);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module2, newName);
                this.myNewNameToModule.put(newName, module2);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleToBeRenamed"));
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByNewName"));
            }
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getNewName"));
            }
            return this.myModuleToNewName.get(module2);
        }

        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            Module module2 = this.newModule(filePath, moduleTypeId, null);
            if (module2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return module2;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            if (moduleTypeId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName((String)this.resolveShortWindowsName(filePath));
            ModuleEx module2 = this.getModuleByFilePath(filePath);
            if (module2 == null) {
                ModuleEx newModule = module2 = ModuleManagerImpl.this.createModule(filePath);
                this.initModule(module2, filePath, () -> {
                    if (moduleTypeId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "lambda$newModule$0"));
                    }
                    newModule.setOption("type", moduleTypeId);
                    if (options != null) {
                        for (Map.Entry option : options.entrySet()) {
                            newModule.setOption((String)option.getKey(), (String)option.getValue());
                        }
                    }
                });
            }
            ModuleEx moduleEx = module2;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return moduleEx;
        }

        @NotNull
        private String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
                }
                return string2;
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByFilePath"));
            }
            for (Module module2 : this.myModules.values()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module2.getModuleFilePath().equals(filePath) : module2.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module2;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
            Module module2;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            this.assertWritable();
            try {
                module2 = this.loadModuleInternal(filePath);
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtil.toSystemDependentName((String)filePath), e.getMessage()}), e);
            }
            if (module2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            return module2;
        }

        @NotNull
        private Module loadModuleInternal(@NotNull String filePath) throws ModuleWithNameAlreadyExists, IOException {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            filePath = this.resolveShortWindowsName(filePath);
            VirtualFile moduleFile = StandardFileSystems.local().findFileByPath(filePath);
            if (moduleFile == null || !moduleFile.exists()) {
                throw new FileNotFoundException(ProjectBundle.message((String)"module.file.does.not.exist.error", (Object[])new Object[]{filePath}));
            }
            String path = moduleFile.getPath();
            ModuleEx module2 = this.getModuleByFilePath(path);
            if (module2 == null) {
                ApplicationManager.getApplication().invokeAndWait(() -> moduleFile.refresh(false, false));
                module2 = ModuleManagerImpl.this.createAndLoadModule(path);
                this.initModule(module2, path, null);
            }
            ModuleEx moduleEx = module2;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            return moduleEx;
        }

        private void initModule(@NotNull ModuleEx module2, @NotNull String path, @Nullable Runnable beforeComponentCreation) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            this.myModules.put(module2.getName(), module2);
            this.myModulesCache = null;
            module2.init(path, beforeComponentCreation);
        }

        public void disposeModule(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "disposeModule"));
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module2.getName()) != null) {
                this.myModulesToDispose.add(module2);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module2);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "findModuleByName"));
            }
            Module module2 = this.myModules.get(name);
            if (module2 != null && !module2.isDisposed()) {
                return module2;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder = new DFSTBuilder(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

                public Collection<Module> getNodes() {
                    return ModuleModelImpl.this.myModules.values();
                }

                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @NotNull
        private List<Module> getModuleDependentModules(Module module2) {
            ArrayList<Module> result2 = new ArrayList<Module>();
            for (Module aModule : this.myModules.values()) {
                if (!this.isModuleDependent(aModule, module2)) continue;
                result2.add(aModule);
            }
            ArrayList<Module> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleDependentModules"));
            }
            return arrayList;
        }

        private boolean isModuleDependent(Module module2, Module onModule) {
            return ModuleRootManager.getInstance((Module)module2).isDependsOn(onModule);
        }

        public void commit() {
            ModifiableRootModel[] rootModels = new ModifiableRootModel[]{};
            ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable2) {
            ModuleManagerImpl.this.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            HashSet set2 = new HashSet();
            set2.addAll(ModuleManagerImpl.this.myModuleModel.myModules.values());
            for (Module thisModule : this.myModules.values()) {
                if (set2.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (set2.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(ModuleManagerImpl.this.myModuleModel.myModules) || !Comparing.equal(ModuleManagerImpl.this.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            this.myModulesCache = null;
            for (Module module2 : this.myModules.values()) {
                Disposer.dispose((Disposable)module2);
            }
            this.myModules.clear();
            this.myModuleGroupPath = null;
        }

        public void projectOpened() {
            for (Module aCollection : this.myModules.values()) {
                ModuleEx module2 = (ModuleEx)aCollection;
                module2.projectOpened();
            }
        }

        public void projectClosed() {
            for (Module aCollection : this.myModules.values()) {
                ModuleEx module2 = (ModuleEx)aCollection;
                module2.projectClosed();
            }
        }

        public String[] getModuleGroupPath(Module module2) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module2);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module2, @Nullable(value="null means remove") String[] groupPath) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleGroupPath"));
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module2);
            } else {
                this.myModuleGroupPath.put(module2, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private static class ModulePathSaveItem
    extends SaveItem {
        private final ModulePath myModulePath;
        private final String myFilePath;
        private final String myName;

        private ModulePathSaveItem(@NotNull ModulePath modulePath) {
            if (modulePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "<init>"));
            }
            this.myModulePath = modulePath;
            this.myFilePath = modulePath.getPath().replace(File.separatorChar, '/');
            int slashIndex = this.myFilePath.lastIndexOf(47);
            int startIndex = slashIndex >= 0 && slashIndex + 1 < this.myFilePath.length() ? slashIndex + 1 : 0;
            int endIndex = this.myFilePath.endsWith(ModuleManagerImpl.IML_EXTENSION) ? this.myFilePath.length() - ModuleManagerImpl.IML_EXTENSION.length() : this.myFilePath.length();
            this.myName = this.myFilePath.substring(startIndex, endIndex);
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            return this.myModulePath.getModuleGroup();
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModulePathSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "<init>"));
            }
            this.myModule = module2;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath().replace(File.separatorChar, '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private static abstract class SaveItem {
        private SaveItem() {
        }

        @NotNull
        protected abstract String getModuleName();

        protected abstract String getGroupPathString();

        @NotNull
        protected abstract String getModuleFilePath();

        public final void writeExternal(@NotNull Element parentElement) {
            if (parentElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "com/intellij/openapi/module/impl/ModuleManagerImpl$SaveItem", "writeExternal"));
            }
            Element moduleElement = new Element(ModuleManagerImpl.ELEMENT_MODULE);
            String moduleFilePath = this.getModuleFilePath();
            String url = VirtualFileManager.constructUrl((String)"file", (String)moduleFilePath);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEURL, url);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEPATH, moduleFilePath);
            String groupPath = this.getGroupPathString();
            if (groupPath != null) {
                moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_GROUP, groupPath);
            }
            parentElement.addContent(moduleElement);
        }
    }

    public static final class ModulePath {
        private final String myPath;
        private final String myModuleGroup;

        public ModulePath(String path, String moduleGroup) {
            this.myPath = path;
            this.myModuleGroup = moduleGroup;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getModuleGroup() {
            return this.myModuleGroup;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module2, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i2 = 0; i2 < group.length; ++i2) {
                    String g = group[i2];
                    cached[i2] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module2, cached);
        }
    }
}

