/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedConfigurable
extends CompositeConfigurable<Configurable> {
    protected TabbedPaneWrapper myTabbedPane;
    private final Disposable myParentDisposable;

    protected TabbedConfigurable(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/options/TabbedConfigurable", "<init>"));
        }
        this.myParentDisposable = parentDisposable;
    }

    public JComponent createComponent() {
        this.myTabbedPane = new TabbedPaneWrapper(this.myParentDisposable);
        this.createConfigurableTabs();
        JComponent component = this.myTabbedPane.getComponent();
        component.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return component;
    }

    protected void createConfigurableTabs() {
        for (Configurable configurable : this.getConfigurables()) {
            this.myTabbedPane.addTab(configurable.getDisplayName(), configurable.createComponent());
        }
    }

    @Override
    public void disposeUIResources() {
        this.myTabbedPane = null;
        super.disposeUIResources();
    }

    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }
}

