/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ObjectUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelProjectExtensionImpl
extends LanguageLevelProjectExtension {
    private static final String LANGUAGE_LEVEL = "languageLevel";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private final Project myProject;
    private LanguageLevel myLanguageLevel;
    private LanguageLevel myCurrentLevel;

    public LanguageLevelProjectExtensionImpl(Project project2) {
        this.myProject = project2;
        this.setDefault(project2.isDefault() ? Boolean.valueOf(true) : null);
    }

    public static LanguageLevelProjectExtensionImpl getInstanceImpl(Project project2) {
        return (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtensionImpl.getInstance((Project)project2);
    }

    private void readExternal(Element element) {
        String level = element.getAttributeValue(LANGUAGE_LEVEL);
        this.myLanguageLevel = level == null ? null : LanguageLevel.valueOf((String)level);
        String aDefault = element.getAttributeValue(DEFAULT_ATTRIBUTE);
        this.setDefault(aDefault == null ? null : Boolean.valueOf(Boolean.parseBoolean(aDefault)));
    }

    private void writeExternal(Element element) {
        Boolean aBoolean;
        if (this.myLanguageLevel != null) {
            element.setAttribute(LANGUAGE_LEVEL, this.myLanguageLevel.name());
        }
        if ((aBoolean = this.getDefault()) != null) {
            element.setAttribute(DEFAULT_ATTRIBUTE, Boolean.toString(aBoolean));
        }
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.getLanguageLevelOrDefault();
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    private LanguageLevel getLanguageLevelOrDefault() {
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.chooseNotNull((Object)this.myLanguageLevel, (Object)LanguageLevel.HIGHEST);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl", "getLanguageLevelOrDefault"));
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LANGUAGE_LEVEL, "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl", "setLanguageLevel"));
        }
        if (this.myLanguageLevel != languageLevel) {
            this.myLanguageLevel = languageLevel;
            this.languageLevelsChanged();
        }
    }

    public void languageLevelsChanged() {
        if (!this.myProject.isDefault()) {
            JavaLanguageLevelPusher.pushLanguageLevel(this.myProject);
        }
    }

    private void projectSdkChanged(@Nullable Sdk sdk) {
        JavaSdkVersion version;
        if (this.isDefault() && sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            this.setLanguageLevel(version.getMaxLanguageLevel());
        }
    }

    public void setCurrentLevel(LanguageLevel level) {
        this.myCurrentLevel = level;
    }

    public LanguageLevel getCurrentLevel() {
        return this.myCurrentLevel;
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final LanguageLevelProjectExtensionImpl myInstance;

        public MyProjectExtension(Project project2) {
            this.myInstance = (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)project2);
        }

        @Override
        public void readExternal(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl$MyProjectExtension", "readExternal"));
            }
            this.myInstance.readExternal(element);
        }

        @Override
        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl$MyProjectExtension", "writeExternal"));
            }
            this.myInstance.writeExternal(element);
        }

        @Override
        public void projectSdkChanged(@Nullable Sdk sdk) {
            this.myInstance.projectSdkChanged(sdk);
        }
    }
}

