/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChangeLibraryLevelDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeLibraryLevelActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase");
    protected final Project myProject;
    protected final String myTargetTableLevel;
    protected final boolean myCopy;

    public ChangeLibraryLevelActionBase(@NotNull Project project2, @NotNull String targetTableName, @NotNull String targetTableLevel, boolean copy) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase", "<init>"));
        }
        if (targetTableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTableName", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase", "<init>"));
        }
        if (targetTableLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetTableLevel", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase", "<init>"));
        }
        this.myProject = project2;
        this.myTargetTableLevel = targetTableLevel;
        this.myCopy = copy;
        this.getTemplatePresentation().setText(this.getActionName() + " to " + targetTableName + "...");
    }

    protected abstract LibraryTableModifiableModelProvider getModifiableTableModelProvider();

    protected abstract JComponent getParentComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Library doCopy(LibraryEx library) {
        VirtualFile baseDir = this.getBaseDir();
        String libPath = baseDir != null ? baseDir.getPath() + "/lib" : "";
        VirtualFile[] classesRoots = library.getFiles(OrderRootType.CLASSES);
        boolean allowEmptyName = this.isConvertingToModuleLibrary() && classesRoots.length == 1;
        String libraryName = allowEmptyName ? "" : StringUtil.notNullize((String)library.getName(), (String)LibraryTypeServiceImpl.suggestLibraryName(classesRoots));
        LibraryTableModifiableModelProvider provider = this.getModifiableTableModelProvider();
        ChangeLibraryLevelDialog dialog2 = new ChangeLibraryLevelDialog(this.getParentComponent(), this.myProject, this.myCopy, libraryName, libPath, allowEmptyName, provider);
        if (!dialog2.showAndGet()) {
            return null;
        }
        LinkedHashSet<File> fileToCopy = new LinkedHashSet<File>();
        HashMap<String, String> copiedFiles = new HashMap<String, String>();
        String targetDirectoryPath = dialog2.getDirectoryForFilesPath();
        if (targetDirectoryPath != null) {
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                for (VirtualFile root : library.getFiles(type)) {
                    if (!root.isInLocalFileSystem() && !(root.getFileSystem() instanceof ArchiveFileSystem)) continue;
                    fileToCopy.add(VfsUtil.virtualToIoFile((VirtualFile)PathUtil.getLocalFile((VirtualFile)root)));
                }
            }
            if (!this.copyOrMoveFiles(fileToCopy, targetDirectoryPath, copiedFiles)) {
                return null;
            }
        }
        Library copied = provider.getModifiableModel().createLibrary(StringUtil.nullize((String)dialog2.getLibraryName()), library.getKind());
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)copied.getModifiableModel();
        LibraryEditingUtil.copyLibrary(library, copiedFiles, model);
        AccessToken token = WriteAction.start();
        try {
            model.commit();
        }
        finally {
            token.finish();
        }
        return copied;
    }

    private boolean copyOrMoveFiles(final Set<File> filesToProcess, final @NotNull String targetDirPath, final Map<String, String> copiedFiles) {
        if (targetDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirPath", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase", "copyOrMoveFiles"));
        }
        final Ref finished = Ref.create((Object)false);
        new Task.Modal(this.myProject, (this.myCopy ? "Copying" : "Moving") + " Library Files", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase$1", "run"));
                }
                File targetDir = new File(FileUtil.toSystemDependentName((String)targetDirPath));
                for (File from : filesToProcess) {
                    indicator.checkCanceled();
                    File to = FileUtil.findSequentNonexistentFile((File)targetDir, (String)FileUtil.getNameWithoutExtension((File)from), (String)FileUtilRt.getExtension((String)from.getName()));
                    try {
                        if (from.isDirectory()) {
                            if (ChangeLibraryLevelActionBase.this.myCopy) {
                                FileUtil.copyDir((File)from, (File)to);
                            } else {
                                FileUtil.moveDirWithContent((File)from, (File)to);
                            }
                        } else if (ChangeLibraryLevelActionBase.this.myCopy) {
                            FileUtil.copy((File)from, (File)to);
                        } else {
                            FileUtil.rename((File)from, (File)to);
                        }
                    }
                    catch (IOException e) {
                        String actionName = ChangeLibraryLevelActionBase.this.getActionName();
                        String message = "Cannot " + actionName.toLowerCase() + " file " + from.getAbsolutePath() + ": " + e.getMessage();
                        Messages.showErrorDialog((Project)ChangeLibraryLevelActionBase.this.myProject, (String)message, (String)("Cannot " + actionName));
                        LOG.info((Throwable)e);
                        return;
                    }
                    copiedFiles.put(FileUtil.toSystemIndependentName((String)from.getAbsolutePath()), FileUtil.toSystemIndependentName((String)to.getAbsolutePath()));
                }
                finished.set((Object)true);
            }
        }.queue();
        if (!((Boolean)finished.get()).booleanValue()) {
            return false;
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase$2", "run"));
                }
                for (Map.Entry entry : copiedFiles.entrySet()) {
                    VirtualFile parent;
                    String fromPath = (String)entry.getKey();
                    String toPath = (String)entry.getValue();
                    LocalFileSystem.getInstance().refreshAndFindFileByPath(toPath);
                    if (ChangeLibraryLevelActionBase.this.myCopy || (parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(fromPath).getParentFile())) == null) continue;
                    parent.refresh(false, false);
                }
            }
        }.execute();
        return true;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isEnabled();
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    private String getActionName() {
        return this.myCopy ? "Copy" : "Move";
    }

    @Nullable
    protected VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }

    protected boolean isConvertingToModuleLibrary() {
        return this.myTargetTableLevel.equals("module");
    }

    protected abstract boolean isEnabled();
}

