/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ShadowPainter {
    private final Icon myTop;
    private final Icon myTopRight;
    private final Icon myRight;
    private final Icon myBottomRight;
    private final Icon myBottom;
    private final Icon myBottomLeft;
    private final Icon myLeft;
    private final Icon myTopLeft;
    @Nullable
    private Color myBorderColor;

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft) {
        this.myTop = top;
        this.myTopRight = topRight;
        this.myRight = right;
        this.myBottomRight = bottomRight;
        this.myBottom = bottom;
        this.myBottomLeft = bottomLeft;
        this.myLeft = left;
        this.myTopLeft = topLeft;
    }

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft, @Nullable Color borderColor) {
        this(top, topRight, right, bottomRight, bottom, bottomLeft, left, topLeft);
        this.myBorderColor = borderColor;
    }

    public void setBorderColor(@Nullable Color borderColor) {
        this.myBorderColor = borderColor;
    }

    public BufferedImage createShadow(JComponent c, int width, int height) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        this.paintShadow(c, g, 0, 0, width, height);
        g.dispose();
        return image;
    }

    public void paintShadow(Component c, Graphics2D g, int x, int y, int width, int height) {
        int _y;
        int _x;
        int leftSize = this.myLeft.getIconWidth();
        int rightSize = this.myRight.getIconWidth();
        int bottomSize = this.myBottom.getIconHeight();
        int topSize = this.myTop.getIconHeight();
        this.myTopLeft.paintIcon(c, g, x, y);
        this.myTopRight.paintIcon(c, g, x + width - this.myTopRight.getIconWidth(), y);
        this.myBottomRight.paintIcon(c, g, x + width - this.myBottomRight.getIconWidth(), y + height - this.myBottomRight.getIconHeight());
        this.myBottomLeft.paintIcon(c, g, x, y + height - this.myBottomLeft.getIconHeight());
        for (_x = this.myTopLeft.getIconWidth(); _x < width - this.myTopRight.getIconWidth(); ++_x) {
            this.myTop.paintIcon(c, g, _x + x, y);
        }
        for (_x = this.myBottomLeft.getIconWidth(); _x < width - this.myBottomLeft.getIconWidth(); ++_x) {
            this.myBottom.paintIcon(c, g, _x + x, y + height - bottomSize);
        }
        for (_y = this.myTopLeft.getIconHeight(); _y < height - this.myBottomLeft.getIconHeight(); ++_y) {
            this.myLeft.paintIcon(c, g, x, _y + y);
        }
        for (_y = this.myTopRight.getIconHeight(); _y < height - this.myBottomRight.getIconHeight(); ++_y) {
            this.myRight.paintIcon(c, g, x + width - rightSize, _y + y);
        }
        if (this.myBorderColor != null) {
            g.setColor(this.myBorderColor);
            g.drawRect(x + leftSize - 1, y + topSize - 1, width - leftSize - rightSize + 1, height - topSize - bottomSize + 1);
        }
    }
}

