/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction {
    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "update"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "update"));
        }
        Project project2 = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project2 != null && ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        boolean result2 = false;
        Project project2 = context.getProject();
        if (project2 != null) {
            Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
            if (pair.first != null && pair.second != null) {
                result2 = TabbedShowHistoryAction.isEnabled(project2, (FilePath)pair.first, (VirtualFile)pair.second);
            }
        }
        return result2;
    }

    private static boolean isEnabled(@NotNull Project project2, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        if (fileOrParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrParent", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "isEnabled"));
        }
        boolean result2 = false;
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project2);
        if (vcs != null) {
            VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
            result2 = provider != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && AbstractVcs.fileInVcsByFileStatus((Project)project2, (VirtualFile)fileOrParent) && provider.canShowHistoryFor(fileOrParent);
        }
        return result2;
    }

    @NotNull
    private static Pair<FilePath, VirtualFile> getPathAndParentFile(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
        }
        if (context.getSelectedFilesStream().findAny().isPresent()) {
            VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle(context.getSelectedFilesStream());
            Pair pair = file2 != null ? Pair.create((Object)VcsUtil.getFilePath((VirtualFile)file2), (Object)file2) : Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
            }
            return pair;
        }
        File[] ioFiles = context.getSelectedIOFiles();
        if (ioFiles != null && ioFiles.length > 0) {
            for (File ioFile : ioFiles) {
                VirtualFile parent = TabbedShowHistoryAction.getParentVirtualFile(ioFile);
                if (parent == null) continue;
                Pair pair = Pair.create((Object)VcsUtil.getFilePath((VirtualFile)parent, (String)ioFile.getName()), (Object)parent);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
                }
                return pair;
            }
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getPathAndParentFile"));
        }
        return pair;
    }

    @Nullable
    private static VirtualFile getParentVirtualFile(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "getParentVirtualFile"));
        }
        File parentIoFile = ioFile.getParentFile();
        return parentIoFile != null ? LocalFileSystem.getInstance().findFileByIoFile(parentIoFile) : null;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "actionPerformed"));
        }
        Project project2 = context.getProject();
        Pair<FilePath, VirtualFile> pair = TabbedShowHistoryAction.getPathAndParentFile(context);
        FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)pair.first);
        VirtualFile fileOrParent = (VirtualFile)ObjectUtils.assertNotNull((Object)pair.second);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project2));
        VcsHistoryProvider provider = (VcsHistoryProvider)ObjectUtils.assertNotNull((Object)vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project2).showFileHistory(provider, vcs.getAnnotationProvider(), path, null, vcs);
    }
}

