/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.MapIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.RecursiveFileHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class IgnoredFilesCompositeHolder
implements IgnoredFilesHolder {
    private final Map<AbstractVcs, IgnoredFilesHolder> myHolderMap;
    private final Project myProject;
    private AbstractVcs myCurrentVcs;
    private final ProjectLevelVcsManager myVcsManager;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder");

    public IgnoredFilesCompositeHolder(Project project2) {
        this.myProject = project2;
        this.myHolderMap = new HashMap<AbstractVcs, IgnoredFilesHolder>();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    @Override
    public void cleanAll() {
        this.myHolderMap.clear();
    }

    @Override
    public void cleanAndAdjustScope(VcsModifiableDirtyScope scope) {
        AbstractVcs vcs = scope.getVcs();
        if (this.myHolderMap.containsKey(vcs)) {
            this.myHolderMap.get(vcs).cleanAndAdjustScope(scope);
        }
    }

    @Override
    public FileHolder copy() {
        IgnoredFilesCompositeHolder result2 = new IgnoredFilesCompositeHolder(this.myProject);
        for (Map.Entry<AbstractVcs, IgnoredFilesHolder> entry : this.myHolderMap.entrySet()) {
            result2.myHolderMap.put(entry.getKey(), (IgnoredFilesHolder)entry.getValue().copy());
        }
        return result2;
    }

    @Override
    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    @Nullable
    public IgnoredFilesHolder getAppropriateIgnoredHolder() {
        if (!this.myHolderMap.containsKey(this.myCurrentVcs)) {
            LOG.error("current vcs: " + this.myCurrentVcs);
            return null;
        }
        return this.myHolderMap.get(this.myCurrentVcs);
    }

    @Override
    public void addFile(VirtualFile file2) {
        if (!this.myHolderMap.containsKey(this.myCurrentVcs)) {
            LOG.error("current vcs: " + this.myCurrentVcs + " file: " + file2.getPath());
        }
        this.myHolderMap.get(this.myCurrentVcs).addFile(file2);
    }

    @Override
    public boolean containsFile(VirtualFile file2) {
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file2);
        if (vcs == null) {
            return false;
        }
        IgnoredFilesHolder ignoredFilesHolder = this.myHolderMap.get(vcs);
        return ignoredFilesHolder == null ? false : ignoredFilesHolder.containsFile(file2);
    }

    @Override
    public Collection<VirtualFile> values() {
        if (this.myHolderMap.size() == 1) {
            return this.myHolderMap.values().iterator().next().values();
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (IgnoredFilesHolder holder : this.myHolderMap.values()) {
            result2.addAll(holder.values());
        }
        return result2;
    }

    @Override
    public void notifyVcsStarted(AbstractVcs vcs) {
        this.myCurrentVcs = vcs;
        if (!this.myHolderMap.containsKey(vcs)) {
            this.myHolderMap.put(vcs, vcs.reportsIgnoredDirectories() ? new RecursiveFileHolder(this.myProject, FileHolder.HolderType.IGNORED) : new MapIgnoredFilesHolder(this.myProject));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IgnoredFilesCompositeHolder)) {
            return false;
        }
        IgnoredFilesCompositeHolder other = (IgnoredFilesCompositeHolder)obj;
        return this.myHolderMap.equals(other.myHolderMap);
    }

    public int hashCode() {
        return this.myHolderMap.hashCode();
    }
}

