/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFilteringStrategy
implements ChangeListFilteringStrategy {
    private final JScrollPane myScrollPane;
    private final JList myValueList;
    private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ChangeListColumn myColumn;
    private final Class<? extends CommittedChangesProvider> myProviderClass;
    private final MyListModel myModel;
    private final CommittedChangeListToStringConvertor ourConvertorInstance = new CommittedChangeListToStringConvertor();
    private Object[] myPrefferedSelection;

    public ColumnFilteringStrategy(ChangeListColumn column, Class<? extends CommittedChangesProvider> providerClass) {
        this.myModel = new MyListModel();
        this.myValueList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myValueList);
        this.myValueList.setModel(this.myModel);
        this.myValueList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                for (ChangeListener listener2 : ColumnFilteringStrategy.this.myListeners) {
                    listener2.stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.myValueList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy$2", "customizeCellRenderer"));
                }
                if (index == 0) {
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else if (value.toString().length() == 0) {
                    this.append(VcsBundle.message((String)"committed.changes.filter.none", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.myColumn = column;
        this.myProviderClass = providerClass;
    }

    public CommittedChangesFilterKey getKey() {
        return new CommittedChangesFilterKey(this.toString(), CommittedChangesFilterPriority.USER);
    }

    public String toString() {
        return this.myColumn.getTitle();
    }

    @Nullable
    public JComponent getFilterUI() {
        return this.myScrollPane;
    }

    public void setFilterBase(List<CommittedChangeList> changeLists) {
        this.myPrefferedSelection = null;
        this.appendFilterBase(changeLists);
    }

    public void addChangeListener(ChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void resetFilterBase() {
        this.myPrefferedSelection = this.myValueList.getSelectedValues();
        this.myValueList.clearSelection();
        this.myModel.clear();
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    public void appendFilterBase(List<CommittedChangeList> changeLists) {
        Object[] oldSelection = this.myModel.isEmpty() ? this.myPrefferedSelection : this.myValueList.getSelectedValues();
        this.myModel.addNext(changeLists, this.ourConvertorInstance);
        if (oldSelection != null) {
            for (Object o : oldSelection) {
                this.myValueList.setSelectedValue(o, false);
            }
        }
        this.myValueList.revalidate();
        this.myValueList.repaint();
    }

    @NotNull
    public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
        Object[] selection = this.myValueList.getSelectedValues();
        if (this.myValueList.getSelectedIndex() == 0 || selection.length == 0) {
            List<CommittedChangeList> list = changeLists;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy", "filterChangeLists"));
            }
            return list;
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        block0: for (CommittedChangeList changeList : changeLists) {
            if (this.myProviderClass != null && !this.myProviderClass.isInstance(changeList.getVcs().getCommittedChangesProvider())) continue;
            for (Object value : selection) {
                if (!value.toString().equals(this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(changeList)).toString())) continue;
                result2.add(changeList);
                continue block0;
            }
        }
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/ColumnFilteringStrategy", "filterChangeLists"));
        }
        return arrayList;
    }

    private static class MyListModel
    extends AbstractListModel {
        private volatile String[] myValues = ArrayUtil.EMPTY_STRING_ARRAY;

        private MyListModel() {
        }

        public <T> void addNext(Collection<T> values, Convertor<T, String> convertor) {
            TreeSet<String> set2 = new TreeSet<String>(Arrays.asList(this.myValues));
            for (T value : values) {
                String converted = (String)convertor.convert(value);
                if (converted == null) continue;
                set2.add(converted);
            }
            this.myValues = ArrayUtil.toStringArray(set2);
            this.fireContentsChanged(this, 0, this.myValues.length);
        }

        @Override
        public int getSize() {
            return this.myValues.length + 1;
        }

        public boolean isEmpty() {
            return this.myValues.length == 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index == 0) {
                return VcsBundle.message((String)"committed.changes.filter.all", (Object[])new Object[0]);
            }
            return this.myValues[index - 1];
        }

        public void clear() {
            this.myValues = ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    private class CommittedChangeListToStringConvertor
    implements Convertor<CommittedChangeList, String> {
        private CommittedChangeListToStringConvertor() {
        }

        public String convert(CommittedChangeList o) {
            if (ColumnFilteringStrategy.this.myProviderClass == null || ColumnFilteringStrategy.this.myProviderClass.isInstance(o.getVcs().getCommittedChangesProvider())) {
                return ColumnFilteringStrategy.this.myColumn.getValue((ChangeList)ReceivedChangeList.unwrap(o)).toString();
            }
            return null;
        }
    }
}

