/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ApplyPatchFromClipboardAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        String text = ClipboardUtil.getTextInClipboard();
        e.getPresentation().setEnabled(project2 != null && text != null && ChangeListManager.getInstance((Project)project2).isFreezed() == null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not apply patch now")) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        String clipboardText = ClipboardUtil.getTextInClipboard();
        assert (clipboardText != null);
        new MyApplyPatchFromClipboardDialog(project2, clipboardText).show();
    }

    public static class MyApplyPatchFromClipboardDialog
    extends ApplyPatchDifferentiatedDialog {
        private static final JCheckBox FLY_OPTION_PANEL = MyApplyPatchFromClipboardDialog.createAnalyzeOnTheFlyOptionPanel();

        public MyApplyPatchFromClipboardDialog(@NotNull Project project2, @NotNull String clipboardText) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/patch/ApplyPatchFromClipboardAction$MyApplyPatchFromClipboardDialog", "<init>"));
            }
            if (clipboardText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clipboardText", "com/intellij/openapi/vcs/changes/patch/ApplyPatchFromClipboardAction$MyApplyPatchFromClipboardDialog", "<init>"));
            }
            super(project2, new ApplyPatchDefaultExecutor(project2), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, (VirtualFile)new LightVirtualFile("clipboardPatchFile", (CharSequence)clipboardText), null, ChangeListManager.getInstance((Project)project2).getDefaultChangeList(), null, null, null, false);
        }

        protected JComponent createSouthPanel() {
            return MyApplyPatchFromClipboardDialog.addDoNotShowCheckBox((JComponent)((JComponent)ObjectUtils.assertNotNull((Object)super.createSouthPanel())), (JCheckBox)FLY_OPTION_PANEL);
        }

        @NotNull
        private static JCheckBox createAnalyzeOnTheFlyOptionPanel() {
            final JCheckBox removeOptionCheckBox = new JCheckBox("Analyze and Apply Patch from Clipboard on the Fly");
            removeOptionCheckBox.setMnemonic(76);
            removeOptionCheckBox.setSelected(VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY);
            removeOptionCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VcsApplicationSettings.getInstance().DETECT_PATCH_ON_THE_FLY = removeOptionCheckBox.isSelected();
                }
            });
            JCheckBox jCheckBox = removeOptionCheckBox;
            if (jCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchFromClipboardAction$MyApplyPatchFromClipboardDialog", "createAnalyzeOnTheFlyOptionPanel"));
            }
            return jCheckBox;
        }
    }
}

