/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFileNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserIgnoredFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLocallyDeletedNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLockedFoldersNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserLogicallyLockedFile;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ChangesBrowserNode<T>
extends DefaultMutableTreeNode {
    public static final Convertor<TreePath, String> TO_TEXT_CONVERTER = path -> ((ChangesBrowserNode)path.getLastPathComponent()).getTextPresentation();
    private SimpleTextAttributes myAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    protected int myCount = -1;
    protected int myDirectoryCount = -1;
    public static final Object IGNORED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.ignored.files", (Object[])new Object[0]);
        }
    };
    public static final Object LOCKED_FOLDERS_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.locked.folders", (Object[])new Object[0]);
        }
    };
    public static final Object LOGICALLY_LOCKED_TAG = VcsBundle.message((String)"changes.nodetitle.logicallt.locked.folders", (Object[])new Object[0]);
    public static final Object UNVERSIONED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.unversioned.files", (Object[])new Object[0]);
        }
    };
    public static final Object MODIFIED_WITHOUT_EDITING_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.modified.without.editing", (Object[])new Object[0]);
        }
    };
    public static final Object SWITCHED_FILES_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.switched.files", (Object[])new Object[0]);
        }
    };
    public static final Object SWITCHED_ROOTS_TAG = new Object(){

        public String toString() {
            return VcsBundle.message((String)"changes.nodetitle.switched.roots", (Object[])new Object[0]);
        }
    };

    protected ChangesBrowserNode(Object userObject) {
        super(userObject);
    }

    @NotNull
    public static ChangesBrowserNode create(@NotNull LocallyDeletedChange change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        ChangesBrowserLocallyDeletedNode changesBrowserLocallyDeletedNode = new ChangesBrowserLocallyDeletedNode(change);
        if (changesBrowserLocallyDeletedNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        return changesBrowserLocallyDeletedNode;
    }

    @NotNull
    public static ChangesBrowserNode create(@NotNull Project project2, @NotNull Object userObject) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        if (userObject instanceof Change) {
            ChangesBrowserChangeNode changesBrowserChangeNode = new ChangesBrowserChangeNode(project2, (Change)userObject, null);
            if (changesBrowserChangeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserChangeNode;
        }
        if (userObject instanceof VirtualFile) {
            ChangesBrowserFileNode changesBrowserFileNode = new ChangesBrowserFileNode(project2, (VirtualFile)userObject);
            if (changesBrowserFileNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserFileNode;
        }
        if (userObject instanceof FilePath) {
            ChangesBrowserFilePathNode changesBrowserFilePathNode = new ChangesBrowserFilePathNode((FilePath)userObject);
            if (changesBrowserFilePathNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserFilePathNode;
        }
        if (userObject == IGNORED_FILES_TAG) {
            ChangesBrowserIgnoredFilesNode changesBrowserIgnoredFilesNode = new ChangesBrowserIgnoredFilesNode(userObject);
            if (changesBrowserIgnoredFilesNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserIgnoredFilesNode;
        }
        if (userObject == LOCKED_FOLDERS_TAG) {
            ChangesBrowserLockedFoldersNode changesBrowserLockedFoldersNode = new ChangesBrowserLockedFoldersNode(project2, userObject);
            if (changesBrowserLockedFoldersNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserLockedFoldersNode;
        }
        if (userObject instanceof ChangesBrowserLogicallyLockedFile) {
            ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)userObject;
            if (changesBrowserNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
            }
            return changesBrowserNode;
        }
        ChangesBrowserNode changesBrowserNode = new ChangesBrowserNode(userObject);
        if (changesBrowserNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "create"));
        }
        return changesBrowserNode;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.myCount = -1;
        this.myDirectoryCount = -1;
    }

    public int getCount() {
        if (this.myCount == -1) {
            this.myCount = ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getCount).sum();
        }
        return this.myCount;
    }

    public int getDirectoryCount() {
        if (this.myDirectoryCount == -1) {
            this.myDirectoryCount = (this.isDirectory() ? 1 : 0) + ChangesBrowserNode.toStream(this.children()).mapToInt(ChangesBrowserNode::getDirectoryCount).sum();
        }
        return this.myDirectoryCount;
    }

    protected boolean isDirectory() {
        return false;
    }

    @NotNull
    public List<Change> getAllChangesUnder() {
        List<Change> list = this.getAllObjectsUnder(Change.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getAllChangesUnder"));
        }
        return list;
    }

    @NotNull
    public <U> List<U> getAllObjectsUnder(@NotNull Class<U> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getAllObjectsUnder"));
        }
        List list = this.getObjectsUnderStream(clazz).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getAllObjectsUnder"));
        }
        return list;
    }

    @NotNull
    public <U> Stream<U> getObjectsUnderStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getObjectsUnderStream"));
        }
        Stream<Object> stream = ChangesBrowserNode.toStream(this.preorderEnumeration()).map(ChangesBrowserNode::getUserObject).filter(userObject -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "lambda$getObjectsUnderStream$1"));
            }
            return clazz.isAssignableFrom(userObject.getClass());
        }).map(clazz::cast);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getObjectsUnderStream"));
        }
        return stream;
    }

    @NotNull
    public List<VirtualFile> getAllFilesUnder() {
        List<VirtualFile> list = this.getFilesUnderStream().collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getAllFilesUnder"));
        }
        return list;
    }

    @NotNull
    public Stream<VirtualFile> getFilesUnderStream() {
        Stream<VirtualFile> stream = ChangesBrowserNode.toStream(this.breadthFirstEnumeration()).map(ChangesBrowserNode::getUserObject).filter(userObject -> userObject instanceof VirtualFile).map(VirtualFile.class::cast).filter(VirtualFile::isValid);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getFilesUnderStream"));
        }
        return stream;
    }

    @NotNull
    public List<FilePath> getAllFilePathsUnder() {
        List<FilePath> list = this.getFilePathsUnderStream().collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getAllFilePathsUnder"));
        }
        return list;
    }

    @NotNull
    public Stream<FilePath> getFilePathsUnderStream() {
        Stream<FilePath> stream = ChangesBrowserNode.toStream(this.breadthFirstEnumeration()).filter(DefaultMutableTreeNode::isLeaf).map(ChangesBrowserNode::getUserObject).filter(userObject -> userObject instanceof FilePath).map(FilePath.class::cast);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getFilePathsUnderStream"));
        }
        return stream;
    }

    @NotNull
    private static Stream<ChangesBrowserNode> toStream(@NotNull Enumeration enumeration) {
        if (enumeration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeration", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "toStream"));
        }
        Iterator iterator = ContainerUtil.iterate((Enumeration)enumeration);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 272);
        Stream<ChangesBrowserNode> stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "toStream"));
        }
        return stream;
    }

    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "render"));
        }
        renderer.append(this.userObject.toString(), this.myAttributes);
        this.appendCount(renderer);
    }

    @NotNull
    protected String getCountText() {
        int count = this.getCount();
        int dirCount = this.getDirectoryCount();
        String result2 = "";
        if (dirCount != 0 || count != 0) {
            result2 = FontUtil.spaceAndThinSpace() + (dirCount == 0 ? VcsBundle.message((String)"changes.nodetitle.changecount", (Object[])new Object[]{count}) : (count == 0 ? VcsBundle.message((String)"changes.nodetitle.directory.changecount", (Object[])new Object[]{dirCount}) : VcsBundle.message((String)"changes.nodetitle.directory.file.changecount", (Object[])new Object[]{dirCount, count})));
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "getCountText"));
        }
        return string;
    }

    protected void appendCount(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "appendCount"));
        }
        renderer.append(this.getCountText(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @Override
    public String toString() {
        return this.getTextPresentation();
    }

    public String getTextPresentation() {
        return this.userObject == null ? "" : this.userObject.toString();
    }

    public T getUserObject() {
        return (T)this.userObject;
    }

    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        return false;
    }

    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
    }

    public int getSortWeight() {
        return 9;
    }

    public int compareUserObjects(Object o2) {
        return 0;
    }

    public void setAttributes(@NotNull SimpleTextAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserNode", "setAttributes"));
        }
        this.myAttributes = attributes;
    }
}

