/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private static final Logger LOG = Logger.getInstance(ModuleDefaultVcsRootPolicy.class);
    private final Project myProject;
    private final VirtualFile myBaseDir;
    private final ModuleManager myModuleManager;

    public ModuleDefaultVcsRootPolicy(Project project2) {
        this.myProject = project2;
        this.myBaseDir = project2.getBaseDir();
        this.myModuleManager = ModuleManager.getInstance((Project)this.myProject);
    }

    @Override
    public void addDefaultVcsRoots(NewMappings mappingList, @NotNull String vcsName, List<VirtualFile> result2) {
        Module[] modules;
        AbstractVcs vcsFor;
        VirtualFile ideaDir;
        AbstractVcs vcsFor2;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy", "addDefaultVcsRoots"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.myBaseDir != null && vcsName.equals(mappingList.getVcsFor(this.myBaseDir)) && (vcsFor2 = vcsManager.getVcsFor(this.myBaseDir)) != null && vcsName.equals(vcsFor2.getName())) {
            result2.add(this.myBaseDir);
        }
        if (ProjectKt.isDirectoryBased(this.myProject) && this.myBaseDir != null && (ideaDir = ProjectKt.getStateStore(this.myProject).getDirectoryStoreFile()) != null && (vcsFor = vcsManager.getVcsFor(ideaDir)) != null && vcsName.equals(vcsFor.getName())) {
            result2.add(ideaDir);
        }
        for (Module module2 : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleDefaultVcsRootPolicy.this.myModuleManager.getModules();
            }
        })) {
            VirtualFile[] files;
            for (VirtualFile file2 : files = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                String mappingVcs;
                VcsDirectoryMapping mapping = mappingList.getMappingFor(file2, module2);
                String string = mappingVcs = mapping != null ? mapping.getVcs() : null;
                if (!vcsName.equals(mappingVcs) || result2.contains(file2)) continue;
                result2.add(file2);
            }
        }
    }

    @Override
    public boolean matchesDefaultMapping(VirtualFile file2, Object matchContext) {
        if (matchContext != null) {
            return true;
        }
        return this.myBaseDir != null && VfsUtilCore.isAncestor((VirtualFile)this.myBaseDir, (VirtualFile)file2, (boolean)false);
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file2) {
        return ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject);
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(VirtualFile file2) {
        VirtualFile ideaDir;
        if (this.myBaseDir != null && ((FileIndexFacade)PeriodicalTasksCloser.getInstance().safeGetService(this.myProject, FileIndexFacade.class)).isValidAncestor(this.myBaseDir, file2)) {
            return this.myBaseDir;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(file2, Registry.is((String)"ide.hide.excluded.files"));
        if (contentRoot != null) {
            return contentRoot;
        }
        if (ProjectKt.isDirectoryBased(this.myProject) && (ideaDir = ProjectKt.getStateStore(this.myProject).getDirectoryStoreFile()) != null && VfsUtilCore.isAncestor((VirtualFile)ideaDir, (VirtualFile)file2, (boolean)false)) {
            return ideaDir;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDirtyRoots() {
        boolean haveDefaultMapping;
        HashSet dirtyRoots = ContainerUtil.newHashSet();
        if (ProjectKt.isDirectoryBased(this.myProject)) {
            VirtualFile ideaDir = ProjectKt.getStateStore(this.myProject).getDirectoryStoreFile();
            if (ideaDir != null) {
                dirtyRoots.add(ideaDir);
            } else {
                LOG.warn(".idea was not found for base dir [" + this.myBaseDir.getPath() + "]");
            }
        }
        ContainerUtil.addAll((Collection)dirtyRoots, this.getContentRoots());
        String defaultMapping = ((ProjectLevelVcsManagerEx)ProjectLevelVcsManager.getInstance((Project)this.myProject)).haveDefaultMapping();
        boolean bl = haveDefaultMapping = !StringUtil.isEmpty((String)defaultMapping);
        if (haveDefaultMapping && this.myBaseDir != null) {
            dirtyRoots.add(this.myBaseDir);
        }
        HashSet hashSet = dirtyRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy", "getDirtyRoots"));
        }
        return hashSet;
    }

    @NotNull
    private Collection<VirtualFile> getContentRoots() {
        Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<VirtualFile>>(){

            public List<VirtualFile> compute() {
                ArrayList contentRoots = ContainerUtil.newArrayList();
                for (Module module2 : ModuleDefaultVcsRootPolicy.this.myModuleManager.getModules()) {
                    ContainerUtil.addAll((Collection)contentRoots, (Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots());
                }
                return contentRoots;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy", "getContentRoots"));
        }
        return collection;
    }
}

