/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(char c, int size, int style, @NotNull String family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/openapi/vcs/ui/FontUtil", "getFontAbleToDisplay"));
        }
        Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, size, style, family).getFont();
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getFontAbleToDisplay"));
        }
        return font;
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        Font font = UIUtil.getLabelFont();
        String string = FontUtil.getHtmlWithFonts(input, font.getStyle(), font);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        return string;
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input, int style, @NotNull Font baseFont) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        if (baseFont == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFont", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        int start = baseFont.canDisplayUpTo(input);
        if (start == -1) {
            String string = input;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
            }
            return string;
        }
        Font font = null;
        StringBuilder result2 = new StringBuilder(input.substring(0, start));
        for (int i2 = start; i2 < input.length(); ++i2) {
            char c = input.charAt(i2);
            if (baseFont.canDisplay(c)) {
                if (font != null) {
                    result2.append("</font>");
                }
                result2.append(c);
                font = null;
                continue;
            }
            if (font != null && font.canDisplay(c)) {
                result2.append(c);
                continue;
            }
            if (font != null) {
                result2.append("</font>");
            }
            if ((font = FontUtil.getFontAbleToDisplay(c, baseFont.getSize(), style, baseFont.getFamily())) != baseFont) {
                result2.append("<font face=\"").append(font.getFamily()).append("\">");
            }
            result2.append(c);
        }
        if (font != null) {
            result2.append("</font>");
        }
        String string = result2.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        return string;
    }
}

