/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl");
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    private static final VirtualDirectoryImpl NULL_VIRTUAL_FILE = new VirtualDirectoryImpl(-42, new VfsData.Segment(), new VfsData.DirectoryData(), null, (NewVirtualFileSystem)LocalFileSystem.getInstance()){

        @Override
        public String toString() {
            return "NULL";
        }
    };
    private final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;
    private static final Function<VirtualFileSystemEntry, String> verboseToString = file2 -> {
        if (file2 == null) {
            return "null";
        }
        return (Object)file2 + " (name: '" + file2.getName() + "', " + ((Object)file2).getClass() + ", parent: " + (Object)((Object)file2.getParent()) + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.getFileSystem().isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
    };

    public VirtualDirectoryImpl(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "<init>"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "<init>"));
        }
        super(id, segment, parent);
        this.myData = data;
        this.myFs = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFs;
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getFileSystem"));
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        boolean ignoreCase = !delegate.isCaseSensitive();
        VirtualFileSystemEntry result2 = this.doFindChild(name, ensureCanonicalName, delegate, ignoreCase);
        if (result2 == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result2 != null && doRefresh && delegate.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        return result2;
    }

    private void addToAdoptedChildren(boolean ignoreCase, @NotNull String name) {
        int indexInReal;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "addToAdoptedChildren"));
        }
        if (this.myData.isAdoptedName(name)) {
            return;
        }
        if (!this.allChildrenLoaded()) {
            this.myData.addAdoptedName(name, this.getFileSystem().isCaseSensitive());
        }
        if ((indexInReal = VirtualDirectoryImpl.findIndex(this.myData.myChildrenIds, name, ignoreCase)) >= 0) {
            this.removeFromArray(indexInReal);
        }
        this.assertConsistency(ignoreCase, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChildInArray"));
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (this.myData.isAdoptedName(name)) {
                return NULL_VIRTUAL_FILE;
            }
            int[] array = this.myData.myChildrenIds;
            int indexInReal = VirtualDirectoryImpl.findIndex(array, name, ignoreCase);
            if (indexInReal >= 0) {
                return VfsData.getFileById(array[indexInReal], this);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean ignoreCase) {
        VirtualFileSystemEntry child;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChild"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "doFindChild"));
        }
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, ignoreCase);
        if (found != null) {
            return found;
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        if (ensureCanonicalName) {
            if ((name = UriUtil.trimTrailingSlashes(UriUtil.trimLeadingSlashes(FileUtilRt.toSystemIndependentName((String)name)))).indexOf(47) != -1) {
                return null;
            }
            FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
            if ((name = delegate.getCanonicallyCasedName((VirtualFile)fake)).isEmpty()) {
                return null;
            }
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (this.myData.isAdoptedName(name)) {
                return NULL_VIRTUAL_FILE;
            }
            int[] array = this.myData.myChildrenIds;
            int indexInReal = VirtualDirectoryImpl.findIndex(array, name, ignoreCase);
            if (indexInReal >= 0) {
                return VfsData.getFileById(array[indexInReal], this);
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            int id = ourPersistence.getId((VirtualFile)this, name, delegate);
            if (id <= 0) {
                this.myData.addAdoptedName(name, !ignoreCase);
                return null;
            }
            child = this.createChild(FileNameCache.storeName(name), id, delegate);
            int[] after2 = this.myData.myChildrenIds;
            if (after2 != array) {
                this.addChild(child);
            } else {
                this.insertChildAt(child, indexInReal);
                this.assertConsistency(!delegate.isCaseSensitive(), name);
            }
        }
        if (!child.isDirectory()) {
            VfsRootAccess.assertAccessInTests(child, this.getFileSystem());
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFileSystemEntry[] getArraySafely() {
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            return this.myData.getFileChildren(this.myId, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VirtualFileSystemEntry createChild(String name, int id, @NotNull NewVirtualFileSystem delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry virtualFileSystemEntry = this.createChild(FileNameCache.storeName(name), id, delegate);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int nameId, int id, @NotNull NewVirtualFileSystem delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        int attributes = ourPersistence.getFileAttributes(id);
        VfsData.Segment segment = VfsData.getSegment(id, true);
        try {
            VfsData.initFile(id, segment, nameId, PersistentFS.isDirectory(attributes) ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        }
        catch (VfsData.FileAlreadyCreatedException e) {
            throw new RuntimeException("dir=" + this.myId + "; dir.children=" + Arrays.toString(FSRecords.listAll(this.myId)), e);
        }
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child = VfsData.getFileById(id, this);
        assert (child != null);
        segment.setFlag(id, 0x20000000, PersistentFS.isSymLink(attributes));
        segment.setFlag(id, Integer.MIN_VALUE, PersistentFS.isSpecialFile(attributes));
        segment.setFlag(id, 0x1000000, PersistentFS.isWritable(attributes));
        segment.setFlag(id, 0x2000000, PersistentFS.isHidden(attributes));
        child.updateLinkStatus();
        if (delegate.markNewFilesAsDirty()) {
            child.markDirty();
        }
        VirtualFileSystemEntry virtualFileSystemEntry = child;
        if (virtualFileSystemEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createChild"));
        }
        return virtualFileSystemEntry;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createAndFindChildWithEventFire"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "createAndFindChildWithEventFire"));
        }
        FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
        if (attributes == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, attributes.isDirectory(), true);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "refreshAndFindChild"));
        }
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChildIfCached"));
        }
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        VirtualFileSystemEntry found = this.doFindChildInArray(name, ignoreCase);
        return found == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "iterInDbChildren"));
            }
            return list;
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            String[] names = ourPersistence.listPersisted((VirtualFile)this);
            NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
            for (String name : names) {
                this.findChild(name, false, false, delegate);
            }
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "iterInDbChildren"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VirtualFile[] getChildren() {
        int[] result2;
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean ignoreCase = !delegate.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        if (this.allChildrenLoaded()) {
            this.assertConsistency(ignoreCase, "");
            VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.getArraySafely();
            // MONITOREXIT : directoryData
            if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getChildren"));
        }
        boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
        FSRecords.NameId[] childrenIds = ourPersistence.listAll((VirtualFile)this);
        if (childrenIds.length == 0) {
            result2 = ArrayUtil.EMPTY_INT_ARRAY;
        } else {
            Arrays.sort(childrenIds, (o1, o2) -> {
                CharSequence name1 = o1.name;
                CharSequence name2 = o2.name;
                int cmp = VirtualDirectoryImpl.compareNames(name1, name2, ignoreCase);
                if (cmp == 0 && name1 != name2) {
                    LOG.error((Object)((Object)ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ") ignoreCase: " + ignoreCase + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)this) + "; children: " + Arrays.toString(childrenIds));
                }
                return cmp;
            });
            TIntHashSet prevChildren = new TIntHashSet(this.myData.myChildrenIds);
            result2 = new int[childrenIds.length];
            for (int i2 = 0; i2 < childrenIds.length; ++i2) {
                FSRecords.NameId child = childrenIds[i2];
                result2[i2] = child.id;
                assert (child.id > 0) : child;
                prevChildren.remove(child.id);
                if (VfsData.getFileById(child.id, this) != null) continue;
                this.createChild(child.nameId, child.id, delegate);
            }
            if (!prevChildren.isEmpty()) {
                LOG.error("Loaded child disappeared: parent=" + (String)verboseToString.fun((Object)this) + "; child=" + (String)verboseToString.fun((Object)VfsData.getFileById(prevChildren.toArray()[0], this)));
            }
        }
        if (this.getId() > 0) {
            this.myData.myChildrenIds = result2;
            if (CHECK) {
                this.assertConsistency(ignoreCase, Arrays.asList(childrenIds));
            }
            this.setChildrenLoaded();
        }
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.getArraySafely();
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getChildren"));
    }

    private void assertConsistency(boolean ignoreCase, @NotNull Object details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "assertConsistency"));
        }
        if (!CHECK || ApplicationInfoImpl.isInPerformanceTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        for (int i2 = 1; i2 < childrenIds.length; ++i2) {
            CharSequence prevName;
            int id = childrenIds[i2];
            int prev = childrenIds[i2 - 1];
            CharSequence name = VfsData.getNameByFileId(id);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName = VfsData.getNameByFileId(prev), ignoreCase);
            if (cmp > 0) continue;
            VirtualDirectoryImpl.error((String)verboseToString.fun((Object)VfsData.getFileById(prev, this)) + " is wrongly placed before " + (String)verboseToString.fun((Object)VfsData.getFileById(id, this)), this.getArraySafely(), details);
        }
    }

    private static void error(String message, VirtualFileSystemEntry[] array, Object ... details) {
        String children2 = StringUtil.join((Object[])array, verboseToString, (String)",");
        throw new AssertionError((Object)(message + "; children: " + children2 + "\nDetails: " + ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o)));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findChild"));
        }
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry findChildById(int id, boolean cachedOnly) {
        if (ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id) >= 0) {
            return VfsData.getFileById(id, this);
        }
        if (cachedOnly) {
            return null;
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "addChild"));
        }
        String childName = child.getName();
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = VirtualDirectoryImpl.findIndex(this.myData.myChildrenIds, childName, ignoreCase);
            this.myData.removeAdoptedName(childName);
            if (indexInReal < 0) {
                this.insertChildAt(child, indexInReal);
                ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
            }
            this.assertConsistency(ignoreCase, (Object)child);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int negativeIndex) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "insertChildAt"));
        }
        int[] array = this.myData.myChildrenIds;
        int[] appended = new int[array.length + 1];
        int i2 = -negativeIndex - 1;
        System.arraycopy(array, 0, appended, 0, i2);
        appended[i2] = file2.getId();
        assert (appended[i2] > 0) : file2;
        System.arraycopy(array, i2, appended, i2 + 1, array.length - i2);
        this.myData.myChildrenIds = appended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "removeChild"));
        }
        boolean ignoreCase = !this.getFileSystem().isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.addToAdoptedChildren(ignoreCase, name);
            this.assertConsistency(ignoreCase, file2);
        }
    }

    private void removeFromArray(int index) {
        this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)index);
        ((PersistentFSImpl)PersistentFS.getInstance()).incStructuralModificationCount();
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
        this.myData.clearAdoptedNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getSuspiciousNames() {
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        List<String> list = this.myData.getAdoptedNames();
        // MONITOREXIT : directoryData
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getSuspiciousNames"));
    }

    private static int findIndex(int[] array, @NotNull CharSequence name, boolean ignoreCase) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "findIndex"));
        }
        int low = 0;
        int high = array.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = -VirtualDirectoryImpl.compareNames(VfsData.getNameByFileId(array[mid]), name, ignoreCase);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean ignoreCase) {
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name1", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "compareNames"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name2", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "compareNames"));
        }
        int d = name1.length() - name2.length();
        if (d != 0) {
            return d;
        }
        for (int i2 = 0; i2 < name1.length(); ++i2) {
            d = StringUtil.compare((char)name1.charAt(i2), (char)name2.charAt(i2), (boolean)ignoreCase);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        List<VirtualFileSystemEntry> list = Arrays.asList(this.getArraySafely());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getCachedChildren"));
        }
        return list;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child : this.getArraySafely()) {
            child.markDirtyInternal();
            if (!(child instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "setUserMap"));
        }
        this.myData.myUserMap = map;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myData.myUserMap;
        if (keyFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl", "getUserMap"));
        }
        return keyFMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(KeyFMap newMap) {
        for (Key key2 : newMap.getKeys()) {
            if (key2 != null && newMap.get(key2) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }
}

