/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFocusManagerImpl
extends IdeFocusManager {
    private final ToolWindowManagerImpl myToolWindowManager;

    public IdeFocusManagerImpl(ToolWindowManagerImpl twManager) {
        this.myToolWindowManager = twManager;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManagerImpl.getGlobalInstance().requestFocus(c, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManagerImpl.getGlobalInstance().requestFocus(command, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "getFocusTargetFor"));
        }
        return IdeFocusManagerImpl.getGlobalInstance().getFocusTargetFor(comp);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        IdeFocusManagerImpl.getGlobalInstance().doWhenFocusSettlesDown(runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2, @NotNull ModalityState modality) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        IdeFocusManagerImpl.getGlobalInstance().doWhenFocusSettlesDown(runnable2, modality);
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "doWhenFocusSettlesDown"));
        }
        IdeFocusManagerImpl.getGlobalInstance().doWhenFocusSettlesDown(runnable2);
    }

    @Nullable
    public Component getFocusedDescendantFor(@NotNull Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "getFocusedDescendantFor"));
        }
        return IdeFocusManagerImpl.getGlobalInstance().getFocusedDescendantFor(comp);
    }

    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "dispatch"));
        }
        return IdeFocusManagerImpl.getGlobalInstance().dispatch(e);
    }

    public void typeAheadUntil(ActionCallback done2) {
        IdeFocusManagerImpl.getGlobalInstance().typeAheadUntil(done2);
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        ActionCallback actionCallback = this.myToolWindowManager.requestDefaultFocus(forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "requestDefaultFocus"));
        }
        return actionCallback;
    }

    public boolean isFocusTransferEnabled() {
        return IdeFocusManagerImpl.getGlobalInstance().isFocusTransferEnabled();
    }

    @NotNull
    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        Expirable expirable = IdeFocusManagerImpl.getGlobalInstance().getTimestamp(trackOnlyForcedCommands);
        if (expirable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "getTimestamp"));
        }
        return expirable;
    }

    @NotNull
    public FocusRequestor getFurtherRequestor() {
        FocusRequestor focusRequestor = IdeFocusManagerImpl.getGlobalInstance().getFurtherRequestor();
        if (focusRequestor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "getFurtherRequestor"));
        }
        return focusRequestor;
    }

    public void revalidateFocus(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "revalidateFocus"));
        }
        IdeFocusManagerImpl.getGlobalInstance().revalidateFocus(runnable2);
    }

    public void setTypeaheadEnabled(boolean enabled) {
        IdeFocusManagerImpl.getGlobalInstance().setTypeaheadEnabled(enabled);
    }

    public Component getFocusOwner() {
        return IdeFocusManagerImpl.getGlobalInstance().getFocusOwner();
    }

    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "runOnOwnContext"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/IdeFocusManagerImpl", "runOnOwnContext"));
        }
        IdeFocusManagerImpl.getGlobalInstance().runOnOwnContext(context, runnable2);
    }

    public Component getLastFocusedFor(IdeFrame frame) {
        return IdeFocusManagerImpl.getGlobalInstance().getLastFocusedFor(frame);
    }

    public IdeFrame getLastFocusedFrame() {
        return IdeFocusManagerImpl.getGlobalInstance().getLastFocusedFrame();
    }

    public void toFront(JComponent c) {
        IdeFocusManagerImpl.getGlobalInstance().toFront(c);
    }

    public boolean isFocusBeingTransferred() {
        return IdeFocusManagerImpl.getGlobalInstance().isFocusBeingTransferred();
    }

    public void dispose() {
    }
}

