/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.status.EncodingPanel;
import com.intellij.openapi.wm.impl.status.InsertOverwritePanel;
import com.intellij.openapi.wm.impl.status.LineSeparatorPanel;
import com.intellij.openapi.wm.impl.status.PositionPanel;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SideBorder;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Field;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.PowerSupplyKit;

public class IdeFrameImpl
extends JFrame
implements IdeFrameEx,
AccessibleContextAccessor,
DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.IdeFrameImpl");
    public static final Key<Boolean> SHOULD_OPEN_IN_FULL_SCREEN = Key.create((String)"should.open.in.full.screen");
    private static final String FULL_SCREEN = "FullScreen";
    private static boolean myUpdatingTitle;
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;
    private IdeFrameDecorator myFrameDecorator;
    private PropertyChangeListener myWindowsBorderUpdater = null;
    private boolean myRestoreFullScreen;
    static final ShadowPainter ourShadowPainter;

    public IdeFrameImpl(ApplicationInfoEx applicationInfoEx, ActionManagerEx actionManager, DataManager dataManager, Application application) {
        super(applicationInfoEx.getFullApplicationName());
        this.myRootPane = this.createRootPane(actionManager, dataManager, application);
        this.setRootPane(this.myRootPane);
        this.setBackground(UIUtil.getPanelBackground());
        AppUIUtil.updateWindowIcon(this);
        Dimension size = ScreenUtil.getMainScreenBounds().getSize();
        size.width = Math.min(1400, size.width - 20);
        size.height = Math.min(1000, size.height - 40);
        this.setSize(size);
        this.setLocationRelativeTo(null);
        LayoutFocusTraversalPolicyExt layoutFocusTraversalPolicy = new LayoutFocusTraversalPolicyExt();
        this.setFocusTraversalPolicy(layoutFocusTraversalPolicy);
        this.setupCloseAction();
        MnemonicHelper.init((Component)this);
        this.myBalloonLayout = new BalloonLayoutImpl(this.myRootPane, new Insets(8, 8, 8, 8));
        if (SystemInfo.isMac) {
            this.setIconImage(null);
        }
        MouseGestureManager.getInstance().add(this);
        this.myFrameDecorator = IdeFrameDecorator.decorate(this);
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                IdeFrameImpl.this.updateBorder();
            }
        });
        if (SystemInfo.isWindows) {
            this.myWindowsBorderUpdater = new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    if (evt == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/wm/impl/IdeFrameImpl$2", "propertyChange"));
                    }
                    IdeFrameImpl.this.updateBorder();
                }
            };
            Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", this.myWindowsBorderUpdater);
            if (!SystemInfo.isJavaVersionAtLeast((String)"1.8")) {
                final Ref myDimensionRef = new Ref((Object)new Dimension());
                final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (IdeFrameImpl.this.isDisplayable() && !IdeFrameImpl.this.getSize().equals(myDimensionRef.get())) {
                            Rectangle bounds = IdeFrameImpl.this.getBounds();
                            --bounds.width;
                            IdeFrameImpl.this.setBounds(bounds);
                            ++bounds.width;
                            IdeFrameImpl.this.setBounds(bounds);
                            myDimensionRef.set((Object)IdeFrameImpl.this.getSize());
                        }
                        alarm.addRequest((Runnable)this, 50);
                    }
                };
                alarm.addRequest(runnable2, 50);
            }
        }
        IdeMenuBar.installAppMenuIfNeeded(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        PowerSupplyKit.checkPowerSupply();
    }

    private void updateBorder() {
        int state = this.getExtendedState();
        if (!WindowManager.getInstance().isFullScreenSupportedInCurrentOS() || !SystemInfo.isWindows || this.myRootPane == null) {
            return;
        }
        this.myRootPane.setBorder(null);
        boolean isNotClassic = Boolean.parseBoolean(String.valueOf(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")));
        if (isNotClassic && (state & 6) != 0) {
            IdeFrame[] projectFrames = WindowManager.getInstance().getAllProjectFrames();
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)this.getBounds());
            for (IdeFrame frame : projectFrames) {
                if (frame == this || !((IdeFrameImpl)frame).isInFullScreen() || ScreenUtil.getScreenDevice((Rectangle)((IdeFrameImpl)frame).getBounds()) != device) continue;
                Insets insets = ScreenUtil.getScreenInsets((GraphicsConfiguration)device.getDefaultConfiguration());
                int mask = 0;
                if (insets.top != 0) {
                    mask |= 2;
                }
                if (insets.left != 0) {
                    mask |= 1;
                }
                if (insets.bottom != 0) {
                    mask |= 8;
                }
                if (insets.right != 0) {
                    mask |= 4;
                }
                this.myRootPane.setBorder((Border)new SideBorder((Color)JBColor.BLACK, mask, 3));
                break;
            }
        }
    }

    protected IdeRootPane createRootPane(ActionManagerEx actionManager, DataManager dataManager, Application application) {
        return new IdeRootPane(actionManager, dataManager, application, this);
    }

    @Override
    @NotNull
    public Insets getInsets() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            Insets insets = new Insets(0, 0, 0, 0);
            if (insets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFrameImpl", "getInsets"));
            }
            return insets;
        }
        Insets insets = super.getInsets();
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFrameImpl", "getInsets"));
        }
        return insets;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    @Nullable
    public static Window getActiveFrame() {
        for (Frame frame : IdeFrameImpl.getFrames()) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(() -> this.setFocusableWindowState(true));
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds) {
        super.setMaximizedBounds(null);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(@NotNull WindowEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/IdeFrameImpl$4", "windowClosing"));
                }
                if (IdeFrameImpl.this.isTemporaryDisposed()) {
                    return;
                }
                Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                if (openProjects.length > 1 || openProjects.length == 1 && SystemInfo.isMacSystemMenu) {
                    if (IdeFrameImpl.this.myProject != null && IdeFrameImpl.this.myProject.isOpen()) {
                        ProjectUtil.closeAndDispose(IdeFrameImpl.this.myProject);
                    }
                    ((AppLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectFrameClosed();
                    WelcomeFrame.showIfNoProjectOpened();
                } else {
                    ApplicationManagerEx.getApplicationEx().exit();
                }
            }
        });
    }

    public StatusBar getStatusBar() {
        return this.myRootPane == null ? null : this.myRootPane.getStatusBar();
    }

    @Override
    public void setTitle(String title) {
        if (myUpdatingTitle) {
            super.setTitle(title);
        } else {
            this.myTitle = title;
        }
        this.updateTitle();
    }

    public void setFrameTitle(String text) {
        super.setTitle(text);
    }

    public void setFileTitle(String fileTitle) {
        this.setFileTitle(fileTitle, null);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file2) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file2;
        this.updateTitle();
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key2) {
        return this.myRootPane.findByName(key2);
    }

    private void updateTitle() {
        IdeFrameImpl.updateTitle(this, this.myTitle, this.myFileTitle, this.myCurrentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTitle(JFrame frame, String title, String fileTitle, File currentFile) {
        if (myUpdatingTitle) {
            return;
        }
        try {
            myUpdatingTitle = true;
            frame.getRootPane().putClientProperty("Window.documentFile", currentFile);
            String applicationName = ((ApplicationInfoEx)ApplicationInfo.getInstance()).getFullApplicationName();
            Builder builder = new Builder();
            if (SystemInfo.isMac) {
                boolean addAppName = StringUtil.isEmpty((String)title) || ProjectManager.getInstance().getOpenProjects().length == 0 || ((ApplicationInfoEx)ApplicationInfo.getInstance()).isEAP() && !applicationName.endsWith("SNAPSHOT");
                builder.append(fileTitle).append(title).append(addAppName ? applicationName : null);
            } else {
                builder.append(title).append(fileTitle).append(applicationName);
            }
            frame.setTitle(builder.sb.toString());
        }
        finally {
            myUpdatingTitle = false;
        }
    }

    public void updateView() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
        ((IdeRootPane)this.getRootPane()).updateNorthComponents();
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        if (IdeFrame.KEY.getName().equals(dataId)) {
            return this;
        }
        return null;
    }

    public void setProject(Project project2) {
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && this.myProject != project2 && project2 != null) {
            boolean bl = this.myRestoreFullScreen = this.myProject == null && IdeFrameImpl.shouldRestoreFullScreen(project2);
            if (this.myProject != null) {
                this.storeFullScreenStateIfNeeded(false);
            }
        }
        this.myProject = project2;
        if (project2 != null) {
            ProjectFrameBounds.getInstance(project2);
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project2);
                project2.getMessageBus().connect().subscribe(StatusBar.Info.TOPIC, (Object)this.myRootPane.getStatusBar());
            }
            this.installDefaultProjectStatusBarWidgets(this.myProject);
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (project2 == null) {
            FocusTrackback.release(this);
        }
        if (this.isVisible() && this.myRestoreFullScreen) {
            this.toggleFullScreen(true);
            this.myRestoreFullScreen = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.myRestoreFullScreen) {
            SwingUtilities.invokeLater(() -> {
                this.toggleFullScreen(true);
                if (SystemInfo.isMacOSLion) {
                    this.setBounds(ScreenUtil.getScreenRectangle((Point)this.getLocationOnScreen()));
                }
                this.myRestoreFullScreen = false;
            });
        }
    }

    private void installDefaultProjectStatusBarWidgets(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/IdeFrameImpl", "installDefaultProjectStatusBarWidgets"));
        }
        final StatusBar statusBar = this.getStatusBar();
        final PositionPanel positionPanel = new PositionPanel(project2);
        statusBar.addWidget((StatusBarWidget)positionPanel, "before FatalError");
        final IdeNotificationArea notificationArea = new IdeNotificationArea();
        statusBar.addWidget((StatusBarWidget)notificationArea, "before FatalError");
        final EncodingPanel encodingPanel = new EncodingPanel(project2);
        statusBar.addWidget((StatusBarWidget)encodingPanel, "after Position");
        final LineSeparatorPanel lineSeparatorPanel = new LineSeparatorPanel(project2);
        statusBar.addWidget((StatusBarWidget)lineSeparatorPanel, "before " + encodingPanel.ID());
        final ToggleReadOnlyAttributePanel readOnlyAttributePanel = new ToggleReadOnlyAttributePanel(project2);
        final InsertOverwritePanel insertOverwritePanel = new InsertOverwritePanel(project2);
        statusBar.addWidget((StatusBarWidget)insertOverwritePanel, "after Encoding");
        statusBar.addWidget((StatusBarWidget)readOnlyAttributePanel, "after InsertOverwrite");
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                statusBar.removeWidget(encodingPanel.ID());
                statusBar.removeWidget(lineSeparatorPanel.ID());
                statusBar.removeWidget(positionPanel.ID());
                statusBar.removeWidget(notificationArea.ID());
                statusBar.removeWidget(readOnlyAttributePanel.ID());
                statusBar.removeWidget(insertOverwritePanel.ID());
                ((StatusBarEx)statusBar).removeCustomIndicationComponents();
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (SystemInfo.isMac && this.isInFullScreen()) {
            ((MacMainFrameDecorator)this.myFrameDecorator).toggleFullScreenNow();
        }
        if (this.isTemporaryDisposed()) {
            super.dispose();
            return;
        }
        MouseGestureManager.getInstance().remove(this);
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        if (this.myRootPane != null) {
            this.myRootPane = null;
            this.setRootPane(new JRootPane());
        }
        if (this.myFrameDecorator != null) {
            Disposer.dispose((Disposable)this.myFrameDecorator);
            this.myFrameDecorator = null;
        }
        if (this.myWindowsBorderUpdater != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener("win.xpstyle.themeActive", this.myWindowsBorderUpdater);
            this.myWindowsBorderUpdater = null;
        }
        FocusTrackback.release(this);
        super.dispose();
    }

    private boolean isTemporaryDisposed() {
        return this.myRootPane != null && this.myRootPane.getClientProperty("dispose.temporary") != null;
    }

    public void storeFullScreenStateIfNeeded() {
        if (this.myFrameDecorator != null) {
            this.storeFullScreenStateIfNeeded(this.myFrameDecorator.isInFullScreen());
        }
    }

    public void storeFullScreenStateIfNeeded(boolean state) {
        if (!WindowManager.getInstance().isFullScreenSupportedInCurrentOS()) {
            return;
        }
        if (this.myProject != null) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(FULL_SCREEN, state);
            this.doLayout();
        }
    }

    public static boolean shouldRestoreFullScreen(@Nullable Project project2) {
        return WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && project2 != null && (SHOULD_OPEN_IN_FULL_SCREEN.get((UserDataHolder)project2) == Boolean.TRUE || PropertiesComponent.getInstance((Project)project2).getBoolean(FULL_SCREEN));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeFrameImpl", "paint"));
        }
        UISettings.setupAntialiasing((Graphics)g);
        super.paint(g);
        if (IdeRootPane.isFrameDecorated() && !this.isInFullScreen()) {
            BufferedImage shadow = ourShadowPainter.createShadow(this.getRootPane(), this.getWidth(), this.getHeight());
            g.drawImage(shadow, 0, 0, null);
        }
    }

    @Override
    public Color getBackground() {
        return IdeRootPane.isFrameDecorated() ? Gray.x00.withAlpha(0) : super.getBackground();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.isInFullScreen() && IdeRootPane.isFrameDecorated()) {
            int leftSide = AllIcons.Windows.Shadow.Left.getIconWidth();
            int rightSide = AllIcons.Windows.Shadow.Right.getIconWidth();
            int top = AllIcons.Windows.Shadow.Top.getIconHeight();
            int bottom = AllIcons.Windows.Shadow.Bottom.getIconHeight();
            this.getRootPane().setBounds(leftSide, top, this.getWidth() - leftSide - rightSide, this.getHeight() - top - bottom);
        }
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @Override
    public boolean isInFullScreen() {
        return this.myFrameDecorator != null && this.myFrameDecorator.isInFullScreen();
    }

    @Override
    @NotNull
    public ActionCallback toggleFullScreen(boolean state) {
        IdeFrame[] frames;
        if (this.temporaryFixForIdea156004(state)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFrameImpl", "toggleFullScreen"));
            }
            return actionCallback;
        }
        if (this.myFrameDecorator != null) {
            ActionCallback actionCallback = this.myFrameDecorator.toggleFullScreen(state);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFrameImpl", "toggleFullScreen"));
            }
            return actionCallback;
        }
        for (IdeFrame frame : frames = WindowManager.getInstance().getAllProjectFrames()) {
            ((IdeFrameImpl)frame).updateBorder();
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeFrameImpl", "toggleFullScreen"));
        }
        return actionCallback;
    }

    private boolean temporaryFixForIdea156004(boolean state) {
        if (SystemInfo.isMac) {
            try {
                Field modalBlockerField = Window.class.getDeclaredField("modalBlocker");
                modalBlockerField.setAccessible(true);
                Window modalBlocker = (Window)modalBlockerField.get(this);
                if (modalBlocker != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.toggleFullScreen(state), ModalityState.NON_MODAL);
                    return true;
                }
            }
            catch (NoSuchFieldException e) {
                LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        return false;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeFrameImpl();
        }
        return this.accessibleContext;
    }

    static {
        ourShadowPainter = new ShadowPainter(AllIcons.Windows.Shadow.Top, AllIcons.Windows.Shadow.TopRight, AllIcons.Windows.Shadow.Right, AllIcons.Windows.Shadow.BottomRight, AllIcons.Windows.Shadow.Bottom, AllIcons.Windows.Shadow.BottomLeft, AllIcons.Windows.Shadow.Left, AllIcons.Windows.Shadow.TopLeft);
    }

    protected class AccessibleIdeFrameImpl
    extends JFrame.AccessibleJFrame {
        protected AccessibleIdeFrameImpl() {
            super(IdeFrameImpl.this);
        }

        @Override
        public String getAccessibleName() {
            StringBuilder builder = new StringBuilder();
            if (IdeFrameImpl.this.myProject != null) {
                builder.append(IdeFrameImpl.this.myProject.getName());
                builder.append(" - ");
            }
            String applicationName = ((ApplicationInfoEx)ApplicationInfo.getInstance()).getFullApplicationName();
            builder.append(applicationName);
            return builder.toString();
        }
    }

    private static final class Builder {
        public StringBuilder sb = new StringBuilder();

        private Builder() {
        }

        public Builder append(@Nullable String s) {
            if (s == null || s.length() == 0) {
                return this;
            }
            if (this.sb.length() > 0) {
                this.sb.append(" - ");
            }
            this.sb.append(s);
            return this;
        }
    }
}

