/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class LibraryDependentToolWindowManager
extends AbstractProjectComponent {
    private final ToolWindowManagerEx myToolWindowManager;

    protected LibraryDependentToolWindowManager(Project project2, ToolWindowManagerEx toolWindowManager) {
        super(project2);
        this.myToolWindowManager = toolWindowManager;
    }

    public void projectOpened() {
        ModuleRootAdapter rootListener = new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                if (!LibraryDependentToolWindowManager.this.myProject.isDisposed()) {
                    LibraryDependentToolWindowManager.this.checkToolWindowStatuses(LibraryDependentToolWindowManager.this.myProject);
                }
            }
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.lambda$projectOpened$0((ModuleRootListener)rootListener));
    }

    private void checkToolWindowStatuses(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager", "checkToolWindowStatuses"));
        }
        assert (!project2.isDisposed());
        DumbService.getInstance((Project)project2).smartInvokeLater(new Runnable(){

            @Override
            public void run() {
                for (LibraryDependentToolWindow libraryToolWindow : (LibraryDependentToolWindow[])Extensions.getExtensions((ExtensionPointName)LibraryDependentToolWindow.EXTENSION_POINT_NAME)) {
                    boolean exists;
                    try {
                        exists = libraryToolWindow.getLibrarySearchHelper().isLibraryExists(project2);
                    }
                    catch (ProcessCanceledException e) {
                        exists = false;
                        DumbService.getInstance((Project)project2).smartInvokeLater((Runnable)this);
                    }
                    if (exists) {
                        LibraryDependentToolWindowManager.this.ensureToolWindowExists(libraryToolWindow);
                        continue;
                    }
                    ToolWindow toolWindow = LibraryDependentToolWindowManager.this.myToolWindowManager.getToolWindow(libraryToolWindow.id);
                    if (toolWindow == null) continue;
                    LibraryDependentToolWindowManager.this.myToolWindowManager.unregisterToolWindow(libraryToolWindow.id);
                }
            }
        });
    }

    private void ensureToolWindowExists(LibraryDependentToolWindow extension) {
        ToolWindow toolWindow = this.myToolWindowManager.getToolWindow(extension.id);
        if (toolWindow == null) {
            this.myToolWindowManager.initToolWindow((ToolWindowEP)extension);
        }
    }

    private /* synthetic */ void lambda$projectOpened$0(ModuleRootListener rootListener) {
        if (!this.myProject.isDisposed()) {
            this.checkToolWindowStatuses(this.myProject);
            MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
            connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)rootListener);
        }
    }
}

