/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import sun.swing.SwingUtilities2;

public class BaseLabel
extends JLabel {
    protected ToolWindowContentUi myUi;
    private Color myActiveFg;
    private Color myPassiveFg;
    private boolean myBold;

    public BaseLabel(ToolWindowContentUi ui, boolean bold) {
        this.myUi = ui;
        this.setOpaque(false);
        this.myBold = bold;
    }

    @Override
    public void updateUI() {
        this.setActiveFg(JBColor.foreground());
        this.setPassiveFg((Color)new JBColor((Color)Gray._75, UIUtil.getLabelDisabledForeground()));
        super.updateUI();
    }

    @Override
    public Font getFont() {
        Font f = UIUtil.getLabelFont();
        f = f.deriveFont(f.getStyle(), Math.max(11, f.getSize() - 2));
        if (this.myBold) {
            f = f.deriveFont(1);
        }
        return f;
    }

    public static Font getLabelFont() {
        Font f = UIUtil.getLabelFont();
        return f.deriveFont(f.getStyle(), Math.max(11, f.getSize() - 2));
    }

    public void setActiveFg(Color fg) {
        this.myActiveFg = fg;
    }

    public void setPassiveFg(Color passiveFg) {
        this.myPassiveFg = passiveFg;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color fore = this.myUi.myWindow.isActive() ? this.myActiveFg : this.myPassiveFg;
        this.setForeground(fore);
        this.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
        super.paintComponent(this._getGraphics((Graphics2D)g));
    }

    protected Graphics _getGraphics(Graphics2D g) {
        if (!this.allowEngravement()) {
            return g;
        }
        Color foreground = this.getForeground();
        if (Color.BLACK.equals(foreground)) {
            return new EngravedTextGraphics(g);
        }
        return g;
    }

    protected boolean allowEngravement() {
        return true;
    }

    protected Color getActiveFg(boolean selected) {
        return this.myActiveFg;
    }

    protected Color getPassiveFg(boolean selected) {
        return this.myPassiveFg;
    }

    protected void updateTextAndIcon(Content content, boolean isSelected) {
        if (content == null) {
            this.setText(null);
            this.setIcon(null);
        } else {
            this.setText(content.getDisplayName());
            this.setActiveFg(this.getActiveFg(isSelected));
            this.setPassiveFg(this.getPassiveFg(isSelected));
            this.setToolTipText(content.getDescription());
            boolean show = Boolean.TRUE.equals(content.getUserData(ToolWindow.SHOW_CONTENT_ICON)) || content.getComponent() instanceof Iconable;
            Icon icon = content.getIcon();
            if (content.getComponent() instanceof Iconable) {
                icon = ((Iconable)content.getComponent()).getIcon(1);
            }
            if (show) {
                if (isSelected) {
                    this.setIcon(icon);
                } else {
                    this.setIcon((Icon)(icon != null ? new WatermarkIcon(icon, 0.5f) : null));
                }
            } else {
                this.setIcon(null);
            }
            this.myBold = false;
        }
    }

    public Content getContent() {
        return null;
    }
}

