/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    private final TextPanel myComponent;
    private boolean actionEnabled;
    private final Alarm update;
    private volatile Reference<Editor> myEditor;

    public EncodingPanel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/EncodingPanel", "<init>"));
        }
        super(project2);
        this.myEditor = new WeakReference<Object>(null);
        this.update = new Alarm((Disposable)this);
        this.myComponent = new TextPanel.ExtraSize(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/status/EncodingPanel$1", "paintComponent"));
                }
                super.paintComponent(g);
                if (EncodingPanel.this.actionEnabled && this.getText() != null) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Icon arrows = AllIcons.Ide.Statusbar_arrows;
                    arrows.paintIcon(this, g, r.width - insets.right - arrows.getIconWidth() - 2, r.height / 2 - arrows.getIconHeight() / 2);
                }
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/EncodingPanel$2", "onClick"));
                }
                EncodingPanel.this.update();
                EncodingPanel.this.showPopup(e);
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    @Nullable(value="returns null if charset set cannot be determined from content")
    private static Charset cachedCharsetFromContent(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        return EncodingManager.getInstance().getCachedCharsetFromContent(document);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel", "selectionChanged"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile newFile = event.getNewFile();
        this.fileChanged(newFile);
    }

    private void fileChanged(VirtualFile newFile) {
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.myEditor = new WeakReference<Editor>(editor);
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/status/EncodingPanel", "fileOpened"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/status/EncodingPanel", "fileOpened"));
        }
        this.fileChanged(file2);
    }

    public StatusBarWidget copy() {
        return new EncodingPanel(this.getProject());
    }

    @NotNull
    public String ID() {
        if ("Encoding" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/EncodingPanel", "ID"));
        }
        return "Encoding";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/EncodingPanel", "getPresentation"));
        }
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/EncodingPanel", "install"));
        }
        super.install(statusBar);
        EncodingManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("cachedEncoding")) {
                    Document document = evt.getSource() instanceof Document ? (Document)evt.getSource() : null;
                    EncodingPanel.this.updateForDocument(document);
                }
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel$4", "propertyChanged"));
                }
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }
        }));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                Document document = e.getDocument();
                EncodingPanel.this.updateForDocument(document);
            }
        }, (Disposable)this);
    }

    private void updateForDocument(@Nullable(value="null means update anyway") Document document) {
        Editor selectedEditor = this.myEditor.get();
        if (document != null && (selectedEditor == null || selectedEditor.getDocument() != document)) {
            return;
        }
        this.update();
    }

    private void updateForFile(@Nullable(value="null means update anyway") VirtualFile file2) {
        if (file2 == null) {
            this.update();
        } else {
            this.updateForDocument(FileDocumentManager.getInstance().getCachedDocument(file2));
        }
    }

    private void showPopup(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/EncodingPanel", "showPopup"));
        }
        if (!this.actionEnabled) {
            return;
        }
        DataContext dataContext = this.getContext();
        ListPopup popup = new ChangeFileEncodingAction().createPopup(dataContext);
        if (popup != null) {
            Dimension dimension = popup.getContent().getPreferredSize();
            Point at = new Point(0, -dimension.height);
            popup.show(new RelativePoint(e.getComponent(), at));
            Disposer.register((Disposable)this, (Disposable)popup);
        }
    }

    @NotNull
    private DataContext getContext() {
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), this.getSelectedFile(), SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), this.getProject(), SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent)));
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/EncodingPanel", "getContext"));
        }
        return dataContext;
    }

    private void update() {
        if (this.update.isDisposed()) {
            return;
        }
        this.update.cancelAllRequests();
        this.update.addRequest(() -> {
            String toolTipText;
            if (this.isDisposed()) {
                return;
            }
            VirtualFile file2 = this.getSelectedFile();
            this.actionEnabled = false;
            String charsetName = null;
            Pair<Charset, String> check = null;
            if (file2 != null) {
                check = EncodingUtil.checkSomeActionEnabled(file2);
                Charset charset = null;
                if (LoadTextUtil.wasCharsetDetectedFromBytes(file2) != null) {
                    charset = EncodingPanel.cachedCharsetFromContent(file2);
                }
                if (charset == null) {
                    charset = file2.getCharset();
                }
                boolean bl = this.actionEnabled = check == null || check.second == null;
                if (!this.actionEnabled) {
                    charset = (Charset)check.first;
                }
                if (charset != null) {
                    charsetName = charset.displayName();
                }
            }
            if (charsetName == null) {
                String string = charsetName = file2 != null ? "n/a" : "";
            }
            if (this.actionEnabled) {
                toolTipText = String.format("File Encoding%n%s", charsetName);
                this.myComponent.setForeground(UIUtil.getActiveTextColor());
                this.myComponent.setTextAlignment(0.0f);
            } else {
                String failReason = check == null ? "" : (String)check.second;
                toolTipText = String.format("File encoding is disabled%n%s", failReason);
                this.myComponent.setForeground(UIUtil.getInactiveTextColor());
                this.myComponent.setTextAlignment(0.5f);
            }
            this.myComponent.setToolTipText(toolTipText);
            this.myComponent.setText(charsetName);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }, 200, ModalityState.any());
    }

    public JComponent getComponent() {
        return this.myComponent;
    }
}

