/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.FilePathValidator;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.properties.ArchiveElementPropertiesPanel;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;

class ArchiveElementType
extends CompositePackagingElementType<ArchivePackagingElement> {
    ArchiveElementType() {
        super("archive", CompilerBundle.message((String)"element.type.name.archive", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlatformIcons.JAR_ICON;
    }

    @NotNull
    public ArchivePackagingElement createEmpty(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ArchiveElementType", "createEmpty"));
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement();
        if (archivePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ArchiveElementType", "createEmpty"));
        }
        return archivePackagingElement;
    }

    public PackagingElementPropertiesPanel createElementPropertiesPanel(@NotNull ArchivePackagingElement element, @NotNull ArtifactEditorContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ArchiveElementType", "createElementPropertiesPanel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArchiveElementType", "createElementPropertiesPanel"));
        }
        String name = element.getArchiveFileName();
        if (JpsArtifactUtil.isArchiveName((String)name)) {
            return new ArchiveElementPropertiesPanel(element, context);
        }
        return null;
    }

    public CompositePackagingElement<?> createComposite(CompositePackagingElement<?> parent, @Nullable String baseName, @NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ArchiveElementType", "createComposite"));
        }
        String initialValue = PackagingElementFactoryImpl.suggestFileName(parent, baseName != null ? baseName : "archive", ".jar");
        String path = Messages.showInputDialog((Project)context.getProject(), (String)"Enter archive name: ", (String)"New Archive", null, (String)initialValue, (InputValidator)new FilePathValidator());
        if (path == null) {
            return null;
        }
        return PackagingElementFactoryImpl.createDirectoryOrArchiveWithParents(path, true);
    }
}

