/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class PlatformProjectViewOpener
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(final Project project2, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/platform/PlatformProjectViewOpener", "configureProject"));
        }
        ToolWindowManagerEx manager = (ToolWindowManagerEx)ToolWindowManager.getInstance((Project)project2);
        final ToolWindow toolWindow = manager.getToolWindow(ToolWindowId.PROJECT_VIEW);
        if (toolWindow == null) {
            manager.addToolWindowManagerListener(new MyListener(manager, project2));
        } else {
            StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    PlatformProjectViewOpener.activateProjectToolWindow(project2, toolWindow);
                }
            });
        }
    }

    private static void activateProjectToolWindow(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/PlatformProjectViewOpener", "activateProjectToolWindow"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/platform/PlatformProjectViewOpener", "activateProjectToolWindow"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/PlatformProjectViewOpener", "lambda$activateProjectToolWindow$0"));
            }
            if (toolWindow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/platform/PlatformProjectViewOpener", "lambda$activateProjectToolWindow$0"));
            }
            if (project2.isDisposed()) {
                return;
            }
            if (toolWindow.getType() != ToolWindowType.SLIDING) {
                toolWindow.activate(null);
            }
        }, ModalityState.NON_MODAL);
    }

    private static class MyListener
    extends ToolWindowManagerAdapter {
        private final ToolWindowManagerEx myManager;
        private final Project myProject;

        public MyListener(ToolWindowManagerEx manager, Project project2) {
            this.myManager = manager;
            this.myProject = project2;
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/platform/PlatformProjectViewOpener$MyListener", "toolWindowRegistered"));
            }
            if (id.equals(ToolWindowId.PROJECT_VIEW)) {
                this.myManager.removeToolWindowManagerListener(this);
                PlatformProjectViewOpener.activateProjectToolWindow(this.myProject, this.myManager.getToolWindow(id));
            }
        }
    }
}

