/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.IsConstantExpressionVisitor;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiElementFinder[] myElementFinders;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;

    public JavaPsiFacadeImpl(Project project2, PsiManager psiManager, JavaFileManager javaFileManager, MessageBus bus) {
        this.myProject = project2;
        this.myFileManager = javaFileManager;
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        final PsiModificationTracker modificationTracker = psiManager.getModificationTracker();
        if (bus != null) {
            bus.connect().subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){
                private long lastTimeSeen = -1L;

                public void modificationCountChanged() {
                    JavaPsiFacadeImpl.this.myClassCache.clear();
                    long now = modificationTracker.getJavaStructureModificationCount();
                    if (this.lastTimeSeen != now) {
                        this.lastTimeSeen = now;
                        JavaPsiFacadeImpl.this.myPackageCache.clear();
                    }
                }
            });
        }
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
        this.myElementFinders = this.calcFinders();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass result2;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClass"));
        }
        ProgressIndicatorProvider.checkCanceled();
        Map map = (Map)this.myClassCache.get(scope);
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakValueMap();
            map = (Map)ConcurrencyUtil.cacheOrGet(this.myClassCache, (Object)scope, (Object)map);
        }
        if ((result2 = (PsiClass)map.get(qualifiedName)) == null && (result2 = this.doFindClass(qualifiedName, scope)) != null) {
            map.put(qualifiedName, result2);
        }
        return result2;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "doFindClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "doFindClass"));
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        PsiElementFinder[] finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null || classesFilter != null && !classesFilter.value((Object)aClass)) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName((String)className, (PsiClass[])containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] psiClassArray = this.findClassesInDumbMode(qualifiedName, scope);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
            }
            return psiClassArray;
        }
        PsiElementFinder[] finders = this.finders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            if (finderClasses.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result2);
        }
        PsiClass[] psiClassArray = result2 == null || result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findClasses"));
        }
        return psiClassArray;
    }

    private static Condition<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull PsiElementFinder[] finders) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getFilterFromFinders"));
        }
        if (finders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finders", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getFilterFromFinders"));
        }
        Condition filter = null;
        for (PsiElementFinder finder : finders) {
            Condition finderFilter = finder.getClassesFilter(scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    private PsiElementFinder[] finders() {
        return this.myElementFinders;
    }

    @NotNull
    protected PsiElementFinder[] calcFinders() {
        PsiElementFinder[] psiElementFinderArray = (PsiElementFinder[])this.myProject.getExtensions(PsiElementFinder.EP_NAME);
        if (psiElementFinderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "calcFinders"));
        }
        return psiElementFinderArray;
    }

    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getConstantEvaluationHelper"));
        }
        return psiConstantEvaluationHelper;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "findPackage"));
        }
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName);
        if (aPackage != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return (PsiPackage)ConcurrencyUtil.cacheOrGet(this.myPackageCache, (Object)qualifiedName, (Object)aPackage);
        }
        return null;
    }

    @NotNull
    private PsiElementFinder[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        Object[] finders = this.finders();
        if (dumbService.isDumb()) {
            List list = dumbService.filterByDumbAwareness(finders);
            finders = list.toArray(new PsiElementFinder[list.size()]);
        }
        if (finders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "filteredFinders"));
        }
        return finders;
    }

    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getParserFacade"));
        }
        return psiElementFactory;
    }

    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
        if (psiResolveHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getResolveHelper"));
        }
        return psiResolveHelper;
    }

    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        if (psiNameHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getNameHelper"));
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        THashSet result2 = new THashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result2.addAll(finder.getClassNames(psiPackage, scope));
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClassNames"));
        }
        return tHashSet;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        PsiElementFinder[] finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes = finder.getClasses(psiPackage, scope);
            if (classes.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(classes.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes, result2);
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getClasses"));
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Condition<PsiClass> classesFilter, @NotNull PsiClass[] classes, @NotNull List<PsiClass> result2) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/impl/JavaPsiFacadeImpl", "filterClassesAndAppend"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/JavaPsiFacadeImpl", "filterClassesAndAppend"));
        }
        for (PsiClass psiClass : classes) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.value((Object)psiClass)) continue;
            result2.add(psiClass);
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiDirectory[] directories;
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        Condition filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        for (PsiDirectory psiDirectory : directories = psiPackage.getDirectories(scope)) {
            for (PsiFile file2 : psiDirectory.getFiles()) {
                if (filter != null && !filter.value((Object)file2)) continue;
                result2.add(file2);
            }
        }
        for (PsiDirectory psiDirectory : this.filteredFinders()) {
            Collections.addAll(result2, psiDirectory.getPackageFiles(psiPackage, scope));
        }
        PsiFile[] psiFileArray = result2.toArray(new PsiFile[result2.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getPackageFiles"));
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/JavaPsiFacadeImpl", "processPackageDirectories"));
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        LinkedHashMap<String, PsiPackage> result2 = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages;
            for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                if (result2.get(aPackage.getName()) != null) continue;
                result2.put(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result2.values().toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isPartOfPackagePrefix"));
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf((String)subpackageName, (String)packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isInPackage"));
        }
        PsiFile file2 = FileContextUtil.getContextFile(element);
        if (file2 instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file2).isInPackage(aPackage);
        }
        if (file2 instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file2).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/psi/impl/JavaPsiFacadeImpl", "arePackagesTheSame"));
        }
        PsiFile file1 = FileContextUtil.getContextFile(element1);
        if (Comparing.equal((Object)file1, (Object)(file2 = FileContextUtil.getContextFile(element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Comparing.equal((String)package1, (String)package2);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getProject"));
        }
        return project2;
    }

    public boolean isConstantExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/impl/JavaPsiFacadeImpl", "isConstantExpression"));
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.isConstant();
    }

    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)this.myProject);
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiFacadeImpl", "getElementFactory"));
        }
        return psiElementFactory;
    }
}

