/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaFunctionalExpressionSearcher");
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(p);
        AtomicInteger exprCount = new AtomicInteger();
        AtomicInteger fileCount = new AtomicInteger();
        PsiManager manager = (PsiManager)ReadAction.compute(() -> {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processQuery$0"));
            }
            return p.getElementToSearch().getManager();
        });
        manager.startBatchFilesProcessingMode();
        try {
            JavaFunctionalExpressionSearcher.processOffsets(descriptors, (PairProcessor<VirtualFile, List<Integer>>)((PairProcessor)(file2, offsets) -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processQuery$1"));
                }
                fileCount.incrementAndGet();
                exprCount.addAndGet(offsets.size());
                return JavaFunctionalExpressionSearcher.processFile(consumer, descriptors, file2, offsets);
            }));
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        if (exprCount.get() > 0) {
            LOG.debug("Loaded " + exprCount.get() + " fun-expressions in " + fileCount.get() + " files");
        }
    }

    public static Set<VirtualFile> getFilesToSearchInPsi(PsiClass samClass) {
        HashSet result2 = new HashSet();
        JavaFunctionalExpressionSearcher.processOffsets(JavaFunctionalExpressionSearcher.calcDescriptors(new FunctionalExpressionSearch.SearchParameters(samClass, samClass.getUseScope())), (PairProcessor<VirtualFile, List<Integer>>)((PairProcessor)(arg_0, arg_1) -> JavaFunctionalExpressionSearcher.lambda$getFilesToSearchInPsi$2((Set)result2, arg_0, arg_1)));
        return result2;
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "calcDescriptors"));
        }
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            if (queryParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$calcDescriptors$3"));
            }
            PsiClass aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !aClass.isInterface()) {
                return;
            }
            Project project2 = aClass.getProject();
            if (InjectedLanguageManager.getInstance((Project)project2).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project2)) {
                return;
            }
            for (PsiClass samClass : JavaFunctionalExpressionSearcher.processSubInterfaces(aClass)) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass((PsiClass)samClass) || (samType = (saMethod = (PsiMethod)ObjectUtils.assertNotNull((Object)LambdaUtil.getFunctionalInterfaceMethod((PsiClass)samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(queryParameters.getEffectiveSearchScope());
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope(scope, project2)));
            }
        });
        ArrayList<SamDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "calcDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(List<SamDescriptor> descriptors) {
        Set set2 = JBIterable.from(descriptors).flatMap(rec$ -> ((SamDescriptor)rec$).getMostLikelyFiles()).toSet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getLikelyFiles"));
        }
        return set2;
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(List<SamDescriptor> descriptors) {
        MultiMap result2 = MultiMap.createLinkedSet();
        for (SamDescriptor descriptor : descriptors) {
            ReadAction.run(() -> {
                for (FunctionalExpressionKey key2 : descriptor.generateKeys()) {
                    FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key2, null, (file2, infos) -> {
                        ProgressManager.checkCanceled();
                        result2.putValues((Object)file2, (Collection)infos);
                        return true;
                    }, (GlobalSearchScope)new JavaSourceFilterScope(descriptor.useScope));
                }
            });
        }
        LOG.debug("Found " + result2.values().size() + " fun-expressions in " + result2.keySet().size() + " files");
        MultiMap multiMap = result2;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getAllOccurrences"));
        }
        return multiMap;
    }

    private static void processOffsets(List<SamDescriptor> descriptors, PairProcessor<VirtualFile, List<Integer>> processor2) {
        if (descriptors.isEmpty()) {
            return;
        }
        List samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        for (VirtualFile vFile : JavaFunctionalExpressionSearcher.putLikelyFilesFirst(descriptors, allCandidates.keySet())) {
            List<FunExprOccurrence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, allCandidates.get((Object)vFile));
            if (toLoad.isEmpty()) continue;
            LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
            if (processor2.process((Object)vFile, (Object)ContainerUtil.map(toLoad, it -> it.funExprOffset))) continue;
            return;
        }
    }

    @NotNull
    private static Set<VirtualFile> putLikelyFilesFirst(List<SamDescriptor> descriptors, Set<VirtualFile> allFiles) {
        LinkedHashSet<VirtualFile> orderedFiles = new LinkedHashSet<VirtualFile>(allFiles);
        orderedFiles.retainAll(JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors));
        orderedFiles.addAll(allFiles);
        LinkedHashSet<VirtualFile> linkedHashSet = orderedFiles;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "putLikelyFilesFirst"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<FunExprOccurrence> filterInapplicable(List<PsiClass> samClasses, VirtualFile vFile, Collection<FunExprOccurrence> occurrences) {
        List list = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)occurrences, it -> it.canHaveType(samClasses, vFile)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "filterInapplicable"));
        }
        return list;
    }

    private static boolean processFile(@NotNull Processor<PsiFunctionalExpression> consumer, List<SamDescriptor> descriptors, VirtualFile vFile, Collection<Integer> offsets) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processFile"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "lambda$processFile$11"));
            }
            PsiFile file2 = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager().findFile(vFile);
            if (!(file2 instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file2 + "; " + vFile);
                return true;
            }
            for (Integer offset : offsets) {
                PsiFunctionalExpression expression = (PsiFunctionalExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PsiFunctionalExpression.class, (boolean)false);
                if (expression == null || expression.getTextRange().getStartOffset() != offset.intValue()) {
                    LOG.error("Fun expression not found in " + file2 + " at " + offset);
                    continue;
                }
                if (!JavaFunctionalExpressionSearcher.hasType(descriptors, expression) || consumer.process((Object)expression)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean hasType(List<SamDescriptor> descriptors, PsiFunctionalExpression expression) {
        if (!JavaFunctionalExpressionSearcher.canHaveType(expression, ContainerUtil.map(descriptors, d -> d.samClass))) {
            return false;
        }
        PsiClass actualClass = PsiUtil.resolveClassInType((PsiType)expression.getFunctionalInterfaceType());
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)d.samClass, (boolean)true));
    }

    private static boolean canHaveType(PsiFunctionalExpression expression, List<PsiClass> samClasses) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null || ContainerUtil.exists(methods, m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses));
            }
        }
        return true;
    }

    private static boolean hasJava8Modules(Project project2) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project2).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module2).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static Set<PsiClass> processSubInterfaces(PsiClass base) {
        HashSet result2 = new HashSet();
        new Object((Set)result2){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set2;
            }

            void visit(PsiClass c) {
                if (!this.val$result.add(c)) {
                    return;
                }
                DirectClassInheritorsSearch.search((PsiClass)c).forEach(candidate -> {
                    if (candidate.isInterface()) {
                        this.visit((PsiClass)candidate);
                    }
                    return true;
                });
            }
        }.visit(base);
        return result2;
    }

    private static /* synthetic */ boolean lambda$getFilesToSearchInPsi$2(Set result2, VirtualFile file2, List offsets) {
        return result2.add(file2);
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final GlobalSearchScope useScope;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;

        SamDescriptor(PsiClass samClass, PsiMethod samMethod, PsiType samType, GlobalSearchScope useScope) {
            this.samClass = samClass;
            this.useScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals((Object)samType);
        }

        List<FunctionalExpressionKey> generateKeys() {
            ArrayList<FunctionalExpressionKey> result2 = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{(String)ObjectUtils.assertNotNull((Object)this.samClass.getName()), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result2.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            return result2;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles() {
            LinkedHashSet files = ContainerUtil.newLinkedHashSet();
            ReadAction.run(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className = this.samClass.getName();
                Project project2 = this.samClass.getProject();
                if (className == null) {
                    return;
                }
                LinkedHashSet likelyNames = ContainerUtil.newLinkedHashSet((Object[])new String[]{className});
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className, project2, this.useScope, PsiMethod.class, method2 -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method2.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project2);
                Processor processor2 = Processors.cancelableCollectProcessor((Collection)files);
                for (String word : likelyNames) {
                    helper.processFilesWithText(this.useScope, (short)1, true, word, (Processor<VirtualFile>)processor2);
                }
            });
            LinkedHashSet linkedHashSet = files;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher$SamDescriptor", "getMostLikelyFiles"));
            }
            return linkedHashSet;
        }
    }
}

