/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentIndex
extends ScalarIndexExtension<MethodCallData>
implements PsiDependentIndex {
    private static final Logger LOG = Logger.getInstance(JavaNullMethodArgumentIndex.class);
    public static final ID<MethodCallData, Void> INDEX_ID = ID.create((String)"java.null.method.argument");
    private boolean myOfflineMode = ApplicationManager.getApplication().isCommandLine() && !ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public ID<MethodCallData, Void> getName() {
        ID<MethodCallData, Void> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<MethodCallData, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            CharSequence contentAsText = inputData.getContentAsText();
            if (!JavaStubElementTypes.JAVA_FILE.shouldBuildStubFor(inputData.getFile())) {
                return Collections.emptyMap();
            }
            if (this.myOfflineMode) {
                return Collections.emptyMap();
            }
            if (!StringUtil.contains((CharSequence)contentAsText, (CharSequence)"null")) {
                return Collections.emptyMap();
            }
            THashMap result2 = new THashMap();
            LighterAST lighterAst = ((FileContentImpl)((Object)inputData)).getLighterASTForPsiDependentIndex();
            new RecursiveLighterASTNodeWalkingVisitor(lighterAst, (Map)result2, lighterAst){
                final /* synthetic */ Map val$result;
                final /* synthetic */ LighterAST val$lighterAst;
                {
                    this.val$result = map;
                    this.val$lighterAst = lighterAST;
                    super(arg0);
                }

                @Override
                public void visitNode(@NotNull LighterASTNode element) {
                    String name;
                    IntArrayList indices;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1", "visitNode"));
                    }
                    if ((element.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || element.getTokenType() == JavaElementType.NEW_EXPRESSION || element.getTokenType() == JavaElementType.ANONYMOUS_CLASS) && (indices = this.getNullParameterIndices(element)) != null && (name = this.getMethodName(element, element.getTokenType())) != null) {
                        for (int i2 = 0; i2 < indices.size(); ++i2) {
                            int nullParameterIndex = indices.get(i2);
                            this.val$result.put(new MethodCallData(name, nullParameterIndex), null);
                        }
                    }
                    super.visitNode(element);
                }

                @Nullable
                private IntArrayList getNullParameterIndices(@NotNull LighterASTNode methodCall) {
                    if (methodCall == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1", "getNullParameterIndices"));
                    }
                    LighterASTNode node = LightTreeUtil.firstChildOfType(this.val$lighterAst, methodCall, JavaElementType.EXPRESSION_LIST);
                    if (node == null) {
                        return null;
                    }
                    List<LighterASTNode> parameters = LightTreeUtil.getChildrenOfType(this.val$lighterAst, node, ElementType.EXPRESSION_BIT_SET);
                    IntArrayList indices = null;
                    for (int idx = 0; idx < parameters.size(); ++idx) {
                        CharSequence literal;
                        LighterASTNode parameter = parameters.get(idx);
                        if (parameter.getTokenType() != JavaElementType.LITERAL_EXPRESSION || !StringUtil.equals((CharSequence)(literal = ((LighterASTTokenNode)this.val$lighterAst.getChildren(parameter).get(0)).getText()), (CharSequence)"null")) continue;
                        if (indices == null) {
                            indices = new IntArrayList(1);
                        }
                        indices.add(idx);
                    }
                    return indices;
                }

                @Nullable
                private String getMethodName(@NotNull LighterASTNode call, IElementType elementType) {
                    if (call == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$1", "getMethodName"));
                    }
                    if (elementType == JavaElementType.NEW_EXPRESSION || elementType == JavaElementType.ANONYMOUS_CLASS) {
                        List<LighterASTNode> refs = LightTreeUtil.getChildrenOfType(this.val$lighterAst, call, JavaElementType.JAVA_CODE_REFERENCE);
                        if (refs.isEmpty()) {
                            return null;
                        }
                        LighterASTNode lastRef = refs.get(refs.size() - 1);
                        return this.getLastIdentifierText(lastRef);
                    }
                    LOG.assertTrue(elementType == JavaElementType.METHOD_CALL_EXPRESSION);
                    LighterASTNode methodReference = (LighterASTNode)this.val$lighterAst.getChildren(call).get(0);
                    if (methodReference.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
                        return this.getLastIdentifierText(methodReference);
                    }
                    return null;
                }

                @Nullable
                private String getLastIdentifierText(LighterASTNode lastRef) {
                    List<LighterASTNode> identifiers = LightTreeUtil.getChildrenOfType(this.val$lighterAst, lastRef, JavaTokenType.IDENTIFIER);
                    if (identifiers.isEmpty()) {
                        return null;
                    }
                    LighterASTNode methodNameIdentifier = identifiers.get(identifiers.size() - 1);
                    return RecordUtil.intern(this.val$lighterAst.getCharTable(), methodNameIdentifier);
                }
            }.visitNode(lighterAst.getRoot());
            return result2;
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<MethodCallData> getKeyDescriptor() {
        KeyDescriptor<MethodCallData> keyDescriptor = new KeyDescriptor<MethodCallData>(){

            public int getHashCode(MethodCallData value) {
                return value.hashCode();
            }

            public boolean isEqual(MethodCallData val1, MethodCallData val2) {
                return val1.equals(val2);
            }

            public void save(@NotNull DataOutput out, MethodCallData value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$2", "save"));
                }
                EnumeratorStringDescriptor.INSTANCE.save(out, value.getMethodName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getNullParameterIndex());
            }

            public MethodCallData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$2", "read"));
                }
                return new MethodCallData(EnumeratorStringDescriptor.INSTANCE.read(in), DataInputOutputUtil.readINT((DataInput)in));
            }
        };
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static final class MethodCallData {
        @NotNull
        private final String myMethodName;
        private final int myNullParameterIndex;

        public MethodCallData(@NotNull String name, int index) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData", "<init>"));
            }
            this.myMethodName = name;
            this.myNullParameterIndex = index;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaNullMethodArgumentIndex$MethodCallData", "getMethodName"));
            }
            return string;
        }

        public int getNullParameterIndex() {
            return this.myNullParameterIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallData data = (MethodCallData)o;
            if (this.myNullParameterIndex != data.myNullParameterIndex) {
                return false;
            }
            return this.myMethodName.equals(data.myMethodName);
        }

        public int hashCode() {
            int result2 = this.myMethodName.hashCode();
            result2 = 31 * result2 + this.myNullParameterIndex;
            return result2;
        }

        public String toString() {
            return "MethodCallData{myMethodName='" + this.myMethodName + '\'' + ", myNullParameterIndex=" + this.myNullParameterIndex + '}';
        }
    }
}

