/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentCalculator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private BaseLineOffsetCalculator myBaseLineOffsetCalculator;
    @NotNull
    private final Indent.Type myIndentType;
    public static final BaseLineOffsetCalculator LINE_BEFORE = new BaseLineOffsetCalculator(){

        @Override
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
            if (currPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator$1", "getOffsetInBaseIndentLine"));
            }
            return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)currPosition.getStartOffset(), (String)" \t\n\r");
        }
    };

    public IndentCalculator(@NotNull Project project2, @NotNull Editor editor, @NotNull BaseLineOffsetCalculator baseLineOffsetCalculator, @NotNull Indent.Type type) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "<init>"));
        }
        if (baseLineOffsetCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLineOffsetCalculator", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "<init>"));
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myBaseLineOffsetCalculator = baseLineOffsetCalculator;
        this.myIndentType = type;
    }

    @Nullable
    String getIndentString(@Nullable Language language, @NotNull SemanticEditorPosition currPosition) {
        if (currPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "getIndentString"));
        }
        String baseIndent = this.getBaseIndent(currPosition);
        Document document = this.myEditor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file2 != null) {
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
            CommonCodeStyleSettings.IndentOptions options = language != null && !language.is(file2.getLanguage()) && !language.is(Language.ANY) ? codeStyleSettings.getCommonSettings(language).getIndentOptions() : codeStyleSettings.getIndentOptionsByFile(file2);
            return baseIndent + new IndentInfo(0, IndentCalculator.indentTypeToSize(this.myIndentType, options), 0, false).generateNewWhiteSpace(options);
        }
        return null;
    }

    @NotNull
    private String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
        int indentEnd;
        int indentStart;
        int indentLineOffset;
        if (currPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "getBaseIndent"));
        }
        CharSequence docChars = this.myEditor.getDocument().getCharsSequence();
        int offset = currPosition.getStartOffset();
        if (offset > 0 && (indentLineOffset = this.myBaseLineOffsetCalculator.getOffsetInBaseIndentLine(currPosition)) > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)indentLineOffset, (String)"\n") + 1) >= 0 && (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) > indentStart) {
            String string = docChars.subSequence(indentStart, indentEnd).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "getBaseIndent"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "getBaseIndent"));
        }
        return "";
    }

    private static int indentTypeToSize(@NotNull Indent.Type indentType, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (indentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentType", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "indentTypeToSize"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator", "indentTypeToSize"));
        }
        if (indentType == Indent.Type.NORMAL) {
            return options.INDENT_SIZE;
        }
        if (indentType == Indent.Type.CONTINUATION) {
            return options.CONTINUATION_INDENT_SIZE;
        }
        return 0;
    }

    public static interface BaseLineOffsetCalculator {
        public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition var1);
    }
}

