/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedLineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaLikeLangLineIndentProvider
extends FormatterBasedLineIndentProvider {
    @Override
    @Nullable
    public String getLineIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getLineIndent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getLineIndent"));
        }
        if (offset > 0) {
            IndentCalculator indentCalculator = this.getIndent(project2, editor, language, offset - 1);
            if (indentCalculator != null) {
                return indentCalculator.getIndentString(language, this.getPosition(editor, offset - 1));
            }
        } else {
            return "";
        }
        return super.getLineIndent(project2, editor, language, offset);
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getIndent"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getIndent"));
        }
        IndentCalculatorFactory myFactory = new IndentCalculatorFactory(project2, editor);
        if (this.getPosition(editor, offset).matchesRule(position -> position.isAt(JavaLikeElement.Whitespace) && position.isAtMultiline()) && !this.getPosition(editor, offset).before().isAt(JavaLikeElement.Comma)) {
            if (this.getPosition(editor, offset + 1).isAt(JavaLikeElement.BlockClosingBrace)) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, position -> {
                    position.findLeftParenthesisBackwardsSkippingNested(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                    if (!position.isAtEnd()) {
                        return this.getBlockStatementStartOffset(position);
                    }
                    return -1;
                });
            }
            if (this.getPosition(editor, offset).matchesRule(position -> position.before().beforeOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockClosingBrace))) {
                return myFactory.createIndentCalculator(JavaLikeLangLineIndentProvider.getBlockIndentType(project2, language), IndentCalculator.LINE_BEFORE);
            }
            if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.Semicolon))) {
                int statementStart;
                SemanticEditorPosition atStatementStart;
                SemanticEditorPosition beforeSemicolon = this.getPosition(editor, offset).before().beforeOptional(JavaLikeElement.Semicolon);
                if (beforeSemicolon.isAt(JavaLikeElement.BlockClosingBrace)) {
                    beforeSemicolon.beforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
                }
                if (!(atStatementStart = this.getPosition(editor, statementStart = this.getStatementStartOffset(beforeSemicolon))).isAfterOnSameLine(JavaLikeElement.ForKeyword)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> statementStart);
                }
            } else {
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.ArrayOpeningBracket))) {
                    return myFactory.createIndentCalculator(this.getIndentTypeInBrackets(), IndentCalculator.LINE_BEFORE);
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.LeftParenthesis))) {
                    return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.BlockOpeningBrace))) {
                    SemanticEditorPosition position2 = this.getPosition(editor, offset).before();
                    return myFactory.createIndentCalculator(this.getIndentTypeInBlock(project2, language, position2), this::getBlockStatementStartOffset);
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.Colon) && position.isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault)) || this.getPosition(editor, offset).matchesRule(position -> position.before().isAtAnyOf(JavaLikeElement.ElseKeyword, JavaLikeElement.DoKeyword))) {
                    return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.BlockComment) && position.before().isAt(JavaLikeElement.Whitespace) && position.isAtMultiline())) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.BlockComment));
                }
                if (this.getPosition(editor, offset).matchesRule(position -> position.before().isAt(JavaLikeElement.DocBlockEnd))) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, position -> position.findStartOf(JavaLikeElement.DocBlockStart));
                }
                SemanticEditorPosition position3 = this.getPosition(editor, offset);
                if ((position3 = position3.before().beforeOptionalMix(JavaLikeElement.LineComment, JavaLikeElement.BlockComment, JavaLikeElement.Whitespace)).isAt(JavaLikeElement.RightParenthesis)) {
                    int offsetAfterParen = position3.getStartOffset() + 1;
                    position3.beforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
                    if (!position3.isAtEnd()) {
                        position3.beforeOptional(JavaLikeElement.Whitespace);
                        if (position3.isAt(JavaLikeElement.IfKeyword) || position3.isAt(JavaLikeElement.ForKeyword)) {
                            SemanticEditorPosition.SyntaxElement element = position3.getCurrElement();
                            assert (element != null);
                            int controlKeywordOffset = position3.getStartOffset();
                            Indent.Type indentType = this.getPosition(editor, offsetAfterParen).afterOptional(JavaLikeElement.Whitespace).isAt(JavaLikeElement.BlockOpeningBrace) ? Indent.Type.NONE : Indent.Type.NORMAL;
                            return myFactory.createIndentCalculator(indentType, baseLineOffset -> controlKeywordOffset);
                        }
                    }
                }
            }
        }
        return null;
    }

    private int getBlockStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getBlockStatementStartOffset"));
        }
        position.before().beforeOptional(JavaLikeElement.BlockOpeningBrace);
        if (position.isAt(JavaLikeElement.Whitespace)) {
            if (position.isAtMultiline()) {
                return position.after().getStartOffset();
            }
            position.before();
        }
        return this.getStatementStartOffset(position);
    }

    private int getStatementStartOffset(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getStatementStartOffset"));
        }
        Language currLanguage = position.getLanguage();
        while (!position.isAtEnd()) {
            if (currLanguage == Language.ANY || currLanguage == null) {
                currLanguage = position.getLanguage();
            }
            if (position.isAt(JavaLikeElement.Colon)) {
                SemanticEditorPosition afterColon = this.getPosition(position.getEditor(), position.getStartOffset()).after().afterOptional(JavaLikeElement.Whitespace);
                if (position.isAfterOnSameLine(JavaLikeElement.SwitchCase, JavaLikeElement.SwitchDefault)) {
                    return afterColon.getStartOffset();
                }
            } else if (position.isAt(JavaLikeElement.RightParenthesis)) {
                position.beforeParentheses(JavaLikeElement.LeftParenthesis, JavaLikeElement.RightParenthesis);
            } else if (position.isAt(JavaLikeElement.BlockClosingBrace)) {
                position.beforeParentheses(JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockClosingBrace);
            } else if (position.isAt(JavaLikeElement.ArrayClosingBracket)) {
                position.beforeParentheses(JavaLikeElement.ArrayOpeningBracket, JavaLikeElement.ArrayClosingBracket);
            } else if (position.isAtAnyOf(JavaLikeElement.Semicolon, JavaLikeElement.BlockOpeningBrace, JavaLikeElement.BlockComment, JavaLikeElement.DocBlockEnd, JavaLikeElement.LeftParenthesis, JavaLikeElement.LanguageStartDelimiter) || position.getLanguage() != Language.ANY && !position.isAtLanguage(currLanguage)) {
                SemanticEditorPosition statementStart = this.getPosition(position.getEditor(), position.getStartOffset());
                statementStart.after().afterOptionalMix(JavaLikeElement.Whitespace, JavaLikeElement.LineComment);
                if (!statementStart.isAtEnd()) {
                    return statementStart.getStartOffset();
                }
            }
            position.before();
        }
        return 0;
    }

    protected SemanticEditorPosition getPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getPosition"));
        }
        return new SemanticEditorPosition((EditorEx)editor, offset){

            @Override
            public SemanticEditorPosition.SyntaxElement map(@NotNull IElementType elementType) {
                if (elementType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider$1", "map"));
                }
                return JavaLikeLangLineIndentProvider.this.mapType(elementType);
            }
        };
    }

    @Nullable
    protected abstract SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType var1);

    @Nullable
    protected Indent.Type getIndentTypeInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getIndentTypeInBlock"));
        }
        if (blockStartPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStartPosition", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getIndentTypeInBlock"));
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(language);
            if (settings.BRACE_STYLE == 3) {
                return settings.METHOD_BRACE_STYLE == 3 ? Indent.Type.NONE : null;
            }
        }
        return Indent.Type.NORMAL;
    }

    @Nullable
    private static Indent.Type getBlockIndentType(@NotNull Project project2, @Nullable Language language) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider", "getBlockIndentType"));
        }
        if (language != null) {
            CommonCodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(language);
            if (settings.BRACE_STYLE == 2 || settings.BRACE_STYLE == 1) {
                return Indent.Type.NONE;
            }
        }
        return null;
    }

    @Override
    public final boolean isSuitableFor(@Nullable Language language) {
        return language != null && this.isSuitableForLanguage(language);
    }

    public abstract boolean isSuitableForLanguage(@NotNull Language var1);

    protected Indent.Type getIndentTypeInBrackets() {
        return Indent.Type.CONTINUATION;
    }

    public static class IndentCalculatorFactory {
        private Project myProject;
        private Editor myEditor;

        public IndentCalculatorFactory(Project project2, Editor editor) {
            this.myProject = project2;
            this.myEditor = editor;
        }

        @Nullable
        public IndentCalculator createIndentCalculator(@Nullable Indent.Type indentType, @Nullable IndentCalculator.BaseLineOffsetCalculator baseLineOffsetCalculator) {
            return indentType != null ? new IndentCalculator(this.myProject, this.myEditor, baseLineOffsetCalculator != null ? baseLineOffsetCalculator : IndentCalculator.LINE_BEFORE, indentType) : null;
        }
    }

    public static enum JavaLikeElement implements SemanticEditorPosition.SyntaxElement
    {
        Whitespace,
        Semicolon,
        BlockOpeningBrace,
        BlockClosingBrace,
        ArrayOpeningBracket,
        ArrayClosingBracket,
        RightParenthesis,
        LeftParenthesis,
        Colon,
        SwitchCase,
        SwitchDefault,
        ElseKeyword,
        IfKeyword,
        ForKeyword,
        DoKeyword,
        BlockComment,
        DocBlockStart,
        DocBlockEnd,
        LineComment,
        Comma,
        LanguageStartDelimiter;

    }
}

