/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.impl.source.tree.LighterASTNodeVisitor;
import com.intellij.util.Function;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveLighterASTNodeWalkingVisitor
extends LighterASTNodeVisitor {
    @NotNull
    private final LighterAST ast;
    private final Stack<IndexedLighterASTNode[]> childrenStack;
    private final Stack<IndexedLighterASTNode> parentStack;
    private final WalkingState<IndexedLighterASTNode> myWalkingState;

    protected RecursiveLighterASTNodeWalkingVisitor(final @NotNull LighterAST ast) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "<init>"));
        }
        this.childrenStack = new Stack();
        this.parentStack = new Stack();
        this.ast = ast;
        this.myWalkingState = new WalkingState<IndexedLighterASTNode>((WalkingState.TreeGuide)new LighterASTGuide()){

            public void elementFinished(@NotNull IndexedLighterASTNode element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "elementFinished"));
                }
                RecursiveLighterASTNodeWalkingVisitor.this.elementFinished(element.node);
                if (RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek() == element) {
                    Object[] children2 = (IndexedLighterASTNode[])RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.pop();
                    List list = children2.length == 0 ? Collections.emptyList() : ContainerUtil.map((Object[])children2, (Function)new Function<IndexedLighterASTNode, LighterASTNode>(){

                        public LighterASTNode fun(IndexedLighterASTNode node) {
                            return node.node;
                        }
                    });
                    ast.disposeChildren(list);
                    RecursiveLighterASTNodeWalkingVisitor.this.parentStack.pop();
                }
            }

            public void visit(@NotNull IndexedLighterASTNode iNode) {
                if (iNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iNode", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$1", "visit"));
                }
                LighterASTNode element = iNode.node;
                RecursiveLighterASTNodeWalkingVisitor visitor = RecursiveLighterASTNodeWalkingVisitor.this;
                if (element instanceof LighterLazyParseableNode) {
                    visitor.visitLazyParseableNode((LighterLazyParseableNode)element);
                } else if (element instanceof LighterASTTokenNode) {
                    visitor.visitTokenNode((LighterASTTokenNode)element);
                } else {
                    visitor.visitNode(element);
                }
            }
        };
    }

    protected void elementFinished(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "elementFinished"));
        }
    }

    @Override
    public void visitNode(@NotNull LighterASTNode element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor", "visitNode"));
        }
        this.myWalkingState.elementStarted((Object)new IndexedLighterASTNode(element, null));
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private class LighterASTGuide
    implements WalkingState.TreeGuide<IndexedLighterASTNode> {
        private LighterASTGuide() {
        }

        public IndexedLighterASTNode getNextSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getNextSibling"));
            }
            return element.next;
        }

        public IndexedLighterASTNode getPrevSibling(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getPrevSibling"));
            }
            return element.prev;
        }

        public IndexedLighterASTNode getFirstChild(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getFirstChild"));
            }
            List children2 = RecursiveLighterASTNodeWalkingVisitor.this.ast.getChildren(element.node);
            IndexedLighterASTNode[] indexedChildren = children2.isEmpty() ? IndexedLighterASTNode.EMPTY_ARRAY : new IndexedLighterASTNode[children2.size()];
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                IndexedLighterASTNode indexedNode;
                LighterASTNode child = (LighterASTNode)children2.get(i2);
                indexedChildren[i2] = indexedNode = new IndexedLighterASTNode(child, i2 == 0 ? null : indexedChildren[i2 - 1]);
                if (i2 == 0) continue;
                indexedChildren[i2 - 1].next = indexedNode;
            }
            RecursiveLighterASTNodeWalkingVisitor.this.childrenStack.push((Object)indexedChildren);
            RecursiveLighterASTNodeWalkingVisitor.this.parentStack.push((Object)element);
            return children2.isEmpty() ? null : indexedChildren[0];
        }

        public IndexedLighterASTNode getParent(@NotNull IndexedLighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$LighterASTGuide", "getParent"));
            }
            return (IndexedLighterASTNode)RecursiveLighterASTNodeWalkingVisitor.this.parentStack.peek();
        }
    }

    private static class IndexedLighterASTNode {
        private static final IndexedLighterASTNode[] EMPTY_ARRAY = new IndexedLighterASTNode[0];
        private final LighterASTNode node;
        private final IndexedLighterASTNode prev;
        private IndexedLighterASTNode next;

        IndexedLighterASTNode(@NotNull LighterASTNode node, IndexedLighterASTNode prev) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor$IndexedLighterASTNode", "<init>"));
            }
            this.node = node;
            this.prev = prev;
        }
    }
}

