/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InjectedFileViewProvider
extends SingleRootFileViewProvider
implements FreeThreadedFileViewProvider {
    private Project myProject;
    private final Object myLock;
    private final DocumentWindowImpl myDocumentWindow;
    private static final ThreadLocal<Boolean> disabledTemporarily = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private boolean myPatchingLeaves;
    static Key<Language> LANGUAGE_FOR_INJECTED_COPY_KEY = Key.create((String)"LANGUAGE_FOR_INJECTED_COPY_KEY");

    InjectedFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFileWindow virtualFile, @NotNull DocumentWindowImpl documentWindow, @NotNull Language language) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "<init>"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "<init>"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "<init>"));
        }
        super(psiManager, (VirtualFile)virtualFile, true, language);
        this.myLock = new Object();
        this.myDocumentWindow = documentWindow;
        this.myProject = documentWindow.getShreds().getHostPointer().getProject();
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "rootChanged"));
        }
        super.rootChanged(psiFile);
        if (!this.isPhysical()) {
            return;
        }
        if (this.myPatchingLeaves) {
            return;
        }
        DocumentWindowImpl documentWindow = this.myDocumentWindow;
        Place shreds = documentWindow.getShreds();
        assert (documentWindow.getHostRanges().length == shreds.size());
        String[] changes = documentWindow.calculateMinEditSequence(psiFile.getNode().getText());
        assert (changes.length == shreds.size());
        for (int i2 = 0; i2 < changes.length; ++i2) {
            String change = changes[i2];
            if (change == null) continue;
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i2);
            PsiLanguageInjectionHost host = shred.getHost();
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            String newHostText = StringUtil.replaceSubstring((String)host.getText(), (TextRange)rangeInsideHost, (String)change);
            host.updateText(newHostText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileViewProvider clone() {
        final DocumentWindow oldDocumentWindow = ((VirtualFileWindow)this.getVirtualFile()).getDocumentWindow();
        Document hostDocument = oldDocumentWindow.getDelegate();
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getManager().getProject());
        PsiFile hostFile = documentManager.getPsiFile(hostDocument);
        Language language = this.getBaseLanguage();
        PsiFile file2 = this.getPsi(language);
        Language hostFileLanguage = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2).getLanguage();
        PsiFile hostPsiFileCopy = (PsiFile)hostFile.copy();
        Segment firstTextRange = oldDocumentWindow.getHostRanges()[0];
        PsiElement hostElementCopy = hostPsiFileCopy.getViewProvider().findElementAt(firstTextRange.getStartOffset(), hostFileLanguage);
        assert (hostElementCopy != null);
        final Ref provider = new Ref();
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider$2", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider$2", "visit"));
                }
                Document document = documentManager.getCachedDocument(injectedPsi);
                if (document instanceof DocumentWindowImpl && oldDocumentWindow.areRangesEqual((DocumentWindow)((DocumentWindowImpl)document))) {
                    provider.set((Object)injectedPsi.getViewProvider());
                }
            }
        };
        for (PsiElement current = hostElementCopy; current != null && current != hostPsiFileCopy; current = current.getParent()) {
            current.putUserData(LANGUAGE_FOR_INJECTED_COPY_KEY, (Object)language);
            try {
                InjectedLanguageUtil.enumerate(current, hostPsiFileCopy, false, visitor);
            }
            finally {
                current.putUserData(LANGUAGE_FOR_INJECTED_COPY_KEY, null);
            }
            if (provider.get() != null) break;
        }
        return (FileViewProvider)provider.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setShreds(@NotNull Place newShreds, @NotNull Project project2) {
        if (newShreds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newShreds", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "setShreds"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "setShreds"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myProject = project2;
            Place oldShreds = this.myDocumentWindow.getShreds();
            if (InjectedFileViewProvider.same(oldShreds, newShreds)) {
                return false;
            }
            this.myDocumentWindow.setShreds(newShreds);
            return true;
        }
    }

    private static boolean same(Place oldShreds, Place newShreds) {
        if (oldShreds == newShreds) {
            return true;
        }
        if (oldShreds.size() != newShreds.size()) {
            return false;
        }
        for (int i2 = 0; i2 < oldShreds.size(); ++i2) {
            PsiLanguageInjectionHost.Shred newShred;
            PsiLanguageInjectionHost.Shred oldShred = (PsiLanguageInjectionHost.Shred)oldShreds.get(i2);
            if (oldShred.equals(newShred = (PsiLanguageInjectionHost.Shred)newShreds.get(i2))) continue;
            return false;
        }
        return true;
    }

    boolean isValid() {
        return this.getShreds().isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myProject.isDisposed();
        }
    }

    Place getShreds() {
        return this.myDocumentWindow.getShreds();
    }

    @NotNull
    public DocumentWindow getDocument() {
        DocumentWindowImpl documentWindowImpl = this.myDocumentWindow;
        if (documentWindowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/InjectedFileViewProvider", "getDocument"));
        }
        return documentWindowImpl;
    }

    @Override
    public boolean isEventSystemEnabled() {
        if (this.myLock == null) {
            return true;
        }
        return disabledTemporarily.get() == false;
    }

    @Override
    public boolean isPhysical() {
        return this.isEventSystemEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performNonPhysically(Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            disabledTemporarily.set(true);
            try {
                runnable2.run();
            }
            finally {
                disabledTemporarily.set(false);
            }
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "Injected file '" + this.getVirtualFile().getName() + "' " + (this.isValid() ? "" : " invalid") + (this.isPhysical() ? "" : " nonphysical");
    }

    void setPatchingLeaves(boolean patchingLeaves) {
        this.myPatchingLeaves = patchingLeaves;
    }
}

