/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiSynchronizedStatementImpl
extends CompositePsiElement
implements PsiSynchronizedStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiSynchronizedStatementImpl");

    public PsiSynchronizedStatementImpl() {
        super(SYNCHRONIZED_STATEMENT);
    }

    public PsiExpression getLockExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(80);
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(60);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 79: {
                return this.findChildByType(SYNCHRONIZED_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 80: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 60: 
        }
        return this.findChildByType((IElementType)CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == SYNCHRONIZED_KEYWORD) {
            return 79;
        }
        if (i2 == LPARENTH) {
            return 24;
        }
        if (i2 == RPARENTH) {
            return 25;
        }
        if (i2 == CODE_BLOCK) {
            return 60;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 80;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiSynchronizedStatementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSynchronizedStatement((PsiSynchronizedStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiSynchronizedStatement";
    }
}

