/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ObjectStubTree<T extends Stub> {
    protected static final Key<ObjectStubTree> STUB_TO_TREE_REFERENCE = Key.create((String)"stub to tree reference");
    public static final Key<Integer> LAST_STUB_TREE_HASH = Key.create((String)"LAST_STUB_TREE_HASH");
    protected final ObjectStubBase myRoot;
    private String myDebugInfo;
    protected final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase root, boolean withBackReference) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/ObjectStubTree", "<init>"));
        }
        this.myPlainList = new ArrayList<T>();
        this.myRoot = root;
        ObjectStubTree.enumerateStubs((Stub)root, this.myPlainList);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, (Object)this);
        }
    }

    @NotNull
    public Stub getRoot() {
        ObjectStubBase objectStubBase = this.myRoot;
        if (objectStubBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "getRoot"));
        }
        return objectStubBase;
    }

    @NotNull
    public List<T> getPlainList() {
        List<T> list = this.myPlainList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "getPlainList"));
        }
        return list;
    }

    @NotNull
    public List<T> getPlainListFromAllRoots() {
        List<T> list = this.getPlainList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "getPlainListFromAllRoots"));
        }
        return list;
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, int[]>> indexStubTree() {
        StubIndexSink sink = new StubIndexSink();
        List<T> plainList = this.getPlainListFromAllRoots();
        int plainListSize = plainList.size();
        for (int i2 = 0; i2 < plainListSize; ++i2) {
            Stub stub = (Stub)plainList.get(i2);
            sink.myStubIdx = i2;
            StubSerializationUtil.getSerializer((Stub)stub).indexStub(stub, (IndexSink)sink);
        }
        Map<StubIndexKey, Map<Object, int[]>> map = sink.getResult();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/ObjectStubTree", "indexStubTree"));
        }
        return map;
    }

    private static void enumerateStubs(@NotNull Stub root, @NotNull List<Stub> result2) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/ObjectStubTree", "enumerateStubs"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/stubs/ObjectStubTree", "enumerateStubs"));
        }
        ((ObjectStubBase)root).id = result2.size();
        result2.add(root);
        List childrenStubs = root.getChildrenStubs();
        for (int i2 = 0; i2 < childrenStubs.size(); ++i2) {
            Stub child = (Stub)childrenStubs.get(i2);
            ObjectStubTree.enumerateStubs(child, result2);
        }
    }

    public void setDebugInfo(String info) {
        ObjectStubTree ref = ObjectStubTree.getStubTree(this.myRoot);
        if (ref != null) {
            assert (ref == this);
            info = info + "; with backReference";
        }
        this.myDebugInfo = info;
    }

    static ObjectStubTree getStubTree(ObjectStubBase root) {
        return (ObjectStubTree)root.getUserData(STUB_TO_TREE_REFERENCE);
    }

    public String getDebugInfo() {
        return this.myDebugInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDebugInfo='" + this.myDebugInfo + '\'' + ", myRoot=" + this.myRoot + '}' + this.hashCode();
    }

    private static class StubIndexSink
    implements IndexSink,
    TObjectProcedure<Map<Object, int[]>>,
    TObjectObjectProcedure<Object, int[]> {
        private final THashMap<StubIndexKey, Map<Object, int[]>> myResult = new THashMap();
        private int myStubIdx;
        private Map<Object, int[]> myProcessingMap;

        private StubIndexSink() {
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value) {
            int[] list;
            if (indexKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink", "occurrence"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink", "occurrence"));
            }
            Map map = (Map)this.myResult.get((Object)indexKey);
            if (map == null) {
                map = new THashMap();
                this.myResult.put((Object)indexKey, (Object)map);
            }
            if ((list = (int[])map.get(value)) == null) {
                map.put(value, new int[]{this.myStubIdx});
            } else {
                int lastZero;
                for (lastZero = list.length - 1; lastZero >= 0 && list[lastZero] == 0; --lastZero) {
                }
                if (lastZero >= 0 && list[lastZero] == this.myStubIdx) {
                    return;
                }
                if (++lastZero == list.length) {
                    int[] newlist = new int[Math.max(4, list.length << 1)];
                    System.arraycopy(list, 0, newlist, 0, list.length);
                    lastZero = list.length;
                    list = newlist;
                    map.put(value, newlist);
                }
                list[lastZero] = this.myStubIdx;
            }
        }

        public Map<StubIndexKey, Map<Object, int[]>> getResult() {
            this.myResult.forEachValue((TObjectProcedure)this);
            return this.myResult;
        }

        public boolean execute(Map<Object, int[]> object) {
            this.myProcessingMap = object;
            ((THashMap)object).forEachEntry((TObjectObjectProcedure)this);
            return true;
        }

        public boolean execute(Object a, int[] b) {
            int firstZero;
            if (b.length == 1) {
                return true;
            }
            for (firstZero = 0; firstZero < b.length && b[firstZero] != 0; ++firstZero) {
            }
            if (firstZero != b.length) {
                int[] shorterList = new int[firstZero];
                System.arraycopy(b, 0, shorterList, 0, shorterList.length);
                this.myProcessingMap.put(a, shorterList);
            }
            return true;
        }
    }
}

