/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.google.common.base.MoreObjects;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileStubImpl<T extends PsiFile>
extends StubBase<T>
implements PsiFileStub<T> {
    public static final IStubFileElementType TYPE = new IStubFileElementType(Language.ANY);
    private volatile T myFile;
    private volatile String myInvalidationReason;
    private volatile PsiFileStub[] myStubRoots;

    public PsiFileStubImpl(T file2) {
        super(null, null);
        this.myFile = file2;
    }

    public T getPsi() {
        return this.myFile;
    }

    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/stubs/PsiFileStubImpl", "setPsi"));
        }
        this.myFile = psi;
    }

    public void clearPsi(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/stubs/PsiFileStubImpl", "clearPsi"));
        }
        this.myInvalidationReason = reason;
        this.myFile = null;
    }

    @Nullable
    public String getInvalidationReason() {
        return this.myInvalidationReason;
    }

    public IStubElementType getStubType() {
        return null;
    }

    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = TYPE;
        if (iStubFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getType"));
        }
        return iStubFileElementType;
    }

    @NotNull
    public PsiFileStub[] getStubRoots() {
        if (this.myStubRoots != null) {
            if (this.myStubRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return this.myStubRoots;
        }
        T psi = this.getPsi();
        if (psi == null) {
            PsiFileStub[] psiFileStubArray = new PsiFileStub[]{this};
            if (psiFileStubArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return psiFileStubArray;
        }
        FileViewProvider viewProvider = psi.getViewProvider();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        StubTree baseTree = PsiFileStubImpl.getOrCalcStubTree(stubBindingRoot);
        if (baseTree != null) {
            PsiFileStub[] rootsArray;
            SmartList roots = new SmartList((Object)baseTree.getRoot());
            List<Pair<IStubFileElementType, PsiFile>> stubbedRoots = StubTreeBuilder.getStubbedRoots(viewProvider);
            for (Pair<IStubFileElementType, PsiFile> stubbedRoot : stubbedRoots) {
                StubTree secondaryStubTree;
                if (stubbedRoot.second == stubBindingRoot || (secondaryStubTree = PsiFileStubImpl.getOrCalcStubTree((PsiFile)stubbedRoot.second)) == null) continue;
                PsiFileStub root = secondaryStubTree.getRoot();
                roots.add(root);
            }
            for (PsiFileStub root : rootsArray = roots.toArray(new PsiFileStub[roots.size()])) {
                if (!(root instanceof PsiFileStubImpl)) continue;
                ((PsiFileStubImpl)root).setStubRoots(rootsArray);
            }
            this.myStubRoots = rootsArray;
            if (rootsArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
            }
            return rootsArray;
        }
        if (PsiFileStub.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/PsiFileStubImpl", "getStubRoots"));
        }
        return PsiFileStub.EMPTY_ARRAY;
    }

    private static StubTree getOrCalcStubTree(PsiFile stubBindingRoot) {
        StubTree result2 = null;
        if (stubBindingRoot instanceof PsiFileWithStubSupport && (result2 = ((PsiFileWithStubSupport)stubBindingRoot).getStubTree()) == null && stubBindingRoot instanceof PsiFileImpl) {
            result2 = ((PsiFileImpl)stubBindingRoot).calcStubTree();
        }
        return result2;
    }

    public void setStubRoots(@NotNull PsiFileStub[] roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/psi/stubs/PsiFileStubImpl", "setStubRoots"));
        }
        if (roots.length == 0) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error("Incorrect psi file stub roots count" + (Object)((Object)this) + "," + this.getStubType());
        }
        this.myStubRoots = roots;
    }

    public boolean rootsAreSet() {
        return this.myStubRoots != null;
    }

    public String getDiagnostics() {
        ObjectStubTree stubTree = ObjectStubTree.getStubTree((ObjectStubBase)this);
        T file2 = this.myFile;
        Integer lastStubTreeHash = file2 == null ? null : (Integer)file2.getUserData(ObjectStubTree.LAST_STUB_TREE_HASH);
        return this.toString() + MoreObjects.toStringHelper((String)"").add("myFile", file2).add("myInvalidationReason", (Object)this.myInvalidationReason).add("myStubRoots", (Object)Arrays.toString(this.myStubRoots)).add("stubTree", (Object)stubTree).add("lastStubTreeHash", (Object)lastStubTreeHash).toString();
    }
}

