/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubsHierarchy.StubHierarchyIndexer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStubIndexer
extends StubHierarchyIndexer {
    @Override
    public int getVersion() {
        return 39;
    }

    @Override
    public boolean handlesFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubsHierarchy/impl/JavaStubIndexer", "handlesFile"));
        }
        FileType fileType = file2.getFileType();
        return fileType == JavaFileType.INSTANCE || fileType == JavaClassFileType.INSTANCE && JavaStubIndexer.hasDefaultStubBuilder(file2);
    }

    private static boolean hasDefaultStubBuilder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubsHierarchy/impl/JavaStubIndexer", "hasDefaultStubBuilder"));
        }
        return !(ClassFileDecompilers.find((VirtualFile)file2) instanceof ClassFileDecompilers.Full);
    }

    @Override
    @Nullable
    public IndexTree.Unit indexFile(@NotNull FileContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/stubsHierarchy/impl/JavaStubIndexer", "indexFile"));
        }
        Stub stubTree = StubTreeBuilder.buildStubTree(content);
        if (!(stubTree instanceof PsiJavaFileStub)) {
            return null;
        }
        PsiJavaFileStub javaFileStub = (PsiJavaFileStub)stubTree;
        new StubTree((PsiFileStub)javaFileStub, false);
        ArrayList<IndexTree.ClassDecl> classList = new ArrayList<IndexTree.ClassDecl>();
        HashSet<String> usedNames = new HashSet<String>();
        for (Object el : javaFileStub.getChildrenStubs()) {
            IndexTree.ClassDecl classDecl;
            if (!(el instanceof PsiClassStubImpl) || (classDecl = JavaStubIndexer.processClassDecl((PsiClassStubImpl)el, usedNames)) == null) continue;
            classList.add(classDecl);
        }
        ArrayList<IndexTree.Import> importList = new ArrayList<IndexTree.Import>();
        for (StubElement el : javaFileStub.getChildrenStubs()) {
            if (!(el instanceof PsiImportListStub)) continue;
            JavaStubIndexer.processImport((PsiImportListStub)el, importList, usedNames);
        }
        IndexTree.ClassDecl[] classes = classList.isEmpty() ? IndexTree.ClassDecl.EMPTY_ARRAY : classList.toArray(new IndexTree.ClassDecl[classList.size()]);
        IndexTree.Import[] imports = importList.isEmpty() ? IndexTree.Import.EMPTY_ARRAY : importList.toArray(new IndexTree.Import[importList.size()]);
        byte type = javaFileStub.isCompiled() ? (byte)0 : 1;
        return new IndexTree.Unit(javaFileStub.getPackageName(), type, imports, classes);
    }

    @Nullable
    private static IndexTree.Decl processMember(StubElement<?> el, Set<String> namesCache) {
        if (el instanceof PsiClassStubImpl) {
            return JavaStubIndexer.processClassDecl((PsiClassStubImpl)el, namesCache);
        }
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        for (StubElement childElement : el.getChildrenStubs()) {
            IndexTree.Decl innerDef = JavaStubIndexer.processMember(childElement, namesCache);
            if (innerDef == null) continue;
            innerList.add(innerDef);
        }
        return innerList.isEmpty() ? null : new IndexTree.MemberDecl(innerList.toArray(new IndexTree.Decl[innerList.size()]));
    }

    @Nullable
    private static IndexTree.ClassDecl processClassDecl(PsiClassStubImpl<?> classStub, Set<String> namesCache) {
        ArrayList<String> superList = new ArrayList<String>();
        ArrayList<IndexTree.Decl> innerList = new ArrayList<IndexTree.Decl>();
        int accessModifiers = 0;
        if (classStub.isAnonymous() && classStub.getBaseClassReferenceText() != null) {
            superList.add(JavaStubIndexer.id(classStub.getBaseClassReferenceText(), true, namesCache));
        }
        for (StubElement el : classStub.getChildrenStubs()) {
            IndexTree.Decl member;
            if (el instanceof PsiClassReferenceListStub) {
                PsiClassReferenceListStub refList = (PsiClassReferenceListStub)el;
                if (refList.getRole() == PsiReferenceList.Role.EXTENDS_LIST) {
                    String[] extendNames;
                    for (String extName : extendNames = refList.getReferencedNames()) {
                        superList.add(JavaStubIndexer.id(extName, true, namesCache));
                    }
                }
                if (refList.getRole() == PsiReferenceList.Role.IMPLEMENTS_LIST) {
                    String[] implementNames;
                    for (String impName : implementNames = refList.getReferencedNames()) {
                        superList.add(JavaStubIndexer.id(impName, true, namesCache));
                    }
                }
            }
            if (el instanceof PsiModifierListStub) {
                accessModifiers = ((PsiModifierListStub)el).getModifiersMask();
            }
            if ((member = JavaStubIndexer.processMember(el, namesCache)) == null) continue;
            innerList.add(member);
        }
        int flags = JavaStubIndexer.translateFlags(classStub);
        if (classStub.isAnonymousInQualifiedNew()) {
            flags |= 0x200;
        }
        String[] supers = superList.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(superList);
        IndexTree.Decl[] inners = innerList.isEmpty() ? IndexTree.Decl.EMPTY_ARRAY : innerList.toArray(new IndexTree.Decl[innerList.size()]);
        return new IndexTree.ClassDecl(classStub.id, flags, classStub.getName(), supers, inners);
    }

    private static int translateFlags(PsiClassStubImpl<?> classStub) {
        int flags = 0;
        flags = BitUtil.set((int)flags, (int)64, (boolean)classStub.isEnum());
        flags = BitUtil.set((int)flags, (int)32, (boolean)classStub.isAnnotationType());
        return flags;
    }

    private static void processImport(PsiImportListStub el, List<IndexTree.Import> imports, Set<String> namesCache) {
        for (StubElement importElem : el.getChildrenStubs()) {
            PsiImportStatementStub imp = (PsiImportStatementStub)importElem;
            String importReferenceText = imp.getImportReferenceText();
            if (importReferenceText == null) continue;
            String fullName = PsiNameHelper.getQualifiedClassName((String)importReferenceText, (boolean)true);
            if (!imp.isOnDemand() && !namesCache.contains(JavaStubIndexer.shortName(fullName))) continue;
            imports.add(new IndexTree.Import(fullName, imp.isStatic(), imp.isOnDemand(), null));
        }
    }

    private static String id(String s, boolean cacheFirstId, Set<String> namesCache) {
        String id = PsiNameHelper.getQualifiedClassName((String)s, (boolean)true);
        if (cacheFirstId) {
            int index = id.indexOf(46);
            String firstId = index > 0 ? s.substring(0, index) : id;
            namesCache.add(firstId);
        }
        return id;
    }

    private static String shortName(String s) {
        int dotIndex = s.lastIndexOf(46);
        return dotIndex > 0 ? s.substring(dotIndex + 1) : null;
    }
}

