/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public abstract class JavaExtractSuperBaseDialog
extends ExtractSuperBaseDialog<PsiClass, MemberInfo> {
    private static final String DESTINATION_PACKAGE_RECENT_KEY = "ExtractSuperBase.RECENT_KEYS";
    protected final DestinationFolderComboBox myDestinationFolderComboBox = new DestinationFolderComboBox(){

        @Override
        public String getTargetPackage() {
            return JavaExtractSuperBaseDialog.this.getTargetPackageName();
        }
    };

    public JavaExtractSuperBaseDialog(Project project2, PsiClass sourceClass, List<MemberInfo> members, String refactoringName) {
        super(project2, sourceClass, members, refactoringName);
    }

    @Override
    protected ComponentWithBrowseButton<EditorComboBox> createPackageNameField() {
        String name = "";
        PsiFile file2 = ((PsiClass)this.mySourceClass).getContainingFile();
        if (file2 instanceof PsiJavaFile) {
            name = ((PsiJavaFile)file2).getPackageName();
        }
        return new PackageNameReferenceEditorCombo(name, this.myProject, DESTINATION_PACKAGE_RECENT_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    @Override
    protected JPanel createDestinationRootPanel() {
        List<VirtualFile> sourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject);
        if (sourceRoots.size() <= 1) {
            return super.createDestinationRootPanel();
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JBLabel label = new JBLabel(RefactoringBundle.message((String)"target.destination.folder"));
        panel2.add((Component)label, "North");
        label.setLabelFor((Component)((Object)this.myDestinationFolderComboBox));
        this.myDestinationFolderComboBox.setData(this.myProject, this.myTargetDirectory, new Pass<String>(){

            public void pass(String s) {
            }
        }, (EditorComboBox)((PackageNameReferenceEditorCombo)this.myPackageNameField).getChildComponent());
        panel2.add((Component)((Object)this.myDestinationFolderComboBox), "Center");
        return panel2;
    }

    @Override
    protected String getTargetPackageName() {
        return ((PackageNameReferenceEditorCombo)this.myPackageNameField).getText().trim();
    }

    @Override
    protected JTextField createSourceClassField() {
        JTextField result2 = new JTextField();
        result2.setEditable(false);
        String qualifiedName = ((PsiClass)this.mySourceClass).getQualifiedName();
        result2.setText(qualifiedName != null ? qualifiedName : SymbolPresentationUtil.getSymbolPresentableText(this.mySourceClass));
        return result2;
    }

    @Override
    protected JTextField createExtractedSuperNameField() {
        JTextField superNameField = super.createExtractedSuperNameField();
        superNameField.setText(((PsiClass)this.mySourceClass).getName());
        superNameField.selectAll();
        return superNameField;
    }

    private PsiDirectory getDirUnderSameSourceRoot(PsiDirectory[] directories) {
        ProjectFileIndex fileIndex;
        VirtualFile sourceRoot;
        VirtualFile sourceFile = ((PsiClass)this.mySourceClass).getContainingFile().getVirtualFile();
        if (sourceFile != null && (sourceRoot = (fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()).getSourceRootForFile(sourceFile)) != null) {
            for (PsiDirectory dir : directories) {
                if (!Comparing.equal((Object)fileIndex.getSourceRootForFile(dir.getVirtualFile()), (Object)sourceRoot)) continue;
                return dir;
            }
        }
        return directories[0];
    }

    @Override
    protected boolean isPossibleToRenameOriginal() {
        return ((PsiClass)this.mySourceClass).getNameIdentifier() != null;
    }

    @Override
    protected void preparePackage() throws ExtractSuperBaseDialog.OperationFailedException {
        MoveDestination moveDestination;
        PsiDirectory[] directories;
        boolean fromDefaultPackage;
        String targetPackageName = this.getTargetPackageName();
        PsiFile containingFile = ((PsiClass)this.mySourceClass).getContainingFile();
        boolean bl = fromDefaultPackage = containingFile instanceof PsiClassOwner && ((PsiClassOwner)containingFile).getPackageName().isEmpty();
        if (!(fromDefaultPackage && StringUtil.isEmpty((String)targetPackageName) || PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(targetPackageName))) {
            throw new ExtractSuperBaseDialog.OperationFailedException("Invalid package name: " + targetPackageName);
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(targetPackageName);
        if (aPackage != null && (directories = aPackage.getDirectories(((PsiClass)this.mySourceClass).getResolveScope())).length >= 1) {
            this.myTargetDirectory = this.getDirUnderSameSourceRoot(directories);
        }
        if ((moveDestination = this.myDestinationFolderComboBox.selectDirectory(new PackageWrapper(PsiManager.getInstance((Project)this.myProject), targetPackageName), false)) == null) {
            return;
        }
        PsiDirectory psiDirectory = this.myTargetDirectory = this.myTargetDirectory != null ? (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

            public PsiDirectory compute() {
                return moveDestination.getTargetDirectory(JavaExtractSuperBaseDialog.this.myTargetDirectory);
            }
        }) : null;
        if (this.myTargetDirectory == null) {
            throw new ExtractSuperBaseDialog.OperationFailedException("");
        }
        String error = RefactoringMessageUtil.checkCanCreateClass(this.myTargetDirectory, this.getExtractedSuperName());
        if (error != null) {
            throw new ExtractSuperBaseDialog.OperationFailedException(error);
        }
    }

    @Override
    protected String getDestinationPackageRecentKey() {
        return DESTINATION_PACKAGE_RECENT_KEY;
    }

    @Override
    @Nullable
    protected String validateName(String name) {
        return PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name) ? (name.equals(((PsiClass)this.mySourceClass).getName()) ? "Different name expected" : null) : RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
    }
}

