/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.inline.InlineOptions;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RadioUpDownListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public abstract class InlineOptionsDialog
extends RefactoringDialog
implements InlineOptions {
    protected JRadioButton myRbInlineAll;
    protected JRadioButton myRbInlineThisOnly;
    protected boolean myInvokedOnReference;
    protected final PsiElement myElement;
    private final JLabel myNameLabel = new JLabel();

    protected InlineOptionsDialog(Project project2, boolean canBeParent, PsiElement element) {
        super(project2, canBeParent);
        this.myElement = element;
    }

    protected JComponent createNorthPanel() {
        this.myNameLabel.setText(this.getNameLabelText());
        return this.myNameLabel;
    }

    @Override
    public boolean isInlineThisOnly() {
        return this.myRbInlineThisOnly.isSelected();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        this.myRbInlineAll = new JRadioButton();
        this.myRbInlineAll.setText(this.getInlineAllText());
        this.myRbInlineAll.setSelected(true);
        this.myRbInlineThisOnly = new JRadioButton();
        this.myRbInlineThisOnly.setText(this.getInlineThisText());
        optionsPanel.add(this.myRbInlineAll);
        optionsPanel.add(this.myRbInlineThisOnly);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myRbInlineAll);
        bg.add(this.myRbInlineThisOnly);
        new RadioUpDownListener(this.myRbInlineAll, this.myRbInlineThisOnly);
        this.myRbInlineThisOnly.setEnabled(this.myInvokedOnReference);
        boolean writable = this.allowInlineAll();
        this.myRbInlineAll.setEnabled(writable);
        if (this.myInvokedOnReference) {
            if (this.canInlineThisOnly()) {
                this.myRbInlineAll.setSelected(false);
                this.myRbInlineAll.setEnabled(false);
                this.myRbInlineThisOnly.setSelected(true);
            } else if (writable) {
                boolean inlineThis = this.isInlineThis();
                this.myRbInlineThisOnly.setSelected(inlineThis);
                this.myRbInlineAll.setSelected(!inlineThis);
            } else {
                this.myRbInlineAll.setSelected(false);
                this.myRbInlineThisOnly.setSelected(true);
            }
        } else {
            this.myRbInlineAll.setSelected(true);
            this.myRbInlineThisOnly.setSelected(false);
        }
        this.getPreviewAction().setEnabled(this.myRbInlineAll.isSelected());
        this.myRbInlineAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = InlineOptionsDialog.this.myRbInlineAll.isSelected();
                InlineOptionsDialog.this.getPreviewAction().setEnabled(enabled);
            }
        });
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineOptionsDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    protected boolean allowInlineAll() {
        return this.myElement.isWritable();
    }

    protected abstract String getNameLabelText();

    protected abstract String getBorderTitle();

    protected abstract String getInlineAllText();

    protected abstract String getInlineThisText();

    protected abstract boolean isInlineThis();

    protected boolean canInlineThisOnly() {
        return false;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRbInlineThisOnly.isSelected() ? this.myRbInlineThisOnly : this.myRbInlineAll;
    }

    protected static int initOccurrencesNumber(PsiNameIdentifierOwner nameIdentifierOwner) {
        ProgressManager progressManager = ProgressManager.getInstance();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)nameIdentifierOwner.getProject());
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)nameIdentifierOwner.getProject());
        String name = nameIdentifierOwner.getName();
        boolean isCheapToSearch = name != null && searchHelper.isCheapEnoughToSearch(name, scope, null, progressManager.getProgressIndicator()) != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        return isCheapToSearch ? ReferencesSearch.search((PsiElement)nameIdentifierOwner, (SearchScope)scope).findAll().size() : -1;
    }
}

