/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JavaModuleRenameValidator
implements RenameInputValidator {
    private final ElementPattern<? extends PsiElement> myPattern = PlatformPatterns.psiElement(PsiJavaModule.class);

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern<? extends PsiElement> elementPattern = this.myPattern;
        if (elementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/JavaModuleRenameValidator", "getPattern"));
        }
        return elementPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/JavaModuleRenameValidator", "isInputValid"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/JavaModuleRenameValidator", "isInputValid"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/rename/JavaModuleRenameValidator", "isInputValid"));
        }
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)element.getProject());
        if (StringUtil.isEmptyOrSpaces((String)newName)) return true;
        if (!StringUtil.split((String)newName, (String)".").stream().allMatch(arg_0 -> ((PsiNameHelper)helper).isIdentifier(arg_0))) return false;
        return true;
    }
}

