/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GuavaTypeConversionDescriptor
extends TypeConversionDescriptor {
    private static final Logger LOG = Logger.getInstance(GuavaTypeConversionDescriptor.class);
    private final String myReplaceByStringSource;
    private boolean myConvertParameterAsLambda = true;

    GuavaTypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        super(stringToReplace, replaceByString);
        this.myReplaceByStringSource = replaceByString;
    }

    public GuavaTypeConversionDescriptor setConvertParameterAsLambda(boolean convertParameterAsLambda) {
        this.myConvertParameterAsLambda = convertParameterAsLambda;
        return this;
    }

    @Override
    public PsiExpression replace(PsiExpression expression, TypeEvaluator evaluator) throws IncorrectOperationException {
        this.setReplaceByString(this.myReplaceByStringSource + (GuavaTypeConversionDescriptor.isIterable(expression) ? ".collect(java.util.stream.Collectors.toList())" : ""));
        if (this.myConvertParameterAsLambda) {
            LOG.assertTrue(expression instanceof PsiMethodCallExpression);
            PsiExpression[] arguments = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions();
            if (arguments.length == 1) {
                GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], false, null, evaluator);
            }
        }
        return super.replace(expression, evaluator);
    }

    public static boolean isIterable(PsiExpression expression) {
        int index;
        Object[] arguments;
        PsiParameter[] parameters;
        PsiMethod method2;
        PsiExpressionList expressionList;
        PsiElement maybeMethodCallExpr;
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiLocalVariable) {
            return GuavaTypeConversionDescriptor.isIterable(((PsiLocalVariable)parent).getType());
        }
        if (parent instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = ((PsiMethod)methodOrLambda).getReturnType();
            } else if (methodOrLambda instanceof PsiLambdaExpression) {
                methodReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)methodOrLambda));
            }
            return GuavaTypeConversionDescriptor.isIterable(methodReturnType);
        }
        if (parent instanceof PsiExpressionList && (maybeMethodCallExpr = (expressionList = (PsiExpressionList)parent).getParent()) instanceof PsiMethodCallExpression && (method2 = ((PsiMethodCallExpression)maybeMethodCallExpr).resolveMethod()) != null && (parameters = method2.getParameterList().getParameters()).length == (arguments = expressionList.getExpressions()).length && (index = ArrayUtil.indexOf((Object[])arguments, (Object)expression)) != -1) {
            return GuavaTypeConversionDescriptor.isIterable(parameters[index].getType());
        }
        return false;
    }

    private static boolean isIterable(@Nullable PsiType type) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return aClass != null && "java.lang.Iterable".equals(aClass.getQualifiedName());
    }
}

