/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MatcherImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.MatcherImpl");
    private final Project project;
    private final DumbService myDumbService;
    private final MatchContext matchContext;
    private boolean isTesting;
    private final GlobalMatchingVisitor visitor = new GlobalMatchingVisitor();
    private ProgressIndicator progress;
    private final TaskScheduler scheduler = new TaskScheduler();
    private int totalFilesToScan;
    private int scannedFilesCount;
    private static java.lang.ref.SoftReference<LastMatchData> lastMatchData;
    private static final Object lastMatchDataLock;

    public MatcherImpl(Project project2, MatchOptions matchOptions) {
        this.project = project2;
        this.matchContext = new MatchContext();
        this.matchContext.setMatcher(this.visitor);
        if (matchOptions != null) {
            this.matchContext.setOptions(matchOptions);
            this.cacheCompiledPattern(matchOptions, PatternCompiler.compilePattern(project2, matchOptions));
        }
        this.myDumbService = DumbService.getInstance((Project)project2);
    }

    protected MatcherImpl(Project project2) {
        this(project2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(Project project2, MatchOptions options) {
        Object object = lastMatchDataLock;
        synchronized (object) {
            LastMatchData data = new LastMatchData();
            data.lastPattern = PatternCompiler.compilePattern(project2, options);
            data.lastOptions = options;
            lastMatchData = new java.lang.ref.SoftReference<LastMatchData>(data);
        }
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
        assert (profile != null);
        profile.checkSearchPattern(project2, options);
    }

    public static boolean checkIfShouldAttemptToMatch(MatchContext context, NodeIterator matchedNodes) {
        CompiledPattern pattern = context.getPattern();
        NodeIterator patternNodes = pattern.getNodes();
        try {
            while (true) {
                PsiElement patternNode;
                if ((patternNode = patternNodes.current()) == null) {
                    boolean bl = true;
                    return bl;
                }
                PsiElement matchedNode = matchedNodes.current();
                if (matchedNode == null) {
                    boolean bl = false;
                    return bl;
                }
                MatchingHandler matchingHandler = pattern.getHandler(patternNode);
                if (matchingHandler == null || !matchingHandler.canMatch(patternNode, matchedNode, context)) {
                    boolean bl = false;
                    return bl;
                }
                matchedNodes.advance();
                patternNodes.advance();
            }
        }
        finally {
            patternNodes.reset();
            matchedNodes.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMatchesInElement(MatchContext context, Configuration configuration, NodeIterator matchedNodes, PairProcessor<MatchResult, Configuration> processor2) {
        try {
            this.configureOptions(context, configuration, matchedNodes.current(), processor2);
            context.setShouldRecursivelyMatch(false);
            this.visitor.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
            context.getOptions().setScope(null);
        }
    }

    public void clearContext() {
        this.matchContext.clear();
    }

    private void configureOptions(MatchContext context, final Configuration configuration, PsiElement psiFile, final PairProcessor<MatchResult, Configuration> processor2) {
        if (psiFile == null) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope(psiFile);
        this.matchContext.clear();
        this.matchContext.setMatcher(this.visitor);
        MatchOptions options = context.getOptions();
        this.matchContext.setOptions(options);
        this.matchContext.setPattern(context.getPattern());
        this.matchContext.setShouldRecursivelyMatch(context.shouldRecursivelyMatch());
        this.visitor.setMatchContext(this.matchContext);
        this.matchContext.setSink(new DuplicateFilteringResultSink(new DefaultMatchResultSink(){

            @Override
            public void newMatch(MatchResult result2) {
                processor2.process((Object)result2, (Object)configuration);
            }
        }));
        options.setScope((SearchScope)scope);
    }

    public void precompileOptions(List<Configuration> configurations, Map<Configuration, MatchContext> out) {
        for (Configuration configuration : configurations) {
            if (out.containsKey(configuration)) continue;
            MatchContext matchContext = new MatchContext();
            matchContext.setMatcher(this.visitor);
            MatchOptions matchOptions = configuration.getMatchOptions();
            matchContext.setOptions(matchOptions);
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.project, matchOptions);
                    matchContext.setPattern(compiledPattern);
                    out.put(configuration, matchContext);
                }
                catch (UnsupportedPatternException unsupportedPatternException) {
                }
                catch (MalformedPatternException malformedPatternException) {
                    // empty catch block
                }
            });
        }
    }

    protected void findMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        if (compiledPattern == null) {
            return;
        }
        this.matchContext.getSink().setMatchingProcess(this.scheduler);
        this.scheduler.init();
        this.progress = this.matchContext.getSink().getProgressIndicator();
        if (this.isTesting) {
            PsiElement[] elements = ((LocalSearchScope)options.getScope()).getScope();
            PsiElement parent = elements[0].getParent();
            if (elements.length > 0 && this.matchContext.getPattern().getStrategy().continueMatching(parent != null ? parent : elements[0])) {
                this.visitor.matchContext(new SsrFilteringNodeIterator(new ArrayBackedNodeIterator(elements)));
            } else {
                LanguageFileType fileType = (LanguageFileType)this.matchContext.getOptions().getFileType();
                Language language = fileType.getLanguage();
                for (PsiElement element : elements) {
                    this.match(element, language);
                }
            }
            this.matchContext.getSink().matchingFinished();
            return;
        }
        if (!this.findMatches(options, compiledPattern)) {
            return;
        }
        if (this.scheduler.getTaskQueueEndAction() == null) {
            this.scheduler.setTaskQueueEndAction(() -> this.matchContext.getSink().matchingFinished());
        }
        this.scheduler.executeNext();
    }

    private boolean findMatches(MatchOptions options, CompiledPattern compiledPattern) {
        boolean ourOptimizedScope;
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl = ourOptimizedScope = searchScope != null;
        if (!ourOptimizedScope) {
            searchScope = options.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            final GlobalSearchScope scope = (GlobalSearchScope)searchScope;
            ContentIterator ci = new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory() && scope.contains(fileOrDir) && fileOrDir.getFileType() != FileTypes.UNKNOWN) {
                        ++MatcherImpl.this.totalFilesToScan;
                        MatcherImpl.this.scheduler.addOneTask(new MatchOneVirtualFile(fileOrDir));
                    }
                    return true;
                }
            };
            ApplicationManager.getApplication().runReadAction(() -> FileBasedIndex.getInstance().iterateIndexableFiles(ci, this.project, this.progress));
            this.progress.setText2("");
        } else {
            PsiElement[] elementsToScan = ((LocalSearchScope)searchScope).getScope();
            this.totalFilesToScan = elementsToScan.length;
            for (int i2 = 0; i2 < elementsToScan.length; ++i2) {
                PsiElement psiElement = elementsToScan[i2];
                if (psiElement == null) continue;
                this.scheduler.addOneTask(new MatchOnePsiFile(psiElement));
                if (!ourOptimizedScope) continue;
                elementsToScan[i2] = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledPattern prepareMatching(MatchResultSink sink, final MatchOptions options) {
        CompiledPattern savedPattern = null;
        if (this.matchContext.getOptions() == options && this.matchContext.getPattern() != null && this.matchContext.getOptions().hashCode() == this.matchContext.getPattern().getOptionsHashStamp()) {
            savedPattern = this.matchContext.getPattern();
        }
        this.matchContext.clear();
        this.matchContext.setSink(new DuplicateFilteringResultSink(sink));
        this.matchContext.setOptions(options);
        this.matchContext.setMatcher(this.visitor);
        this.visitor.setMatchContext(this.matchContext);
        CompiledPattern compiledPattern = savedPattern;
        if (compiledPattern == null) {
            Object object = lastMatchDataLock;
            synchronized (object) {
                LastMatchData data = (LastMatchData)SoftReference.dereference(lastMatchData);
                if (data != null && options == data.lastOptions) {
                    compiledPattern = data.lastPattern;
                }
                lastMatchData = null;
            }
            if (compiledPattern == null) {
                compiledPattern = (CompiledPattern)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompiledPattern>(){

                    public CompiledPattern compute() {
                        return PatternCompiler.compilePattern(MatcherImpl.this.project, options);
                    }
                });
            }
        }
        this.cacheCompiledPattern(options, compiledPattern);
        return compiledPattern;
    }

    private void cacheCompiledPattern(MatchOptions options, CompiledPattern compiledPattern) {
        this.matchContext.setPattern(compiledPattern);
        compiledPattern.setOptionsHashStamp(options.hashCode());
    }

    protected void testFindMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        this.isTesting = true;
        try {
            this.findMatches(sink, options);
        }
        finally {
            this.isTesting = false;
        }
    }

    protected List<MatchResult> testFindMatches(String source, String pattern, MatchOptions options, boolean filePattern, FileType sourceFileType, String sourceExtension, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            PsiElement[] elements = MatcherImplUtil.createSourceTreeFromText(source, filePattern ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceExtension, this.project, physicalSourceFile);
            options.setSearchPattern(pattern);
            options.setScope((SearchScope)new LocalSearchScope(elements));
            this.testFindMatches(sink, options);
        }
        catch (IncorrectOperationException e) {
            MalformedPatternException exception = new MalformedPatternException();
            exception.initCause(e);
            throw exception;
        }
        finally {
            options.setScope(null);
        }
        return sink.getMatches();
    }

    protected List<MatchResult> testFindMatches(String source, String pattern, MatchOptions options, boolean filePattern) {
        return this.testFindMatches(source, pattern, options, filePattern, options.getFileType(), null, false);
    }

    void match(PsiElement element, final Language language) {
        MatchingStrategy strategy = this.matchContext.getPattern().getStrategy();
        Language elementLanguage = element.getLanguage();
        if (strategy.continueMatching(element) && elementLanguage.isKindOf(language)) {
            this.visitor.matchContext(new ArrayBackedNodeIterator(new PsiElement[]{element}));
            return;
        }
        for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
            this.match(el, language);
        }
        if (element instanceof PsiLanguageInjectionHost) {
            InjectedLanguageUtil.enumerate(element, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$4", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$4", "visit"));
                    }
                    MatcherImpl.this.match((PsiElement)injectedPsi, language);
                }
            });
        }
    }

    @NotNull
    protected List<MatchResult> matchByDownUp(PsiElement element, MatchOptions options) {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        this.matchContext.setShouldRecursivelyMatch(false);
        PsiElement targetNode = compiledPattern.getTargetNode();
        PsiElement elementToStartMatching = null;
        if (targetNode == null) {
            targetNode = compiledPattern.getNodes().current();
            if (targetNode != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                element = element.getParent();
                if (element == null) {
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl", "matchByDownUp"));
                    }
                    return list;
                }
                while (element.getClass() != targetNode.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl", "matchByDownUp"));
                    }
                    return list;
                }
                elementToStartMatching = element;
            }
        } else {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile == null) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl", "matchByDownUp"));
                }
                return list;
            }
            targetNode = profile.extendMatchedByDownUp(targetNode);
            MatchingHandler handler2 = null;
            while (element.getClass() == targetNode.getClass() || compiledPattern.isTypedVar(targetNode) && compiledPattern.getHandler(targetNode).canMatch(targetNode, element, this.matchContext)) {
                handler2 = compiledPattern.getHandler(targetNode);
                handler2.setPinnedElement(element);
                elementToStartMatching = element;
                if (handler2 instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                targetNode = targetNode.getParent();
                if (!options.isLooseMatching()) continue;
                element = profile.updateCurrentNode(element);
                targetNode = profile.updateCurrentNode(targetNode);
            }
            if (!(handler2 instanceof TopLevelMatchingHandler)) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl", "matchByDownUp"));
                }
                return list;
            }
        }
        assert (targetNode != null) : "Could not match down up when no target node";
        LanguageFileType fileType = (LanguageFileType)this.matchContext.getOptions().getFileType();
        this.match(elementToStartMatching, fileType.getLanguage());
        this.matchContext.getSink().matchingFinished();
        List<MatchResult> list = sink.getMatches();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl", "matchByDownUp"));
        }
        return list;
    }

    static {
        lastMatchDataLock = new Object();
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile myFile;

        public MatchOneVirtualFile(VirtualFile file2) {
            this.myFile = file2;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiElement>>(){

                public List<PsiElement> compute() {
                    PsiFile file2 = PsiManager.getInstance((Project)MatcherImpl.this.project).findFile(MatchOneVirtualFile.this.myFile);
                    if (file2 == null) {
                        return Collections.emptyList();
                    }
                    FileViewProvider viewProvider = file2.getViewProvider();
                    SmartList elementsToProcess = new SmartList();
                    for (Language lang : viewProvider.getLanguages()) {
                        elementsToProcess.add(viewProvider.getPsi(lang));
                    }
                    return elementsToProcess;
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$MatchOneVirtualFile", "getPsiElementsToProcess"));
            }
            return list;
        }
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            List<PsiElement> files = this.getPsiElementsToProcess();
            if (MatcherImpl.this.progress != null) {
                MatcherImpl.this.progress.setFraction((double)MatcherImpl.this.scannedFilesCount / (double)MatcherImpl.this.totalFilesToScan);
            }
            ++MatcherImpl.this.scannedFilesCount;
            if (files.size() == 0) {
                return;
            }
            LanguageFileType fileType = (LanguageFileType)MatcherImpl.this.matchContext.getOptions().getFileType();
            Language patternLanguage = fileType.getLanguage();
            for (PsiElement file2 : files) {
                if (file2 instanceof PsiFile) {
                    MatcherImpl.this.matchContext.getSink().processFile((PsiFile)file2);
                }
                MatcherImpl.this.myDumbService.runReadActionInSmartMode(() -> {
                    if (!file2.isValid()) {
                        return;
                    }
                    StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(file2.getLanguage());
                    if (profile == null) {
                        return;
                    }
                    MatcherImpl.this.match(profile.extendMatchOnePsiFile(file2), patternLanguage);
                });
            }
        }

        @NotNull
        protected abstract List<PsiElement> getPsiElementsToProcess();
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement file;

        MatchOnePsiFile(PsiElement file2) {
            this.file = file2;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement file2 = this.file;
            this.file = null;
            SmartList smartList = new SmartList((Object)file2);
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$MatchOnePsiFile", "getPsiElementsToProcess"));
            }
            return smartList;
        }
    }

    class TaskScheduler
    implements MatchingProcess {
        private ArrayList<Runnable> tasks = new ArrayList();
        private boolean ended;
        private Runnable taskQueueEndAction;
        private boolean suspended;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.ended = true;
        }

        @Override
        public void pause() {
            this.suspended = true;
        }

        @Override
        public void resume() {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
            this.executeNext();
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public boolean isEnded() {
            return this.ended;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.taskQueueEndAction = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.taskQueueEndAction;
        }

        void addOneTask(Runnable runnable2) {
            this.tasks.add(runnable2);
        }

        private void executeNext() {
            while (!this.suspended && !this.ended) {
                if (this.tasks.isEmpty()) {
                    this.ended = true;
                    break;
                }
                Runnable task = this.tasks.remove(this.tasks.size() - 1);
                try {
                    task.run();
                }
                catch (ProcessCanceledException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (StructuralSearchException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (Throwable th) {
                    LOG.error(th);
                }
            }
            if (this.ended) {
                this.clearSchedule();
            }
        }

        private void init() {
            this.ended = false;
            this.suspended = false;
            PsiManager.getInstance((Project)MatcherImpl.this.project).startBatchFilesProcessingMode();
        }

        private void clearSchedule() {
            if (this.tasks != null) {
                this.taskQueueEndAction.run();
                if (!MatcherImpl.this.project.isDisposed()) {
                    PsiManager.getInstance((Project)MatcherImpl.this.project).finishBatchFilesProcessingMode();
                }
                this.tasks = null;
            }
        }
    }

    static class LastMatchData {
        CompiledPattern lastPattern;
        MatchOptions lastOptions;

        LastMatchData() {
        }
    }
}

