/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();
    protected static final String TEST_MODULE_NAME = "light_idea_test_case";

    public void setUpProject(@NotNull Project project2, @NotNull SetupHandler handler2) throws Exception {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "setUpProject"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/testFramework/LightProjectDescriptor", "setUpProject"));
        }
        WriteAction.run(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "lambda$setUpProject$0"));
            }
            if (handler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/testFramework/LightProjectDescriptor", "lambda$setUpProject$0"));
            }
            Module module2 = this.createMainModule(project2);
            handler2.moduleCreated(module2);
            VirtualFile sourceRoot = this.createSourcesRoot(module2);
            if (sourceRoot != null) {
                handler2.sourceRootCreated(sourceRoot);
                this.createContentEntry(module2, sourceRoot);
            }
        });
    }

    @NotNull
    public Module createMainModule(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "createMainModule"));
        }
        Module module2 = this.createModule(project2, FileUtil.join((String[])new String[]{FileUtil.getTempDirectory(), "light_idea_test_case.iml"}));
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightProjectDescriptor", "createMainModule"));
        }
        return module2;
    }

    protected Module createModule(@NotNull Project project2, @NotNull String moduleFilePath) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "createModule"));
        }
        if (moduleFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFilePath", "com/intellij/testFramework/LightProjectDescriptor", "createModule"));
        }
        return (Module)WriteAction.compute(() -> {
            if (moduleFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFilePath", "com/intellij/testFramework/LightProjectDescriptor", "lambda$createModule$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "lambda$createModule$1"));
            }
            File imlFile = new File(moduleFilePath);
            if (imlFile.exists()) {
                FileUtil.delete((File)imlFile);
            }
            return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, this.getModuleType().getId());
        });
    }

    @NotNull
    public ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightProjectDescriptor", "getModuleType"));
        }
        return emptyModuleType;
    }

    @Nullable
    public VirtualFile createSourcesRoot(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "createSourcesRoot"));
        }
        return this.createSourceRoot(module2, "src");
    }

    protected VirtualFile createSourceRoot(final @NotNull Module module2, String srcPath) {
        VirtualFile srcRoot;
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "createSourceRoot"));
        }
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        try {
            srcRoot = dummyRoot.createChildDirectory((Object)this, srcPath);
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1", "isInSet"));
                }
                return file2.getFileSystem() == srcRoot.getFileSystem() && module2.getProject().isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1", "iterateIndexableFilesIn"));
                }
                if (iterator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/testFramework/LightProjectDescriptor$1", "iterateIndexableFilesIn"));
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file2) {
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$1$1", "visitFile"));
                        }
                        iterator.processFile(file2);
                        return true;
                    }
                });
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)module2.getProject(), () -> FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet));
        return srcRoot;
    }

    protected void createContentEntry(@NotNull Module module2, @NotNull VirtualFile srcRoot) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "createContentEntry"));
        }
        if (srcRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcRoot", "com/intellij/testFramework/LightProjectDescriptor", "createContentEntry"));
        }
        ModuleRootModificationUtil.updateModel((Module)module2, model -> {
            if (srcRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcRoot", "com/intellij/testFramework/LightProjectDescriptor", "lambda$createContentEntry$3"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "lambda$createContentEntry$3"));
            }
            Sdk sdk = this.getSdk();
            if (sdk != null) {
                model.setSdk(sdk);
            }
            ContentEntry contentEntry = model.addContentEntry(srcRoot);
            contentEntry.addSourceFolder(srcRoot, false);
            this.configureModule(module2, (ModifiableRootModel)model, contentEntry);
        });
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/testFramework/LightProjectDescriptor", "cleanSourceRoot"));
        }
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile(this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module2, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
    }

    public static interface SetupHandler {
        default public void moduleCreated(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor$SetupHandler", "moduleCreated"));
            }
        }

        default public void sourceRootCreated(@NotNull VirtualFile sourceRoot) {
            if (sourceRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/testFramework/LightProjectDescriptor$SetupHandler", "sourceRootCreated"));
            }
        }
    }
}

