/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestLogger;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private static final String LOG_DIR = "testlog";
    private static final long LOG_SIZE_LIMIT = 0x6400000L;
    private static final long LOG_SEEK_WINDOW = 102400L;
    private boolean myInitialized;
    private static final StringWriter STRING_WRITER = new StringWriter();
    private static final StringBuffer BUFFER = STRING_WRITER.getBuffer();
    static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final WriterAppender APPENDER = new WriterAppender((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %p %.30c - %m%n"), (Writer)STRING_WRITER);
    private static final int MAX_BUFFER_LENGTH = 100000;
    private static final String CFQN = Category.class.getName();

    private TestLoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/TestLoggerFactory", "getLoggerInstance"));
        }
        if (!this.myInitialized) {
            this.init();
        }
        TestLogger testLogger = new TestLogger(Logger.getLogger((String)name));
        if (testLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TestLoggerFactory", "getLoggerInstance"));
        }
        return testLogger;
    }

    private void init() {
        try {
            File logXmlFile = new File(PathManager.getHomePath(), "test-log.xml");
            if (!logXmlFile.exists()) {
                logXmlFile = new File(PathManager.getBinPath(), "log.xml");
            }
            if (!logXmlFile.exists()) {
                return;
            }
            String logDir = TestLoggerFactory.getTestLogDir();
            String text = FileUtil.loadFile((File)logXmlFile);
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)logDir, (String)"\\", (String)"\\\\"));
            File logDirFile = new File(logDir);
            if (!logDirFile.mkdirs() && !logDirFile.exists()) {
                throw new IOException("Unable to create log dir: " + logDirFile);
            }
            System.setProperty("log4j.defaultInitOverride", "true");
            try {
                DOMConfigurator domConfigurator = new DOMConfigurator();
                domConfigurator.doConfigure((Reader)new StringReader(text), LogManager.getLoggerRepository());
            }
            catch (ClassCastException e) {
                System.err.println("log.xml content:\n" + text);
                throw e;
            }
            File ideaLog = new File(TestLoggerFactory.getTestLogDir(), "idea.log");
            if (ideaLog.exists() && ideaLog.length() >= 0x6400000L) {
                FileUtil.writeToFile((File)ideaLog, (String)"");
            }
            this.myInitialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTestLogDir() {
        return PathManager.getSystemPath() + "/" + LOG_DIR;
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) {
        if (testStartMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartMarker", "com/intellij/testFramework/TestLoggerFactory", "dumpLogToStdout"));
        }
        File ideaLog = new File(TestLoggerFactory.getTestLogDir(), "idea.log");
        if (ideaLog.exists()) {
            try {
                String logText;
                long length = ideaLog.length();
                if (length > 102400L) {
                    String[] stringArray = null;
                    try (RandomAccessFile file2 = new RandomAccessFile(ideaLog, "r");){
                        file2.seek(length - 102400L);
                        byte[] bytes = new byte[102400];
                        int read = file2.read(bytes);
                        logText = new String(bytes, 0, read);
                    }
                    catch (Throwable object) {
                        stringArray = object;
                        throw object;
                    }
                } else {
                    logText = FileUtil.loadFile((File)ideaLog);
                }
                System.out.println("\n\nIdea Log:");
                Pattern logStart = Pattern.compile("[0-9\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
                for (String line : StringUtil.splitByLines((String)logText.substring(Math.max(0, logText.lastIndexOf(testStartMarker))))) {
                    Matcher matcher = logStart.matcher(line);
                    int lineStart = matcher.lookingAt() ? matcher.end() : 0;
                    System.out.println(line.substring(lineStart));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/testFramework/TestLoggerFactory", "enableDebugLogging"));
        }
        if (categories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categories", "com/intellij/testFramework/TestLoggerFactory", "enableDebugLogging"));
        }
        for (String category : categories) {
            com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
            logger.setLevel(Level.DEBUG);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(@NotNull Logger logger, @NotNull Level level, @Nullable String message, @Nullable Throwable t) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/testFramework/TestLoggerFactory", "log"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/testFramework/TestLoggerFactory", "log"));
        }
        if (!UsefulTestCase.IS_UNDER_TEAMCITY) {
            // empty if block
        }
        LoggingEvent event = new LoggingEvent(CFQN, (Category)logger, (Priority)level, (Object)message, t);
        APPENDER.append(event);
        if (BUFFER.length() > 100000) {
            StringBuffer stringBuffer = BUFFER;
            synchronized (stringBuffer) {
                if (BUFFER.length() > 100000) {
                    BUFFER.delete(0, BUFFER.length() - 100000 + 25000);
                }
            }
        }
    }

    public static void onTestFinished(boolean success) {
        if (!success && BUFFER.length() != 0) {
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                BUFFER.insert(0, "##teamcity[blockOpened name='DEBUG log']\n");
                BUFFER.append("\n##teamcity[blockClosed name='DEBUG log']\n");
                System.err.println(BUFFER);
            } else {
                String[] lines = LineTokenizer.tokenize((CharSequence)BUFFER, (boolean)false, (boolean)false);
                String text = StringUtil.join((String[])lines, (String)"\u2003\n");
                if (!text.startsWith("\n")) {
                    text = "\n" + text;
                }
                System.err.println(text);
            }
        }
        BUFFER.setLength(0);
    }
}

