/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testIntegration.LanguageTestCreators;
import com.intellij.testIntegration.TestCreator;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTestOrCodeHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.testOrCode";
    }

    @Override
    @Nullable
    protected GotoTargetHandler.GotoData getSourceAndTargetElements(final Editor editor, final PsiFile file2) {
        Collection<PsiElement> candidates;
        PsiElement selectedElement = GotoTestOrCodeHandler.getSelectedElement(editor, file2);
        PsiElement sourceElement = TestFinderHelper.findSourceElement(selectedElement);
        if (sourceElement == null) {
            return null;
        }
        SmartList actions = new SmartList();
        if (TestFinderHelper.isTest(selectedElement)) {
            candidates = TestFinderHelper.findClassesForTest(selectedElement);
        } else {
            candidates = TestFinderHelper.findTestsForClass(selectedElement);
            final TestCreator creator = (TestCreator)LanguageTestCreators.INSTANCE.forLanguage(file2.getLanguage());
            if (creator != null && creator.isAvailable(file2.getProject(), editor, file2)) {
                actions.add(new GotoTargetHandler.AdditionalAction(){

                    @Override
                    @NotNull
                    public String getText() {
                        if ("Create New Test..." == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler$1", "getText"));
                        }
                        return "Create New Test...";
                    }

                    @Override
                    public Icon getIcon() {
                        return AllIcons.Actions.IntentionBulb;
                    }

                    @Override
                    public void execute() {
                        creator.createTest(file2.getProject(), editor, file2);
                    }
                });
            }
        }
        return new GotoTargetHandler.GotoData(sourceElement, PsiUtilCore.toPsiElementArray(candidates), (List<GotoTargetHandler.AdditionalAction>)actions);
    }

    @NotNull
    public static PsiElement getSelectedElement(Editor editor, PsiFile file2) {
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getSelectedElement"));
        }
        return psiElement;
    }

    @Override
    protected boolean shouldSortTargets() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished) {
        String suffix;
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getChooserTitle"));
        }
        String string = suffix = finished ? "" : " so far";
        if (TestFinderHelper.isTest(sourceElement)) {
            String string2 = CodeInsightBundle.message((String)"goto.test.chooserTitle.subject", (Object[])new Object[]{name, length, suffix});
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getChooserTitle"));
            }
            return string2;
        }
        String string3 = CodeInsightBundle.message((String)"goto.test.chooserTitle.test", (Object[])new Object[]{name, length, suffix});
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getChooserTitle"));
        }
        return string3;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getFindUsagesTitle"));
        }
        if (TestFinderHelper.isTest(sourceElement)) {
            String string = CodeInsightBundle.message((String)"goto.test.findUsages.subject.title", (Object[])new Object[]{name});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getFindUsagesTitle"));
            }
            return string;
        }
        String string = CodeInsightBundle.message((String)"goto.test.findUsages.test.title", (Object[])new Object[]{name});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        String string = CodeInsightBundle.message((String)"goto.test.notFound", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/GotoTestOrCodeHandler", "getNotFoundMessage"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getAdText(PsiElement source, int length) {
        Keymap keymap;
        Shortcut[] shortcuts;
        if (length > 0 && !TestFinderHelper.isTest(source) && (shortcuts = (keymap = KeymapManager.getInstance().getActiveKeymap()).getShortcuts(DefaultRunExecutor.getRunExecutorInstance().getContextActionId())).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to run selected tests";
        }
        return null;
    }

    @Override
    protected void navigateToElement(@NotNull Navigatable element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testIntegration/GotoTestOrCodeHandler", "navigateToElement"));
        }
        if (element instanceof PsiElement) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element, true);
        } else {
            element.navigate(true);
        }
    }
}

