/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.PrivacyPolicy;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static final int MIN_ICON_SIZE = 32;

    public static void updateWindowIcon(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ui/AppUIUtil", "updateWindowIcon"));
        }
        window.setIconImages(AppUIUtil.getAppIconImages());
    }

    private static List<Image> getAppIconImages() {
        String bigIconUrl;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ArrayList images = ContainerUtil.newArrayListWithCapacity((int)3);
        if (SystemInfo.isUnix && (bigIconUrl = appInfo.getBigIconUrl()) != null) {
            images.add(ImageLoader.loadFromResource((String)bigIconUrl));
        }
        images.add(ImageLoader.loadFromResource((String)appInfo.getIconUrl()));
        images.add(ImageLoader.loadFromResource((String)appInfo.getSmallIconUrl()));
        for (int i2 = 0; i2 < images.size(); ++i2) {
            Image image = (Image)images.get(i2);
            if (!(image instanceof JBHiDPIScaledImage)) continue;
            images.set(i2, ((JBHiDPIScaledImage)image).getDelegate());
        }
        return images;
    }

    public static void invokeLaterIfProjectAlive(@NotNull Project project2, @NotNull Runnable runnable2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "invokeLaterIfProjectAlive"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/AppUIUtil", "invokeLaterIfProjectAlive"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, o -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "lambda$invokeLaterIfProjectAlive$0"));
                }
                return !project2.isOpen() || project2.isDisposed();
            });
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    public static void invokeOnEdt(Runnable runnable2, @Nullable Condition expired) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFrameClass() {
        String name = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        String wmClass = VENDOR_PREFIX + StringUtil.replaceChar((String)name, (char)' ', (char)'-');
        if ("true".equals(System.getProperty("idea.debug.mode"))) {
            wmClass = wmClass + "-debug";
        }
        return PlatformUtils.isCommunityEdition() ? wmClass + "-ce" : wmClass;
    }

    public static void registerBundledFonts() {
        if (SystemProperties.getBooleanProperty((String)"ide.register.bundled.fonts", (boolean)true)) {
            AppUIUtil.registerFont("/fonts/Inconsolata.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Regular.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Bold.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-It.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-BoldIt.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Regular.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Bold.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Light.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Medium.ttf");
            AppUIUtil.registerFont("/fonts/FiraCode-Retina.ttf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFont(@NonNls String name) {
        URL url = AppUIUtil.class.getResource(name);
        if (url == null) {
            Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            return;
        }
        try (InputStream is = url.openStream();){
            Font font = Font.createFont(0, is);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Throwable t) {
            Logger.getInstance(AppUIUtil.class).warn("Cannot register font: " + url, t);
        }
    }

    public static void hideToolWindowBalloon(@NotNull String id, @NotNull Project project2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ui/AppUIUtil", "hideToolWindowBalloon"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "hideToolWindowBalloon"));
        }
        AppUIUtil.invokeLaterIfProjectAlive(project2, () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "lambda$hideToolWindowBalloon$1"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ui/AppUIUtil", "lambda$hideToolWindowBalloon$1"));
            }
            Balloon balloon = ToolWindowManager.getInstance((Project)project2).getToolWindowBalloon(id);
            if (balloon != null) {
                balloon.hide();
            }
        });
    }

    @Nullable
    public static String findIcon(@NotNull String iconsPath) {
        String[] childFiles;
        if (iconsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconsPath", "com/intellij/ui/AppUIUtil", "findIcon"));
        }
        for (String child : childFiles = (String[])ObjectUtils.notNull((Object)new File(iconsPath).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY)) {
            if (!child.endsWith(".svg")) continue;
            return iconsPath + '/' + child;
        }
        int best = 31;
        String iconPath = null;
        for (String child : childFiles) {
            String path;
            ImageIcon icon;
            int size;
            if (!child.endsWith(".png") || (size = (icon = new ImageIcon(path = iconsPath + '/' + child)).getIconHeight()) <= best || size != icon.getIconWidth()) continue;
            best = size;
            iconPath = path;
        }
        return iconPath;
    }

    public static void showPrivacyPolicy() {
        Pair policy;
        if (ApplicationInfoImpl.getShadowInstance().isVendorJetBrains() && !PrivacyPolicy.isVersionAccepted((PrivacyPolicy.Version)((PrivacyPolicy.Version)(policy = PrivacyPolicy.getContent()).getFirst()))) {
            try {
                SwingUtilities.invokeAndWait(() -> AppUIUtil.showPrivacyPolicyAgreement((String)policy.getSecond()));
                PrivacyPolicy.setVersionAccepted((PrivacyPolicy.Version)((PrivacyPolicy.Version)policy.getFirst()));
            }
            catch (Exception e) {
                Logger.getInstance(AppUIUtil.class).warn((Throwable)e);
            }
        }
    }

    public static void showPrivacyPolicyAgreement(final @NotNull String htmlText) {
        if (htmlText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlText", "com/intellij/ui/AppUIUtil", "showPrivacyPolicyAgreement"));
        }
        DialogWrapper dialog2 = new DialogWrapper(true){

            @Nullable
            protected JComponent createCenterPanel() {
                JPanel centerPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
                final JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                viewer.setFocusable(true);
                viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        URL url = e.getURL();
                        if (url != null) {
                            BrowserUtil.browse((URL)url);
                        } else {
                            SwingHelper.scrollToReference(viewer, e.getDescription());
                        }
                    }
                });
                viewer.setText(htmlText);
                StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUI.scaleFontSize((int)13) + "pt;}");
                styleSheet.addRule("h2, em {margin-top:" + JBUI.scaleFontSize((int)20) + "pt;}");
                styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
                styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUI.scaleFontSize((int)6) + "pt;}");
                styleSheet.addRule("li {margin-bottom:" + JBUI.scaleFontSize((int)6) + "pt;}");
                styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUI.scaleFontSize((int)13) + "pt;}");
                viewer.setCaretPosition(0);
                viewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                centerPanel.add((Component)new JLabel("Please read and accept these terms and conditions:"), "North");
                centerPanel.add((Component)new JBScrollPane((Component)viewer, 20, 31), "Center");
                return centerPanel;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setOKButtonText("Accept");
                this.setCancelButtonText("Reject and Exit");
                this.setAutoAdjustable(false);
            }

            public void doCancelAction() {
                super.doCancelAction();
                ApplicationEx application = ApplicationManagerEx.getApplicationEx();
                if (application == null) {
                    System.exit(11);
                } else {
                    ((ApplicationImpl)application).exit(true, true, false);
                }
            }
        };
        dialog2.setModal(true);
        dialog2.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " Privacy Policy Agreement");
        dialog2.setSize(JBUI.scale((int)509), JBUI.scale((int)395));
        dialog2.show();
    }
}

