/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ComboBoxCompositeEditor<I, F extends JComponent>
extends JPanel
implements ComboBoxEditor {
    private BiConsumer<I, F> myOnSetItemHandler = null;
    private BiFunction<I, F, I> myOnGetItemHandler = null;
    private ComboBoxCompositeEditorStrategy editorTextFieldStrategy = new ComboBoxCompositeEditorStrategy(){
        BiConsumer<I, EditorTextField> defaultOnSetHandler = (anObject, component) -> component.setText(anObject == null ? "" : anObject.toString());

        @Override
        public void setItem(F component, I anObject) {
            if (ComboBoxCompositeEditor.this.myOnSetItemHandler == null) {
                this.defaultOnSetHandler.accept(anObject, (EditorTextField)component);
            } else {
                ComboBoxCompositeEditor.this.myOnSetItemHandler.accept(anObject, component);
            }
        }

        @Override
        public I getItem(F component, I anObject) {
            if (ComboBoxCompositeEditor.this.myOnGetItemHandler == null) {
                return anObject;
            }
            return ComboBoxCompositeEditor.this.myOnGetItemHandler.apply(anObject, component);
        }

        public void selectAll(JComponent component) {
            ((EditorTextField)((Object)component)).selectAll();
        }

        public void addActionListener(JComponent component, ActionListener l) {
        }

        public void removeActionListener(JComponent component, ActionListener l) {
        }
    };
    private ComboBoxCompositeEditorStrategy jTextFieldStrategy = new ComboBoxCompositeEditorStrategy(){
        BiConsumer<I, JTextField> defaultOnSetHandler = (anObject, component) -> component.setText(anObject == null ? "" : anObject.toString());

        @Override
        public void setItem(F component, I anObject) {
            if (ComboBoxCompositeEditor.this.myOnSetItemHandler == null) {
                this.defaultOnSetHandler.accept(anObject, (JTextField)component);
            } else {
                ComboBoxCompositeEditor.this.myOnSetItemHandler.accept(anObject, component);
            }
        }

        @Override
        public I getItem(F component, I anObject) {
            if (ComboBoxCompositeEditor.this.myOnGetItemHandler == null) {
                return anObject;
            }
            return ComboBoxCompositeEditor.this.myOnGetItemHandler.apply(anObject, component);
        }

        public void selectAll(JComponent component) {
            ((JTextField)component).selectAll();
        }

        public void addActionListener(JComponent component, ActionListener l) {
            ((JTextField)component).addActionListener(l);
        }

        public void removeActionListener(JComponent component, ActionListener l) {
            ((JTextField)component).removeActionListener(l);
        }
    };
    private final EditorComponent<F, I> myComponent;

    public static <ItemType, EditableComponentType extends JComponent> ComboBoxCompositeEditor<ItemType, EditableComponentType> withComponents(EditableComponentType editableComponent, JComponent ... components) {
        return new ComboBoxCompositeEditor(editableComponent, components);
    }

    public ComboBoxCompositeEditor<I, F> onSetItem(BiConsumer<I, F> onSetItemHandler) {
        this.myOnSetItemHandler = onSetItemHandler;
        return this;
    }

    public ComboBoxCompositeEditor<I, F> onGetItem(BiFunction<I, F, I> onGetItemHandler) {
        this.myOnGetItemHandler = onGetItemHandler;
        return this;
    }

    private ComboBoxCompositeEditorStrategy getStrategy(F focuasbleComponent) {
        ComboBoxCompositeEditorStrategy strategy = null;
        if (focuasbleComponent instanceof JTextField) {
            strategy = this.jTextFieldStrategy;
        } else if (focuasbleComponent instanceof EditorTextField) {
            strategy = this.editorTextFieldStrategy;
        }
        return strategy;
    }

    public ComboBoxCompositeEditor(F editableComponent, JComponent ... components) {
        assert (components.length > 0);
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridy = 0;
        c.anchor = 10;
        c.ipadx = 0;
        c.ipady = 0;
        c.gridx = 0;
        this.add((Component)editableComponent, c);
        c.weightx = 0.0;
        for (int i2 = 0; i2 < components.length; ++i2) {
            c.gridx = i2 + 1;
            components[i2].setBackground(this.getBackground());
            this.add((Component)components[i2], c);
        }
        final ComboBoxCompositeEditorStrategy strategy = this.getStrategy(editableComponent);
        this.myComponent = new EditorComponent<F, I>((JComponent)editableComponent){
            I myItem;
            final /* synthetic */ JComponent val$editableComponent;
            {
                this.val$editableComponent = jComponent;
            }

            @Override
            public void setItem(I anObject) {
                this.myItem = anObject;
                strategy.setItem(this.val$editableComponent, anObject);
            }

            @Override
            public I getItem() {
                return strategy.getItem(this.val$editableComponent, this.myItem);
            }

            @Override
            public void selectAll() {
                strategy.selectAll(this.val$editableComponent);
            }

            @Override
            public void addActionListener(ActionListener l) {
                strategy.addActionListener(this.val$editableComponent, l);
            }

            @Override
            public void removeActionListener(ActionListener l) {
                strategy.removeActionListener(this.val$editableComponent, l);
            }

            @Override
            public JComponent getDelegate() {
                return this.val$editableComponent;
            }
        };
        this.invalidate();
        ((JComponent)editableComponent).setBorder(null);
        ((Component)editableComponent).addFocusListener(new FocusListener(){
            Component parent = null;

            @Override
            public void focusGained(FocusEvent e) {
                this.parent = ComboBoxCompositeEditor.this.getParent();
                this.parent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.parent.repaint();
            }
        });
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public void setItem(Object anObject) {
        this.myComponent.setItem(anObject);
    }

    @Override
    public Object getItem() {
        return this.myComponent.getItem();
    }

    @Override
    public void selectAll() {
        this.myComponent.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.myComponent.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.myComponent.removeActionListener(l);
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    abstract class ComboBoxCompositeEditorStrategy {
        ComboBoxCompositeEditorStrategy() {
        }

        abstract void setItem(F var1, I var2);

        abstract void selectAll(F var1);

        abstract void addActionListener(F var1, ActionListener var2);

        abstract void removeActionListener(F var1, ActionListener var2);

        abstract I getItem(F var1, I var2);
    }

    public static interface EditorComponent<F, I> {
        public void setItem(I var1);

        public I getItem();

        public void selectAll();

        public void addActionListener(ActionListener var1);

        public void removeActionListener(ActionListener var1);

        public JComponent getDelegate();
    }
}

