/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorNotificationsImpl
extends EditorNotifications {
    private static final ExtensionPointName<EditorNotifications.Provider> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.editorNotificationProvider");
    private static final Key<WeakReference<ProgressIndicator>> CURRENT_UPDATES = Key.create((String)"CURRENT_UPDATES");
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"EditorNotificationsImpl pool");
    private final MergingUpdateQueue myUpdateMerger;

    public EditorNotificationsImpl(Project project2) {
        super(project2);
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project2);
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ui/EditorNotificationsImpl$1", "fileOpened"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl$1", "fileOpened"));
                }
                EditorNotificationsImpl.this.updateNotifications(file2);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl", "updateNotifications"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl", "lambda$updateNotifications$0"));
            }
            ProgressIndicator indicator = EditorNotificationsImpl.getCurrentProgress(file2);
            if (indicator != null) {
                indicator.cancel();
            }
            file2.putUserData(CURRENT_UPDATES, null);
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            indicator = new ProgressIndicatorBase();
            ReadTask task = this.createTask(indicator, file2);
            if (task == null) {
                return;
            }
            file2.putUserData(CURRENT_UPDATES, new WeakReference<ProgressIndicator>(indicator));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ReadTask.Continuation continuation = task.performInReadAction(indicator);
                if (continuation != null) {
                    continuation.getAction().run();
                }
            } else {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(indicator, ourExecutor, task);
            }
        });
    }

    @Nullable
    private ReadTask createTask(final @NotNull ProgressIndicator indicator, final @NotNull VirtualFile file2) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ui/EditorNotificationsImpl", "createTask"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl", "createTask"));
        }
        final List editors = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor -> !(editor instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor).getEditor()));
        if (editors.isEmpty()) {
            return null;
        }
        return new ReadTask(){

            private boolean isOutdated() {
                if (EditorNotificationsImpl.this.myProject.isDisposed() || !file2.isValid() || indicator != EditorNotificationsImpl.getCurrentProgress(file2)) {
                    return true;
                }
                for (FileEditor editor : editors) {
                    if (editor.isValid()) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
                if (indicator2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ui/EditorNotificationsImpl$3", "performInReadAction"));
                }
                if (this.isOutdated()) {
                    return null;
                }
                List providers = DumbService.getInstance((Project)EditorNotificationsImpl.this.myProject).filterByDumbAwareness(EXTENSION_POINT_NAME.getExtensions((AreaInstance)EditorNotificationsImpl.this.myProject));
                ArrayList updates = ContainerUtil.newArrayList();
                for (FileEditor editor : editors) {
                    for (EditorNotifications.Provider provider : providers) {
                        JComponent component = provider.createNotificationPanel(file2, editor);
                        updates.add(() -> EditorNotificationsImpl.this.updateNotification(editor, (Key<? extends JComponent>)provider.getKey(), component));
                    }
                }
                return new ReadTask.Continuation(() -> {
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ui/EditorNotificationsImpl$3", "lambda$performInReadAction$1"));
                    }
                    if (!this.isOutdated()) {
                        file2.putUserData(CURRENT_UPDATES, null);
                        for (Runnable update : updates) {
                            update.run();
                        }
                    }
                }, ModalityState.any());
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator ignored) {
                if (ignored == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/ui/EditorNotificationsImpl$3", "onCanceled"));
                }
                if (EditorNotificationsImpl.getCurrentProgress(file2) == indicator) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        };
    }

    private static ProgressIndicator getCurrentProgress(VirtualFile file2) {
        return (ProgressIndicator)SoftReference.dereference((Reference)((Reference)file2.getUserData(CURRENT_UPDATES)));
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key2, @Nullable JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/EditorNotificationsImpl", "updateNotification"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/ui/EditorNotificationsImpl", "updateNotification"));
        }
        JComponent old = (JComponent)editor.getUserData(key2);
        if (old != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component != null) {
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component);
            Key<? extends JComponent> _key = key2;
            editor.putUserData(_key, (Object)component);
        } else {
            editor.putUserData(key2, null);
        }
    }

    public void updateAllNotifications() {
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : FileEditorManager.getInstance((Project)EditorNotificationsImpl.this.myProject).getOpenFiles()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }
}

