/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    private final List<Pair<String, JComponent>> myTabs = new ArrayList<Pair<String, JComponent>>();
    private String myPrefix;

    public TabbedContentImpl(JComponent component, String displayName, boolean isPinnable, String titlePrefix) {
        super(component, displayName, isPinnable);
        this.myPrefix = titlePrefix;
        this.addContent(component, displayName, true);
    }

    public void addContent(@NotNull JComponent content, @NotNull String name, boolean selectTab) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/TabbedContentImpl", "addContent"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/content/impl/TabbedContentImpl", "addContent"));
        }
        Pair tab = Pair.create((Object)name, (Object)content);
        if (!this.myTabs.contains(tab)) {
            this.myTabs.add((Pair<String, JComponent>)tab);
        }
        if (selectTab && this.getComponent() != content) {
            this.setComponent(content);
        }
    }

    @Override
    public void setComponent(JComponent component) {
        Container parent;
        JComponent currentComponent = this.getComponent();
        Container container = parent = currentComponent == null ? null : currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component);
        }
        super.setComponent(component);
    }

    public void removeContent(@NotNull JComponent content) {
        int index;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/TabbedContentImpl", "removeContent"));
        }
        Pair<String, JComponent> toRemove = null;
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != content) continue;
            toRemove = tab;
            break;
        }
        if ((index = this.myTabs.indexOf(toRemove)) != -1) {
            this.myTabs.remove(index);
            int n = index = index > 0 ? index - 1 : index;
            if (index < this.myTabs.size()) {
                this.selectContent(index);
            }
        }
    }

    public void renameContent(@NotNull JComponent tab, @NotNull String newTabName) {
        int index;
        if (tab == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tab", "com/intellij/ui/content/impl/TabbedContentImpl", "renameContent"));
        }
        if (newTabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTabName", "com/intellij/ui/content/impl/TabbedContentImpl", "renameContent"));
        }
        Pair<String, JComponent> toRemove = null;
        for (Pair<String, JComponent> existingTab : this.myTabs) {
            if (existingTab.second != tab) continue;
            toRemove = existingTab;
            break;
        }
        if ((index = this.myTabs.indexOf(toRemove)) != -1) {
            this.myTabs.remove(index);
        }
        this.myTabs.add((Pair<String, JComponent>)Pair.create((Object)newTabName, (Object)tab));
        if (this.getComponent() == tab) {
            super.setDisplayName(newTabName);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getTabName();
    }

    public void selectContent(int index) {
        Pair<String, JComponent> tab = this.myTabs.get(index);
        this.setDisplayName((String)tab.first);
        this.setComponent((JComponent)tab.second);
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/ui/content/impl/TabbedContentImpl", "findAndSelectContent"));
        }
        String tabName = this.findTabNameByComponent(contentComponent);
        if (tabName != null) {
            this.setDisplayName(tabName);
            this.setComponent(contentComponent);
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        String selected = this.findTabNameByComponent(this.getComponent());
        if (this.myPrefix != null) {
            selected = this.myPrefix + ": " + selected;
        }
        return selected;
    }

    private String findTabNameByComponent(JComponent c) {
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != c) continue;
            return (String)tab.first;
        }
        return null;
    }

    public List<Pair<String, JComponent>> getTabs() {
        return Collections.unmodifiableList(this.myTabs);
    }

    public String getTitlePrefix() {
        return this.myPrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.myPrefix = titlePrefix;
    }

    @Override
    public void setIcon(Icon icon) {
        for (Pair<String, JComponent> nextTabWithName : this.getTabs()) {
            JComponent tab;
            String name = this.getTabName();
            if (name == null || !((String)nextTabWithName.getFirst()).equals(ContentUtilEx.getTabNameWithoutPrefix(this, name)) || !((tab = (JComponent)nextTabWithName.getSecond()) instanceof Iconable)) continue;
            Icon baseIcon = ((Iconable)tab).getIcon(1);
            super.setIcon(this.isSelected() || baseIcon == null ? baseIcon : new WatermarkIcon(baseIcon, 0.5f));
            break;
        }
    }

    public void split() {
        ArrayList<Pair<String, JComponent>> copy = new ArrayList<Pair<String, JComponent>>(this.myTabs);
        int selectedTab = ContentUtilEx.getSelectedTab(this);
        ContentManager manager = this.getManager();
        String prefix = this.getTitlePrefix();
        manager.removeContent((Content)this, false);
        PropertiesComponent.getInstance().setValue("tabbed.toolwindow.expanded." + prefix, Boolean.TRUE.toString());
        for (int i2 = 0; i2 < copy.size(); ++i2) {
            boolean select = i2 == selectedTab;
            JComponent component = (JComponent)((Pair)copy.get((int)i2)).second;
            String tabName = (String)((Pair)copy.get((int)i2)).first;
            ContentUtilEx.addTabbedContent(manager, component, prefix, tabName, select);
        }
        this.setShouldDisposeContent(false);
        Disposer.dispose((Disposable)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTabs.clear();
    }
}

