/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.picker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPipetteBase;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Native;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacColorPipette
extends ColorPipetteBase {
    private static final Logger LOG = Logger.getInstance(MacColorPipette.class);
    private static final int PIXELS = 17;
    private static final int ZOOM = 10;
    private static final int SIZE = 170;
    private static final int DIALOG_SIZE = 190;
    private final Color myTransparentColor;

    public MacColorPipette(@NotNull ColorPicker picker, @NotNull ColorListener listener2) {
        if (picker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "picker", "com/intellij/ui/picker/MacColorPipette", "<init>"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/picker/MacColorPipette", "<init>"));
        }
        super(picker, listener2);
        this.myTransparentColor = new Color(0, 0, 0, 1);
    }

    @Override
    @NotNull
    protected Dialog getOrCreatePickerDialog() {
        Dialog pickerDialog = this.getPickerDialog();
        if (pickerDialog == null) {
            pickerDialog = super.getOrCreatePickerDialog();
            pickerDialog.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    super.keyPressed(event);
                    int diff = BitUtil.isSet((int)event.getModifiers(), (int)1) ? 10 : 1;
                    Point location = MacColorPipette.this.updateLocation();
                    if (MacColorPipette.this.myRobot != null && location != null) {
                        switch (event.getKeyCode()) {
                            case 40: {
                                MacColorPipette.this.myRobot.mouseMove(location.x, location.y + diff);
                                break;
                            }
                            case 38: {
                                MacColorPipette.this.myRobot.mouseMove(location.x, location.y - diff);
                                break;
                            }
                            case 37: {
                                MacColorPipette.this.myRobot.mouseMove(location.x - diff, location.y);
                                break;
                            }
                            case 39: {
                                MacColorPipette.this.myRobot.mouseMove(location.x + diff, location.y);
                            }
                        }
                        MacColorPipette.this.updateLocation();
                    }
                }
            });
            JLabel label = new JLabel(){

                @Override
                public void paint(Graphics g) {
                    MacColorPipette.applyRenderingHints(g);
                    Dialog pickerDialog = MacColorPipette.this.getPickerDialog();
                    if (pickerDialog != null && pickerDialog.isShowing()) {
                        Point mouseLoc = MacColorPipette.this.updateLocation();
                        if (mouseLoc == null) {
                            return;
                        }
                        int left = 9;
                        Rectangle captureRectangle = new Rectangle(mouseLoc.x - left, mouseLoc.y - left, 17, 17);
                        BufferedImage captureScreen = MacColorPipette.captureScreen(pickerDialog, captureRectangle);
                        if (captureScreen == null || captureScreen.getWidth() < 17 || captureRectangle.getHeight() < 17.0) {
                            MacColorPipette.this.cancelPipette();
                            return;
                        }
                        Color newColor = new Color(captureScreen.getRGB(captureRectangle.width / 2, captureRectangle.height / 2));
                        Graphics2D graphics2d = (Graphics2D)g;
                        Point offset = new Point(10, 10);
                        graphics2d.setComposite(AlphaComposite.Clear);
                        graphics2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                        graphics2d.setComposite(AlphaComposite.Src);
                        graphics2d.clip(new Ellipse2D.Double(offset.x, offset.y, 170.0, 170.0));
                        graphics2d.drawImage(captureScreen, offset.x, offset.y, 170, 170, this);
                        graphics2d.setComposite(AlphaComposite.SrcOver);
                        MacColorPipette.drawPixelGrid(graphics2d, offset);
                        MacColorPipette.drawCenterPixel(graphics2d, offset, newColor);
                        MacColorPipette.drawCurrentColorRectangle(graphics2d, offset, newColor);
                        graphics2d.setClip(0, 0, this.getWidth(), this.getHeight());
                        MacColorPipette.drawMagnifierBorder(newColor, graphics2d, offset);
                        pickerDialog.repaint();
                        if (!newColor.equals(MacColorPipette.this.getColor())) {
                            MacColorPipette.this.setColor(newColor);
                            MacColorPipette.this.notifyListener(newColor, 300);
                        }
                    }
                }
            };
            pickerDialog.add(label);
            pickerDialog.setSize(190, 190);
            pickerDialog.setBackground(this.myTransparentColor);
            BufferedImage emptyImage = UIUtil.createImage((int)1, (int)1, (int)3);
            pickerDialog.setCursor(this.myParent.getToolkit().createCustomCursor(emptyImage, new Point(0, 0), "ColorPicker"));
        }
        Dialog dialog2 = pickerDialog;
        if (dialog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/picker/MacColorPipette", "getOrCreatePickerDialog"));
        }
        return dialog2;
    }

    private static void applyRenderingHints(@NotNull Graphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/ui/picker/MacColorPipette", "applyRenderingHints"));
        }
        UIUtil.applyRenderingHints((Graphics)graphics);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    private static void drawCurrentColorRectangle(@NotNull Graphics2D graphics, @NotNull Point offset, @NotNull Color currentColor) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/ui/picker/MacColorPipette", "drawCurrentColorRectangle"));
        }
        if (offset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offset", "com/intellij/ui/picker/MacColorPipette", "drawCurrentColorRectangle"));
        }
        if (currentColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentColor", "com/intellij/ui/picker/MacColorPipette", "drawCurrentColorRectangle"));
        }
        graphics.setColor(Gray._0.withAlpha(150));
        int x = 42 + offset.x;
        int y = 127 + offset.y;
        int width = 85;
        int height = 21;
        graphics.fillRoundRect(x, y, width, height, 10, 10);
        graphics.setColor((Color)Gray._255);
        String colorString = currentColor.getRed() + " " + currentColor.getGreen() + " " + currentColor.getBlue();
        FontMetrics metrics = graphics.getFontMetrics();
        int stringWidth = metrics.stringWidth(colorString);
        int stringHeight = metrics.getHeight();
        graphics.drawString(colorString, x + (width - stringWidth) / 2, y + stringHeight);
    }

    private static void drawCenterPixel(@NotNull Graphics2D graphics, @NotNull Point offset, @NotNull Color currentColor) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/ui/picker/MacColorPipette", "drawCenterPixel"));
        }
        if (offset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offset", "com/intellij/ui/picker/MacColorPipette", "drawCenterPixel"));
        }
        if (currentColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentColor", "com/intellij/ui/picker/MacColorPipette", "drawCenterPixel"));
        }
        graphics.setColor(ColorUtil.isDark((Color)currentColor) ? Gray._255.withAlpha(150) : Gray._0.withAlpha(150));
        graphics.drawRect(80 + offset.x, 80 + offset.y, 10, 10);
    }

    private static void drawPixelGrid(@NotNull Graphics2D graphics, @NotNull Point offset) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/ui/picker/MacColorPipette", "drawPixelGrid"));
        }
        if (offset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offset", "com/intellij/ui/picker/MacColorPipette", "drawPixelGrid"));
        }
        graphics.setColor(Gray._0.withAlpha(10));
        for (int i2 = 0; i2 < 17; ++i2) {
            int cellOffset = i2 * 10;
            graphics.drawLine(cellOffset + offset.x, offset.y, cellOffset + offset.x, 170 + offset.y);
            graphics.drawLine(offset.x, cellOffset + offset.y, 170 + offset.x, cellOffset + offset.y);
        }
    }

    private static void drawMagnifierBorder(@NotNull Color currentColor, @NotNull Graphics2D graphics, @NotNull Point offset) {
        if (currentColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentColor", "com/intellij/ui/picker/MacColorPipette", "drawMagnifierBorder"));
        }
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/intellij/ui/picker/MacColorPipette", "drawMagnifierBorder"));
        }
        if (offset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offset", "com/intellij/ui/picker/MacColorPipette", "drawMagnifierBorder"));
        }
        graphics.setColor(currentColor.darker());
        graphics.setStroke(new BasicStroke(5.0f));
        graphics.draw(new Ellipse2D.Double(offset.x, offset.y, 170.0, 170.0));
    }

    @Override
    public boolean isAvailable() {
        return MacColorPipette.captureScreen(null, new Rectangle(0, 0, 1, 1)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static BufferedImage captureScreen(@Nullable Window belowWindow, @NotNull Rectangle rect) {
        if (rect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rect", "com/intellij/ui/picker/MacColorPipette", "captureScreen"));
        }
        ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
        try {
            ID windowId = belowWindow != null ? MacUtil.findWindowFromJavaWindow((Window)belowWindow) : null;
            Foundation.NSRect nsRect = new Foundation.NSRect((double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
            ID cgWindowId = windowId != null ? Foundation.invoke((ID)windowId, (String)"windowNumber", (Object[])new Object[0]) : ID.NIL;
            int windowListOptions = cgWindowId != null ? 4 : 0;
            int windowImageOptions = 16;
            ID cgImageRef = Foundation.cgWindowListCreateImage((Foundation.NSRect)nsRect, (int)windowListOptions, (ID)cgWindowId, (int)windowImageOptions);
            ID bitmapRep = Foundation.invoke((ID)Foundation.invoke((String)"NSBitmapImageRep", (String)"alloc", (Object[])new Object[0]), (String)"initWithCGImage:", (Object[])new Object[]{cgImageRef});
            ID nsImage = Foundation.invoke((ID)Foundation.invoke((String)"NSImage", (String)"alloc", (Object[])new Object[0]), (String)"init", (Object[])new Object[0]);
            Foundation.invoke((ID)nsImage, (String)"addRepresentation:", (Object[])new Object[]{bitmapRep});
            ID data = Foundation.invoke((ID)nsImage, (String)"TIFFRepresentation", (Object[])new Object[0]);
            ID bytes = Foundation.invoke((ID)data, (String)"bytes", (Object[])new Object[0]);
            ID length = Foundation.invoke((ID)data, (String)"length", (Object[])new Object[0]);
            ByteBuffer byteBuffer = Native.getDirectByteBuffer((long)bytes.longValue(), (long)length.longValue());
            Foundation.invoke((ID)nsImage, (String)"release", (Object[])new Object[0]);
            byte[] b = new byte[byteBuffer.remaining()];
            byteBuffer.get(b);
            BufferedImage result2 = ImageIO.read(new ByteArrayInputStream(b));
            if (result2 != null) {
                ColorSpace ics = ColorSpace.getInstance(1000);
                ColorConvertOp cco = new ColorConvertOp(ics, null);
                BufferedImage bufferedImage = cco.filter(result2, null);
                return bufferedImage;
            }
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        catch (Throwable t) {
            LOG.error(t);
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            Foundation.invoke((ID)pool, (String)"release", (Object[])new Object[0]);
        }
    }
}

