/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        ContentUtilEx.addTabbedContent(manager, contentComponent, groupPrefix, tabName, select, null);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select, @Nullable Disposable childDisposable) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupPrefix)) {
            Content content = ContentFactory.SERVICE.getInstance().createContent(contentComponent, ContentUtilEx.getFullName(groupPrefix, tabName), true);
            content.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
            content.putUserData(Content.TAB_GROUP_NAME_KEY, (Object)groupPrefix);
            for (Content c : manager.getContents()) {
                if (c.getComponent() != contentComponent) continue;
                if (select) {
                    manager.setSelectedContent(c);
                }
                return;
            }
            ContentUtilEx.addContent((ContentManager)manager, (Content)content, (boolean)select);
            ContentUtilEx.registerDisposable(content, childDisposable, contentComponent);
            return;
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(manager, groupPrefix);
        if (tabbedContent == null) {
            Disposable disposable = Disposer.newDisposable();
            tabbedContent = new TabbedContentImpl(contentComponent, tabName, true, groupPrefix);
            ContentsUtil.addOrReplaceContent((ContentManager)manager, (Content)tabbedContent, (boolean)select);
            Disposer.register((Disposable)tabbedContent, (Disposable)disposable);
        } else {
            for (Pair tab : new ArrayList(tabbedContent.getTabs())) {
                if (!Comparing.equal((Object)tab.second, (Object)contentComponent)) continue;
                tabbedContent.removeContent((JComponent)tab.second);
            }
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(contentComponent, tabName, true);
        }
        ContentUtilEx.registerDisposable((Content)tabbedContent, childDisposable, contentComponent);
    }

    private static void registerDisposable(@NotNull Content content, @Nullable Disposable childDisposable, @NotNull JComponent contentComponent) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "registerDisposable"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "registerDisposable"));
        }
        if (childDisposable != null) {
            Disposer.register((Disposable)content, (Disposable)childDisposable);
            assert (contentComponent.getClientProperty("TabContentDisposable") == null);
            contentComponent.putClientProperty("TabContentDisposable", childDisposable);
            Disposer.register((Disposable)childDisposable, () -> {
                if (contentComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "lambda$registerDisposable$0"));
                }
                contentComponent.putClientProperty("TabContentDisposable", null);
            });
        } else {
            Object disposableByKey = contentComponent.getClientProperty("TabContentDisposable");
            if (disposableByKey != null && disposableByKey instanceof Disposable) {
                Disposer.register((Disposable)content, (Disposable)((Disposable)disposableByKey));
            }
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager, @NotNull String groupPrefix) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "findTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "findTabbedContent"));
        }
        TabbedContent tabbedContent = null;
        for (Content content : manager.getContents()) {
            if (!(content instanceof TabbedContent) || !content.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix))) continue;
            tabbedContent = (TabbedContent)content;
            break;
        }
        return tabbedContent;
    }

    public static boolean isContentTab(@NotNull Content content, @NotNull String groupPrefix) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "isContentTab"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "isContentTab"));
        }
        return content instanceof TabbedContent && content.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix)) || groupPrefix.equals(content.getUserData(Content.TAB_GROUP_NAME_KEY));
    }

    @NotNull
    public static String getFullName(@NotNull String groupPrefix, @NotNull String tabName) {
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        String string = ContentUtilEx.getFullPrefix(groupPrefix) + tabName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        return string;
    }

    @NotNull
    private static String getFullPrefix(@NotNull String groupPrefix) {
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "getFullPrefix"));
        }
        String string = groupPrefix + ": ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ContentUtilEx", "getFullPrefix"));
        }
        return string;
    }

    public static boolean selectContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, boolean requestFocus) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "selectContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "selectContent"));
        }
        for (Content content : manager.getContents()) {
            if (content instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager.setSelectedContent(content, requestFocus);
                return true;
            }
            if (!Comparing.equal((Object)content.getComponent(), (Object)contentComponent)) continue;
            manager.setSelectedContent(content, requestFocus);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager, @NotNull Condition<JComponent> condition) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "findContentComponent"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/ContentUtilEx", "findContentComponent"));
        }
        for (Content content : manager.getContents()) {
            if (content instanceof TabbedContentImpl) {
                List<Pair<String, JComponent>> tabs = ((TabbedContentImpl)content).getTabs();
                for (Pair<String, JComponent> tab : tabs) {
                    if (!condition.value(tab.second)) continue;
                    return (JComponent)tab.second;
                }
                continue;
            }
            if (!condition.value((Object)content.getComponent())) continue;
            return content.getComponent();
        }
        return null;
    }

    public static int getSelectedTab(@NotNull TabbedContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "getSelectedTab"));
        }
        JComponent current = content.getComponent();
        int index = 0;
        for (Pair tab : content.getTabs()) {
            if (tab.second == current) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Nullable
    public static String getTabNameWithoutPrefix(@NotNull TabbedContent content, @NotNull String fullTabName) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "getTabNameWithoutPrefix"));
        }
        if (fullTabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullTabName", "com/intellij/util/ContentUtilEx", "getTabNameWithoutPrefix"));
        }
        String prefix = content.getTitlePrefix();
        return prefix == null ? fullTabName : StringUtil.trimStart((String)fullTabName, (String)ContentUtilEx.getFullPrefix(prefix));
    }
}

