/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.reference.SoftReference;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.ConstantsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u001a\u001c\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u001a\u0012\u0010\u0017\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u0019\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\n\u001a2\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u001e0 \u001a\n\u0010!\u001a\u00020\"*\u00020\n\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"cachedSaxBuilder", "Ljava/lang/ThreadLocal;", "Lcom/intellij/reference/SoftReference;", "Lorg/jdom/input/SAXBuilder;", "getSaxBuilder", "loadDocument", "Lorg/jdom/Document;", "reader", "Ljava/io/Reader;", "loadElement", "Lorg/jdom/Element;", "stream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "chars", "", "addOptionTag", "", "name", "", "value", "attribute", "element", "get", "getOrCreate", "isEmpty", "", "remove", "", "T", "transform", "Lkotlin/Function1;", "toByteArray", "", "projectModel-impl"})
public final class JdomKt {
    private static final ThreadLocal<SoftReference<SAXBuilder>> cachedSaxBuilder = new ThreadLocal();

    private static final SAXBuilder getSaxBuilder() {
        SoftReference<SAXBuilder> reference = cachedSaxBuilder.get();
        SAXBuilder saxBuilder = (SAXBuilder)SoftReference.dereference((Reference)((Reference)reference));
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setIgnoringBoundaryWhitespace(true);
            saxBuilder.setIgnoringElementContentWhitespace(true);
            saxBuilder.setEntityResolver((EntityResolver)getSaxBuilder.1.INSTANCE);
            cachedSaxBuilder.set((SoftReference<SAXBuilder>)new SoftReference((Object)saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    public static final Element loadElement(@NotNull CharSequence chars) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return JdomKt.loadElement((Reader)new CharSequenceReader(chars));
    }

    @NotNull
    public static final Element loadElement(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Element element = JdomKt.loadDocument(reader).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(reader).detachRootElement()");
        return element;
    }

    @NotNull
    public static final Element loadElement(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        Element element = JdomKt.loadDocument(new InputStreamReader(inputStream, charset)).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(stream.reader()).detachRootElement()");
        return element;
    }

    @NotNull
    public static final Element loadElement(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Charset charset = null;
        boolean bl = true;
        Closeable closeable = null;
        if (closeable != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bufferedReader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 0;
        boolean bl2 = true;
        Object var7_7 = null;
        if (var7_7 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buffered");
        }
        if (bl2 & true) {
            n = ConstantsKt.DEFAULT_BUFFER_SIZE;
        }
        Element element = JdomKt.loadDocument(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(Files.newIn\u2026er()).detachRootElement()");
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document loadDocument(Reader reader) {
        try {
            Document document = JdomKt.getSaxBuilder().build(reader);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"getSaxBuilder().build(reader)");
            Document document2 = document;
            return document2;
        }
        finally {
            reader.close();
        }
    }

    public static final boolean isEmpty(@Nullable Element $receiver) {
        return $receiver == null || JDOMUtil.isEmpty((Element)$receiver);
    }

    @NotNull
    public static final Element getOrCreate(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = $receiver.getChild(name);
        if (element == null) {
            element = new Element(name);
            $receiver.addContent(element);
        }
        return element;
    }

    @Nullable
    public static final Element get(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $receiver.getChild(name);
    }

    @NotNull
    public static final Element element(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = new Element(name);
        $receiver.addContent(element);
        return element;
    }

    @NotNull
    public static final Element attribute(@NotNull Element $receiver, @NotNull String name, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = $receiver.setAttribute(name, value);
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"setAttribute(name, value)");
        return element;
    }

    @NotNull
    public static final <T> List<T> remove(@NotNull Element $receiver, @NotNull String name, @NotNull Function1<? super Element, ? extends T> transform) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        SmartList result2 = new SmartList();
        Iterator groupIterator = $receiver.getContent((Filter)new ElementFilter(name)).iterator();
        while (groupIterator.hasNext()) {
            Element child;
            Element element = child = (Element)groupIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"child");
            result2.add(transform.invoke((Object)element));
            groupIterator.remove();
        }
        return (List)result2;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)((Parent)$receiver), (OutputStream)((OutputStream)out), (String)"\n");
        byte[] byArray = out.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    public static final void addOptionTag(@NotNull Element $receiver, @NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Element element = new Element("option");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        $receiver.addContent(element);
    }
}

